#ifndef __ARGFLAGS_H__
#define __ARGFLAGS_H__

/* these all apply to argflags[0] */
// first three bits signify byte#
#define VERSION_FLAG         0x00000008ul
#define ALL_FLAG             0x00000010ul
#define DEBUGSNMP_FLAG       0x00000020ul
#define NAME_FLAG            0x00000040ul
#define CK_VERSION_FLAG      argflags[0]&VERSION_FLAG
#define CK_ALL_FLAG          argflags[0]&ALL_FLAG
#define CK_DEBUGSNMP_FLAG    argflags[0]&DEBUGSNMP_FLAG
#define CK_NAME_FLAG         argflags[0]&NAME_FLAG
#define SET_NAME_FLAG        argflags[0]|=NAME_FLAG

#define MODEL_FLAG           0x00000080ul
#define CONTACT_FLAG         0x00000100ul
#define NETCONFIG_FLAG       0x00000200ul
#define HOSTMIB_FLAG         0x00000400ul
#define PRINTMIB_FLAG        0x00000800ul
#define VENDOR_FLAG          0x00001000ul
#define CK_MODEL_FLAG        argflags[0]&MODEL_FLAG
#define CK_CONTACT_FLAG      argflags[0]&CONTACT_FLAG
#define CK_NETCONFIG_FLAG    argflags[0]&NETCONFIG_FLAG
#define CK_HOSTMIB_FLAG      argflags[0]&HOSTMIB_FLAG
#define CK_PRINTMIB_FLAG     argflags[0]&PRINTMIB_FLAG
#define CK_VENDOR_FLAG       argflags[0]&VENDOR_FLAG
#define RST_CONTACT_FLAG     argflags[0]&=~CONTACT_FLAG;
#define RST_MODEL_FLAG       argflags[0]&=~MODEL_FLAG

#define GENERALMIB_FLAGS     0x00001F80ul
#define CK_GENERALMIB_FLAGS  argflags[0]&GENERALMIB_FLAGS

#define STORAGE_FLAG         0x00002000ul //hostmib
#define STATUS_FLAG          0x00004000ul //hostmib
#define MEMORY_FLAG          0x00008000ul //hostmib
#define CK_STORAGE_FLAG      argflags[0]&STORAGE_FLAG
#define CK_STATUS_FLAG       argflags[0]&STATUS_FLAG
#define CK_MEMORY_FLAG       argflags[0]&MEMORY_FLAG
#define RST_STATUS_FLAG      argflags[0]&=~STATUS_FLAG

#define HOSTMIB_FLAGS        0x0000E000ul
#define CK_HOSTMIB_FLAGS     argflags[0]&HOSTMIB_FLAGS

#define MEDIAPATH_FLAG       0x00010000ul //printmib
#define MAXPAPERSIZE_FLAG    0x00020000ul //printmib
#define ENGINESPEED_FLAG     0x00040000ul //printmib
#define DUPLEX_FLAG          0x00080000ul //printmib
#define MINPAPERSIZE_FLAG    0x00100000ul //printmib
#define MEDIAPATH_FLAGS      0x001F8000ul 
#define CK_MEDIAPATH_FLAG    argflags[0]&MEDIAPATH_FLAG
#define CK_MAXPAPERSIZE_FLAG argflags[0]&MAXPAPERSIZE_FLAG
#define CK_ENGINESPEED_FLAG  argflags[0]&ENGINESPEED_FLAG
#define CK_DUPLEX_FLAG       argflags[0]&DUPLEX_FLAG
#define CK_MINPAPERSIZE_FLAG argflags[0]&MINPAPERSIZE_FLAG
#define CK_MEDIAPATH_FLAGS   argflags[0]&MEDIAPATH_FLAGS


#define INPUTTRAY_FLAG       0x00200000ul //printmib
#define TABLOID_FLAG         0x00400000ul //printmib
#define A4_FLAG              0x00800000ul //printmib
#define B4_FLAG              0x01000000ul //printmib
#define EXECUTIVE_FLAG       0x02000000ul //printmib
#define A3_FLAG              0x04000000ul //printmib
#define B5_FLAG              0x08000000ul //printmib
#define LETTER_FLAG          0x10000000ul //printmib
#define LEGAL_FLAG           0x20000000ul //printmib
#define PAPERSIZE_FLAGS      0x2FC00000ul
#define INPUTTRAY_FLAGS      0x2FE00000ul
#define CK_INPUTTRAY_FLAG    argflags[0]&INPUTTRAY_FLAG 
#define CK_TABLOID_FLAG      argflags[0]&TABLOID_FLAG
#define CK_A4_FLAG           argflags[0]&A4_FLAG
#define CK_B4_FLAG           argflags[0]&B4_FLAG 
#define CK_EXECUTIVE_FLAG    argflags[0]&EXECUTIVE_FLAG
#define CK_A3_FLAG           argflags[0]&A3_FLAG
#define CK_B5_FLAG           argflags[0]&B5_FLAG
#define CK_LETTER_FLAG       argflags[0]&LETTER_FLAG 
#define CK_LEGAL_FLAG        argflags[0]&LEGAL_FLAG
#define CK_PAPERSIZE_FLAGS   argflags[0]&PAPERSIZE_FLAGS
#define CK_INPUTTRAY_FLAGS   argflags[0]&INPUTTRAY_FLAGS 


/* Make sure you fix this in the do_general_get if you move it to a
   different word. It is also found in there because it is used to
   trigger the fetching of an object from a private mib.*/
#define DISPLAY_FLAG         0x40000000ul //printmib 
#define COVER_FLAG           0x80000000ul //printmib
#define CK_DISPLAY_FLAG      argflags[0]&DISPLAY_FLAG
#define CK_COVER_FLAG        argflags[0]&COVER_FLAG
#define RST_DISPLAY_FLAG     argflags[0]&=~DISPLAY_FLAG

#define PRINTMIB0_FLAGS      0xFFFF8000ul
#define CK_PRINTMIB0_FLAGS   argflags[0]&PRINTMIB0_FLAGS

/* These apply to argflags 1 */
#define LANGUAGES_FLAG       0x00000008ul //printmib
#define PJL_FLAG             0x00000010ul //printmib
#define HPGL_FLAG            0x00000020ul //printmib
#define PSPRINTER_FLAG       0x00000040ul //printmib
#define AUTOLANG_FLAG        0x00000080ul //printmib
#define POSTSCRIPT_FLAG      0x00000100ul //printmib
#define PCL_FLAG             0x00000200ul //printmib
#define LANGUAGES_FLAGS      0x000003F8ul 
#define CK_LANGUAGES_FLAG    argflags[1]&LANGUAGES_FLAG
#define CK_PJL_FLAG          argflags[1]&PJL_FLAG
#define CK_HPGL_FLAG         argflags[1]&HPGL_FLAG
#define CK_PSPRINTER_FLAG    argflags[1]&PSPRINTER_FLAG
#define CK_AUTOLANG_FLAG     argflags[1]&AUTOLANG_FLAG
#define CK_POSTSCRIPT_FLAG   argflags[1]&POSTSCRIPT_FLAG
#define CK_PCL_FLAG          argflags[1]&PCL_FLAG
#define CK_LANGUAGES_FLAGS   argflags[1]&LANGUAGES_FLAGS
#define RST_POSTSCRIPT_FLAG  argflags[1]&=~POSTSCRIPT_FLAG
#define RST_PCL_FLAG         argflags[1]&=~PCL_FLAG
#define RST_PJL_FLAG         argflags[1]&=~PJL_FLAG
#define RST_HPGL_FLAG        argflags[1]&=~HPGL_FLAG


#define MARKER_FLAG          0x00000400ul //printmib
#define PAGECOUNT_FLAG       0x00000800ul //printmib
#define COLORS_FLAG          0x00001000ul //printmib
#define RESOLUTION_FLAG      0x00002000ul //printmib
#define MINMARGIN_FLAG       0x00004000ul //printmib
#define MARKER_FLAGS         0x00007C00ul 
#define CK_MARKER_FLAG       argflags[1]&MARKER_FLAG
#define CK_PAGECOUNT_FLAG    argflags[1]&PAGECOUNT_FLAG
#define CK_COLORS_FLAG       argflags[1]&COLORS_FLAG
#define CK_RESOLUTION_FLAG   argflags[1]&RESOLUTION_FLAG
#define CK_MINMARGIN_FLAG    argflags[1]&MINMARGIN_FLAG
#define CK_MARKER_FLAGS      argflags[1]&MARKER_FLAGS


#define PROTOCOL_FLAG        0x00008000ul //printmib
#define APPLETALK_FLAG       0x00010000ul //printmib
#define LPD_FLAG             0x00020000ul //printmib
#define NETWARE_FLAG         0x00040000ul //printmib
#define PORT9100_FLAG        0x00080000ul //printmib
#define PROTOCOL_FLAGS       0x000F8000ul 
#define CK_PROTOCOL_FLAG     argflags[1]&PROTOCOL_FLAG
#define CK_APPLETALK_FLAG    argflags[1]&APPLETALK_FLAG  
#define CK_LPD_FLAG          argflags[1]&LPD_FLAG
#define CK_NETWARE_FLAG      argflags[1]&NETWARE_FLAG
#define CK_PORT9100_FLAG     argflags[1]&PORT9100_FLAG 
#define CK_PROTOCOL_FLAGS    argflags[1]&PROTOCOL_FLAGS

#define SUPPLIES_FLAG        0x00100000ul //printmib
#define ALERTS_FLAG          0x00200000ul //printmib 
#define CK_SUPPLIES_FLAG     argflags[1]&SUPPLIES_FLAG
#define CK_ALERTS_FLAG       argflags[1]&ALERTS_FLAG

#define REBOOT_FLAG          0x00400000ul //printmib
#define CK_REBOOT_FLAG       argflags[1]&REBOOT_FLAG
#define RST_REBOOT_FLAG      argflags[1]&=~REBOOT_FLAG

#define PRINTMIBR1_FLAGS     0x003FFFF8ul
#define PRINTMIBS1_FLAGS     0x00400000ul
#define PRINTMIB1_FLAGS      0x007FFFF8ul
#define CK_PRINTMIBR1_FLAGS  argflags[1]&PRINTMIBR1_FLAGS
#define CK_PRINTMIBS1_FLAGS  argflags[1]&PRINTMIBS1_FLAGS
#define CK_PRINTMIB1_FLAGS   argflags[1]&PRINTMIB1_FLAGS
#define CK_PRINTMIB_FLAGS    CK_PRINTMIB0_FLAGS || CK_PRINTMIB1_FLAGS
#define CK_PRINTMIB_RFLAGS   CK_PRINTMIB0_FLAGS || CK_PRINTMIBR1_FLAGS
#define CK_PRINTMIB_SFLAGS   CK_PRINTMIBS1_FLAGS

/* These apply to argflags 2 and require an argument */
#define MAXPROC_FLAG         0x00000008ul
#define CK_MAXPROC_FLAG      argflags[2]&MAXPROC_FLAG

#define SETCONTACT_FLAG      0x00000010ul
#define SETLOCATION_FLAG     0x00000020ul
#define SGENERALMIB_FLAGS    0x00000030ul
#define CK_SETCONTACT_FLAG   argflags[2]&SETCONTACT_FLAG
#define CK_SETLOCATION_FLAG  argflags[2]&SETLOCATION_FLAG
#define CK_SGENERALMIB_FLAGS argflags[2]&SGENERALMIB_FLAGS

#define UPDATEFIRM_FLAG      0x00000040ul // this one is HP specific
#define CK_UPDATEFIRM_FLAG   argflags[2]&UPDATEFIRM_FLAG

/* These are the indexes into the optparams vector. They need to be the log 
   base 2 of the cooresponding flag into argflags 2. 1=0, 2=1, 4=2, 8=3, 
   0x10=4 ...*/
#define MAXPROC_PARAM     0
#define SETCONTACT_PARAM  1
#define SETLOCATION_PARAM 2
#define UPDATEFIRM_PARAM  3

/* This is how big to make the optparams vector it should be one bigger than
   the highest value in the indexes to the opt params. This is just put here
   so that it you don't have to track the vector place in the code where this
   is set down */
#define MAXOPTWPARAMS 4

#define CFGSRC_FLAG          0x00800000ul //private mib
#define PRIVATEMIB_FLAGS     0x00800000ul
#define CK_CFGSRC_FLAG       argflags[1]&CFGSRC_FLAG
#define CK_PRIVATEMIB_FLAGS  argflags[1]&PRIVATEMIB_FLAGS
//Amount to shift right to get offset into privmib_tbl vector
#define PRIVATEMIB_OFFSET 23

#endif 
