## Copyright (C) 2000  Kai Habel
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

## -*- texinfo -*-
## @deftypefn {Function File} {} [@var{Theta},@var{R}] = cart2pol (@var{X},@var{Y})
## @deftypefnx {Function File} {} [@var{Theta},@var{R},@var{Z}] = cart2pol (@var{X},@var{Y},@var{Z})
## transforms cartesian to polar or cylindrical coordinates.
## @var{X},@var{Y} (and @var{Z}) must be of same shape.
## @var{Theta} describes the angle relative to the x - axis.
## @var{R} is the distance to the z - axis (0,0,z).
## @end deftypefn
## @seealso{pol2cart,cart2sph,sph2cart}

## Author:	Kai Habel <kai.habel@gmx.de>

function [...] = cart2pol (X, Y, Z)

  if (nargin == 2)

    ##
    ## cartesian to polar
    ##

    msg = sprintf ("[Theta,R]=cart2pol (X,Y) X,Y must be matrices of same size");
    if ( !(is_matrix (X) && is_matrix (Y)) ) || ( size (X) != size (Y) )
      usage (msg);
    endif

    Theta = atan2 (Y, X);
    R = sqrt (X .^ 2 + Y .^ 2);

    vr_val (Theta);
    vr_val (R);
  elseif (nargin == 3)

    ##
    ## cartesian to cylindrical
    ##

    msg = sprintf ("[Theta,R,Z]=cart2pol (X,Y,Z) X,Y,Z must be matrices of same size");
    if !(is_matrix (X) && is_matrix (Y) && is_matrix (Z))
      usage (msg);
    endif

    if ( (size (X) != size (Y)) || (size (X) != size (Z)) )
      usage (msg);
    endif

    Theta = atan2 (Y, X);
    R = sqrt (X .^ 2 + Y .^ 2);

    vr_val (Theta);
    vr_val (R);
    vr_val (Z);
  else
    usage ("cart2pol (...) number of arguments must be 2 or 3");
  endif

endfunction
