## Copyright (C) 2000  Kai Habel
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

## -*- texinfo -*-
## @deftypefn {Function File} {} [@var{Theta},@var{Phi},@var{R}] = cart2sph (@var{X,Y,Z})
## transforms cartesian to spherical coordinates.
## @var{X},@var{Y} and @var{Z} must be of same shape.
## @var{Theta} describes the angle relative to the x - axis.
## @var{Phi} is the angle relative to the xy - plane.
## @var{R} is the distance to the origin (0,0,0).
## @end deftypefn
## @seealso{pol2cart,cart2pol,sph2cart}

## Author:	Kai Habel <kai.habel@gmx.de>

function [Theta, Phi, R] = cart2sph (X, Y, Z)

  if (nargin != 3)
    usage ("[Theta, Phi, R] = cart2sph (X, Y, Z)")
  endif

  msg = sprintf("[Theta, Phi, R] = cart2sph (X, Y, Z)\
        X,Y,Z must be matrices of same size");

  if !( is_matrix (X) && is_matrix (Y) && is_matrix (Z) )
    usage (msg);
  endif

  if ((size (X) != size (Y)) || (size (X) != size (Z)))
    usage (msg);
  endif

  Theta = atan2 (Y, X);
  Phi = atan2 (Z, sqrt (X .^ 2 + Y .^ 2));
  R = sqrt (X .^ 2 + Y .^ 2 + Z .^ 2);

endfunction
