<?php
//
// Administrator Config file
//

// defines the menu link in the main system tools page.
$menu_link_name = 'Types';
$type_description = 'System Status Type';

$_COLUMN_DESC = array(
			's_status_type'=>'Status Type',
			'description'=>'Description',
			'img'=>'Image',
			'insert_ind'=>'Insert Indicator',
			'update_ind'=>'Update Indicator',
			'delete_ind'=>'Delete Indicator',
			'min_display_user_type'=>'Minimum Display User',
			'min_create_user_type'=>'Minimum Create User',
			'new_owner_instance_ind'=>'Owner Instance Indicator',
			'new_not_owner_instance_ind'=>'Non-Owner Instance Indicator',
			'borrow_ind'=>'Borrow Indicator',
			'status_comment_ind'=>'Status Comment Indicator',
			'default_ind'=>'Default Indicator',
			'closed_ind'=>'Closed Indicator');
			
$_COLUMN_HELP = array(
	'insert_ind'=>array(
		'If \'Y\', items can be directly inserted, otherwise items can '.
		'only be updated to this type (As long as update_ind = \'Y\')'),

	'update_ind'=>array(
		'If \'Y\', existing items can be updated to this type. If \'N\', then items can only '.
		'be directly inserted. (As long as insert_ind = \'Y\')'),
	
	'delete_ind'=>array(
		'Items of this type can be deleted.'),
	
	'min_display_user_type'=>array(
		'Specifies the minimum user type, who can see list/display items of this '.
			'status.  For instance, if this column is set to \'A\', then only Admininstrator\'s '.
			'can list/display items of this status.  Items of this type owned by the user will be '.
			'visible to the user, and the user can still create items of this type, (Pursuant to any '.
			'restrictions enforced by min_create_user_type)',
		
		'User Types in OpenDb are hierarchical:',
		array(
			'G - Guest (Lowest)',
			'B - Borrower',
			'N - Normal',
			'A - Admin (Highest)'),
			
		'If a reservation is attempted for an item with a status_type, that has a '.
			'min_display_user_type set, which does not fit in with that of the current '.
			'user, the reservation will be aborted.',
		
		'If user is not a valid min_display_user_type or min_create_user_type user type the status will not '.
			'be displayed in Stats, Whatsnew or Search page.  This has an interesting side effect, if this '.
			'indicator is modified, after users add items of this type.  These items will no longer be '.
			'visible via Stats, but the items themselves can be found indirectly (not via status type list of values) '.
			'in listings.php.  For performance reasons no extra validation will be done, to check for the existence '.
			'of user items, if both min_display_user_type and min_create_user_type are modified to a user type above '.
			'users with items in this type.'),
	
	'min_create_user_type'=>array(
		'Specifies the minimum user type, who can insert items of this type, or '.
			'update existing items to this type.',
		
		'User Types in OpenDb are hierarchical:',
		array(
			'G - Guest (Lowest)',
			'B - Borrower',
			'N - Normal',
			'A - Admin (Highest)')),

	'new_owner_instance_ind'=>array(
		'If \'Y\', then multiple instances of the title/s_item_type combination are allowed.',
		'If this column is \'N\', then a check will be made for whether the owner has any instances '.
			'of this item, if so, the New Copy operation will unavailable.'),

	'new_not_owner_instance_ind'=>array(
		'If \'Y\' then the New Copy functionality will be available to other owners. '.
			'A owner who does not currently have an instance of this item, will be allowed to create '.
			'one. However if the owner already has a copy, then the new_owner_instance_ind column '.
			'will control whether the New Copy functionality is available.'),
	
	'borrow_ind'=>array(
		'If \'Y\', items can be reserved/checked out/checked in.',
 		'If \'N\', items can not be reserved, but can be [quick] checked out.',
		'If \'B\', items can not be [quick] checked out.  If item checked out, it cannot be updated to '.
			'a s_status_type with borrow_ind = \'B\'',
		
		'If \'X\', items can not be reserved/[quick] checked out/checked in.  Items cannot have any borrowed '.
			'records (active or otherwise).  An item with borrowed item records cannot be updated to a '.
			's_status_type with borrow_ind = \'X\'',
		),

	'default_ind'=>array(
		'Only one Status Type should be \'Y\'.  Will be checked by default, for new item operations, etc'),

	'status_comment_ind'=>array(
		'If \'Y\' or \'H\', status_comment\'s can be recorded in the item_instance table, and displayed '.
			'in the item_display.php Instance Info section.',
	
		'If \'H\', then the comment will be shown in item_display.php, only when the owner of the '.
			'item_instance, or an administrator is viewing the record.'),
		
	'closed_ind'=>array(
		'This column, allows s_status_type records to be used in existing records, but no new '.
			'records can be created with this type, and existing records can not have their status '.
			'changed to types with closed_ind = \'Y\'')
	);
?>