<?php
/* 	
	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/**
*/
function theme_graph_config()
{
	return array('text'=>'000000',
				'captions'=>'000000',
				'lt_color'=>'6D78AB',
				'dk_color'=>'8E9DE0',
				'lt_border'=>'8E9DE0',
				'dk_border'=>'000000',
				'bgcolor'=>'FFFFFF',
				'transparent'=>FALSE);
}

/**
*/
function theme_index()
{
	// default - redirect to login page!
	header("Location: login.php");	
}

/**
	Assumes that if $uid is set, session is valid!
*/
function theme_header($title, $include_menu)
{
	global $CONFIG_VARS;
	global $LANG_VARS;
	global $_OPENDB_THEME;
	
	echo("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">".
		"\n<html>".
		"\n<head>".
		"\n	<title>".$CONFIG_VARS['site.title']." ".$CONFIG_VARS['site.version'].(!empty($title)?" - $title":"")."</title>".
		"\n	<link rel=\"stylesheet\" type=\"text/css\" href=\"theme/$_OPENDB_THEME/style.css\">".
		// This works on Mozilla, but not on IE!
		"<link rel=\"icon\" href=\"images/icon.gif\" type=\"image/gif\" />".
		"\n</head>".
		"\n<body>".
		"<table width=100% cellpadding=5 border=0>".
		"<tr>");
	
	if($include_menu)
		theme_menu();
		
	echo("</tr><tr><td colspan=3 valign=top>".
		"\n<div align=\"right\">".
		"\n<h1>".$CONFIG_VARS['site.title']." ".$CONFIG_VARS['site.version']."</h1>".
		"\n</div>");
}

/**
	You can put something else in the footer if you want!!!
*/
function theme_footer()
{
	echo "</td></tr></table>".
		"\n</body>".
		"\n</html>";
}

/**
	If $uid set, we assume that session is valid!
*/
function theme_menu()
{
	include_once("./functions/user.php");

	global $CONFIG_VARS;
	global $CONFIG_VARS;
	global $LANG_VARS;
	global $HTTP_SESSION_VARS;
		
	echo("<td nowrap class=\"menubar\">".
		"\n<div class=\"fineprint\">".
		"\n<img src=\"images/icon.gif\" alt=\"".$CONFIG_VARS['site.title']."\" align=bottom border=0>".
		"\n<i>".$CONFIG_VARS['site.title']." ".$CONFIG_VARS['site.version']."</i>".
		"\n</div>".
		"\n<br>");
	
	// Do not display user id if public_access is enabled.
	if(!is_site_public_access_enabled() && !empty($HTTP_SESSION_VARS['user_id']))
	{
	 	echo("\n".replace_lang_var("user_id", $HTTP_SESSION_VARS['user_id'], $LANG_VARS['uid_is_logged_in'])."</td>");
	}
	
	echo("\n<td class=\"menutext\"><b>");
	
	$menu_options = get_menu_options($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']);
	if(is_array($menu_options['normal']))
	{
		echo get_table_menu_options($menu_options['normal'], 
									3, // columns
									"[<b>%option%</b>]", // option_mask 
									array('cellpadding'=>0,'cellspacing'=>0)); // table options
	}
	echo("</b>");

	if(is_array($menu_options['admin']))
	{
		echo "\n</td><td class=\"menutext\">".
			"\n".$LANG_VARS['admin'].":<br>".
			get_table_menu_options($menu_options['admin'], 
								2, 
								"[%option%]", 
								array('cellpadding'=>1,'cellspacing'=>0));
	}
	echo("\n</td>");
}

/**
	Displays an error page.
*/
function theme_error($error)
{
	echo("\n<div class=\"error\">$error</div>");
}
?>