# camera-lib.tcl --
#
#       Library of abstractions to control the Canon Vcc3 cameras through the
#       amxd.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

source ../../lib/tcl/sleep.tcl

# global variables
#
# FIXME - the g_cameraPos does nothing so far
global g_cameraPos

set g_cameraPos(speaker) 0
set g_cameraPos(audience) 0

# FIXME - what if I call startMove left and startMove up before calling
#    stopMove left, will the camera move diagonally?

proc camera_pulseMove { id dir {numTimes 1} } {
    global g_amxDevices g_amxChannels
    
    switch -exact -- $id {
	speaker {
	    set dev $g_amxDevices(speakerCamera)
	}
	audience {
	    set dev $g_amxDevices(audienceCamera)
	}
	default {
	    return -code error "id must be \[speaker, audience\]"
	}
    }
    
    switch -exact -- $dir {
	    up -
	    down -
	    left -
	    right -
	    in -
	    out {
		if {$numTimes < 0} {
		    return -code error "numTimes must be >0"
		}
		for {set x 0} {$x < $numTimes} {incr x 1} {
		    # the 10 means to send a pulse
		    # channels are the same for speaker and audience cameras
		    send-AMX-command 10 $dev $g_amxChannels(speakerCamera,$dir)
		}
	    }
	    default {
		return -code error "dir must be \[up, down, left, right, in, out\]"
	    }
	}
}

proc camera_startMove { id dir } {
    global g_amxDevices g_amxChannels

    switch -exact -- $id {
	speaker {
	    set dev $g_amxDevices(speakerCamera)
	}
	audience {
	    set dev $g_amxDevices(audienceCamera)
	}
	default {
	    return -code error "id must be \[speaker, audience\]"
	}
    }
    
    switch -exact -- $dir {
	up -
	down -
	left -
	right -
	in -
	out {
	    # the 1 means to send a push command
	    send-AMX-command 1 $dev $g_amxChannels(speakerCamera,$dir)
	}
	default {
	    return -code error "dir must be \[up, down, left, right, in, out\]"
	}
    }

}

proc camera_stopMove { id } {
    global g_amxDevices g_amxChannels
    
    switch -exact -- $id {
	speaker {
	    set dev $g_amxDevices(speakerCamera)
	}
	audience {
	    set dev $g_amxDevices(audienceCamera)
	}
	default {
	    return -code error "id must be \[speaker, audience\]"
	}
    }
    
    # the 2 means to send a release command
    send-AMX-command 2 $dev $g_amxChannels(speakerCamera,right)
    send-AMX-command 2 $dev $g_amxChannels(speakerCamera,left)
    send-AMX-command 2 $dev $g_amxChannels(speakerCamera,up)
    send-AMX-command 2 $dev $g_amxChannels(speakerCamera,down)
    send-AMX-command 2 $dev $g_amxChannels(speakerCamera,in)
    send-AMX-command 2 $dev $g_amxChannels(speakerCamera,out)
}

# center the camera
proc camera_center { id } {
    global g_amxDevices g_amxChannels

    switch -exact -- $id {
	speaker {
	    set dev $g_amxDevices(speakerCamera)
	}
	audience {
	    set dev $g_amxDevices(audienceCamera)
	}
	default {
	    return -code error "id must be \[speaker, audience\]"
	}
    }
    
    send-AMX-command 10 $dev $g_amxChannels(speakerCamera,center)
}

# set a preset at the current position and brightness
proc camera_setPreset { id num } {
    global g_amxDevices g_amxChannels
    
    switch -exact -- $id {
	speaker {
	    set dev $g_amxDevices(speakerCamera)
	}
	audience {
	    set dev $g_amxDevices(audienceCamera)
	}
	default {
	    return -code error "id must be \[speaker, audience\]"
	}
    }
    
    if {$num < 1 || $num > 6} {
	return -code error "Invalid argument: preset num must be between 1 and 6"
    }

    send-AMX-command 10 $dev $g_amxChannels(speakerCamera,preset)
    # this pause is needed to let the camera go into preset mode
    sleep 500
    set temp [expr $num + $g_amxChannels(speakerCamera,preset)]
    send-AMX-command 10 $dev $temp
}

proc camera_goPreset { id num } {
    global g_amxDevices g_amxChannels

    switch -exact -- $id {
	speaker {
	    set dev $g_amxDevices(speakerCamera)
	}
	audience {
	    set dev $g_amxDevices(audienceCamera)
	}
	default {
	    return -code error "id must be \[speaker, audience\]"
	}
    }
    if {$num < 1 || $num > 6} {
	return -code error "Invalid argument: must be: 1 <= preset num <= 6"
    }
    set temp [expr $num + $g_amxChannels(speakerCamera,preset)]
    send-AMX-command 10 $dev $temp
}

# this is for testing only, will not be part of API
proc test_func { id dir iters } {
    global g_cameraMap

    if {[catch {set dev $g_cameraMap($id)}]} {
	return -code error "id must be \[speaker, audience\]"
    }
    switch -exact -- $id {
	speaker {
	    set dev $g_amxDevices(speakerCamera)
	}
	audience {
	    set dev $g_amxDevices(audienceCamera)
	}
	default {
	    return -code error "id must be \[speaker, audience\]"
	}
    }
    
    #   puts stdout "iters is $iters"
    switch -exact -- $dir {
	left -
	right {
	    send-AMX-command 1 $dev $g_amxChannels($dir)
	    after $iters
	    send-AMX-command 2 $dev $g_amxChannels($dir)
	}
    }
}
