/*
 * mb-play.h --
 *
 *      MediaBoard Playback header
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/archive/mb-play.h,v 1.13 2002/02/03 03:09:26 lim Exp $
 */

#ifndef MASH_MB_PLAY_H
#define MASH_MB_PLAY_H


#include "archive/archive-stream.h"
#include "archive/mb-archive.h"
#include "mb/mb-obj.h"


class MBPlaybackRcvr;


class MBPlaybackStream : public PlaybackStream {
public:
	MBPlaybackStream()
		: PlaybackStream(), rcvr_(NULL), firstTime_(TRUE), endTS_(0) {}
	virtual ~MBPlaybackStream() { }

	void attach(MBPlaybackRcvr *rcvr) { rcvr_ = rcvr; }


	virtual void LTS_Speed();
	virtual void LTS_Reference();

	virtual void Clip(timeval start, timeval end);
	// obtain the timeout value for the next event
	// returns: FALSE when I'm done
	virtual int  NextEvent(timeval &logical);
	virtual void DoEvent(); // do the next event

private:
	int ReadRecord();


	MBPlaybackRcvr *rcvr_;
	Bool firstTime_;
	u_int32_t endTS_;

	struct StreamState {
		StreamState()
			: pPage(NULL), seqno(1), sseq(0), eseq(0),
			  pb(NULL), bufferLen(0) {
				// set seqno > eseq, so that when NextEvent()
				// is called for the first time, it goes out
				// and fetches the next record
		}

		MBPageObject *pPage;
		u_int32_t seqno, sseq, eseq;
		DataBuffer buffer;
		Byte *pb;
		int  bufferLen;
	};
	StreamState state;

};


class MBPlaybackRcvr : public MBBaseRcvr {
public:
	MBPlaybackRcvr(MBBaseMgr *pMgr, const SrcId &srcId)
		: MBBaseRcvr(pMgr, srcId), stream_(NULL), bytesSent_(0) { }
	~MBPlaybackRcvr() { }

	void attach(MBPlaybackStream *stream) {
		stream_ = stream;
	}

private:
	virtual int executeCmd(MBCmd * /*pCmd*/, MBPageObject * /*pPage*/,
			       const MBTime& /*oldTime*/,
			       const MBTime& /*newTime*/)
		{
			// don't do anything!
			return MB_EXE_OK;
		}
	virtual int handleCmd(MBCmd *pCmd, MBPageObject *pPage,
			      const MBTime& oldTime, const MBTime& newTime);
	Bool Dispatch(MBCmd *pCmd, MBPageObject *pPage);

	MBPlaybackStream *stream_;
	u_int32_t bytesSent_;
	friend class MBPlaybackStream;
};



class MBPlaybackMgr : public MBBaseMgr {
public:
	MBPlaybackMgr()
		: MBBaseMgr(), sources_(NULL), nextADUIdx_(NULL),
		  fillSAIdx_(NULL) { }
	~MBPlaybackMgr() {
		// FIXME: need to delete all sources!
	}
	// virtual SRM_AppMgr functions
	virtual int next_ADU(u_char *db, int len, srm_src &id,
			     int &pkt_type, int &next);
	int create_srm_source(int argc, const char * const *artgv);

private:
	virtual void handle_reply(Byte * /*pb*/, int /*len*/) { }
	virtual int periodic_update(Byte *pb);

	virtual Bool isVisible(const PageId &/*pgId*/) {
		// all pages are considered "visible", so SRM can make a
		// repair-request if it needs one
		return TRUE;
	}

	virtual void activity(MBPageObject* /*pPage*/,
			      MBCmd* /*pCmd*/) {}

	virtual MBBaseRcvr *NewReceiver(const SrcId &srcId, Bool isLocal) {
		if (isLocal==FALSE) {
			// we wish to ignore all remote receivers!
			return NULL;
		}
		else {
			return new MBPlaybackRcvr(this, srcId);
		}

	}

	virtual MBPageObject *NewPageObject(const PageId &pageId,
					    Bool /*newPage*/) {
		return new MBPageObject(this, pageId);
	}

	List<SRM_Source> *sources_;
	ListIndex nextADUIdx_, fillSAIdx_;
};



#endif /* MASH_MB_PLAY_H */
