/*
 * atobj-sm.h --
 *
 *      this is a simple animator session manager
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *  $Header: /usr/mash/src/repository/mash/mash-1/atobj/atobj-sm.h,v 1.7 2002/02/03 03:10:21 lim Exp $
 */

#ifndef ATOBJ_MGR_H
#define ATOBJ_MGR_H

#include <srm/session-srm.h>
#include "atobj-rreq.h"
#include "atobj-rcvr.h"

/* this is a simple animator session manager */
class AtobjSM : public SRM_AppMgr {
public:
    AtobjSM();

    virtual ~AtobjSM();

    virtual int command(int argc, const char*const* argv);

    /* returns time of day, in hundreths of seconds. */
    n_long currTime() const {
        struct timeval tv;
        gettimeofday(&tv, 0);
        return (100 * tv.tv_sec + (tv.tv_usec / 10000));
    }
    AtobjRcvr* get_rcvr(const SrcId& srcId);
    AtobjRcvr* define_rcvr(const SrcId& srcId);

    /* caller tells manager that it has len bytes ready to be sent*/
    RetCode begin_xmit(int len) {
        if (len) return pSession_->begin_xmit(len);
        return FALSE;
    }

    /* virtual SRM_AppMgr functions*/
    virtual int next_ADU(Byte *pb, int len, srm_src& /*addr*/,
                         int &type, int& next) {
        next=0;
        type = APP_DATA;
        /* TODO: should poll all receivers or preq as well*/
        int outlen=(pLocalRcvr_->next_ADU(pb, len));
        Trace(VERYVERBOSE,("S %d b",outlen));
        return outlen;
    }

    virtual SRM_PacketHandler *new_source(const srm_src &sid, int islocal);
    virtual void handle_request(const SrcId& sidRqtSrc, Byte *pb, int len);
    virtual void handle_reply(const SrcId& sidRpySrc, Byte *pb, int len);

    void schedRequest(Atobj_request* pRequest, const SrcId& sid ) {
        pSession_->sched_request(pRequest, sid);
    }
    void schedReply(Atobj_reply* pReply, const SrcId& sid) {
        pSession_->sched_reply(pReply, sid);
    }

    /* REVIEW: srm should change to u_int */
    virtual void handle_SA(const SrcId& sid, Byte *pb, int len);

    virtual int periodic_update(Byte *pb);

    void setSession(SRM_Session *pSession) { pSession_ = pSession; }

    /* returns the size of the maximum packet len*/
    u_short getMTU() {
        /* REVIEW: this should be from SRM*/
        return SRM_MTU;
    }
    u_short getMaxCmdSz() {
        /* note: need to subtract from Pkt_Reply because we have to be */
        /* able to send it out the command as a reply...*/
        return SRM_MTU-sizeof(Pkt_PageHdr)-sizeof(Pkt_reply);
    }

#ifdef MB_DEBUG
    void Dump(int dumptype);
#endif

 private:
    AtobjRcvr* pLocalRcvr_;
    SRM_Session* pSession_;
    Tcl_HashTable *phtRcvrs_;
};

#endif /* #ifdef ATOBJ_MGR_H */
