/*
 * audio-oss.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 2000-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef MASH_AUDIO_OSS_H
#define MASH_AUDIO_OSS_H

#include "audio.h"

class OSSAudio : public Audio {
public:
	OSSAudio();
	virtual int FrameReady();
	virtual u_char* Read();
	virtual void Write(u_char *);
	virtual void SetRGain(int);
	virtual void SetPGain(int);
	virtual void OutputPort(int);
	virtual void InputPort(int);
	virtual void Obtain();
	virtual void Release();
	virtual int getSampleRate() {return sample_rate;};
	virtual int use16bits() {return use16RawPCM;};
	virtual int inStereo() {return stereo;};
	virtual int command(int, const char *const *);
protected:
	u_char* readbuf; // captured pcmu data that's sent to mash
	u_char* readCopyInPtr; // next position to read in data from soundcard
	u_char* readCopyOutPtr; // next position to pass data back to mash 
	u_short *s16_buf; // playback data that's sent to audio board
	int mixerfd;
	int play_fmt, rec_fmt ; /* the sb16 has split format... */
	int vol_device;
	int played;
	int playedDuringLast;
	int use16RawPCM; // flag to set if you want to use 16 bit raw PCM samples instead of 8 bit mulaw
	int sample_rate; // the sample rate at which to capture or output on the soundcard
	int stereo;	// flag to set if you want to use stereo 16 bit linear PCM... interleaves samples
};

#endif
