/*
 * audio.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1991-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

static const char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/audio/audio.cc,v 1.18 2002/02/03 03:10:46 lim Exp $";

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#if defined(sgi)
#include <bstring.h>
#endif
#ifdef WIN32
#include <fcntl.h>
#else
#include <unistd.h>
#include <sys/file.h>
#include <fcntl.h>
#endif

#include "audio.h"
#include "mulaw.h"
#include "tclcl.h"


Audio::Audio() :
	lock_fd_(-1),
	blksize_(AUDIO_FRAMESIZE),
	fd_(-1),
	oport_(0),
	iport_(0),
	rmute_(0),
	pmute_(0),
	rgain_(0),
	pgain_(0),
	duplex_(1),
	input_names_(0),
	output_names_(0),
	handler_(0),
        device_(-1)
{
  omode_ = mode_mikemutesnet;
  bind("duplex_", &duplex_);
}

Audio::~Audio()
{
	close(fd_);
}

void Audio::Release()
{
	if (haveaudio()) {
		unlink();
		(void)close(fd_);
		fd_ = -1;
		notify();
	}
}

void Audio::Obtain()
{
	link(fd_, TCL_READABLE);
	notify();
}

void Audio::InputPort(int p)
{
	iport_ = p;
}

void Audio::OutputPort(int p)
{
	oport_ = p;
}

void Audio::dispatch(int)
{
	while (FrameReady()) {
	  if (handler_ != 0)
	    handler_->audio_handle();
	}
}

/*
 * Output the ulaw sample in x and read the mike response back into y.
 * The two signals are guaranteed to coincide in time.  len must be
 * less than the max output buffer available (currently 4K).
 */
int Audio::PlayRec(u_char *x, u_char *y, int len)
{
	int bufsize = (len / blksize_) * blksize_;
	int rbufsize = bufsize + 4096;
	u_char* tmpbuf = new u_char[rbufsize];
	Flush();
	int cc = write(fd_, (char*)x, bufsize);
	if (cc != bufsize) {
		perror("PlayRec write");
		delete[] tmpbuf;
		return (bufsize);
	}
	int offset = AdjustTime(0);
	if (offset < 0 || offset + bufsize > rbufsize) {
		fprintf(stderr, "Playrec offset %d\n", offset);
		delete[] tmpbuf;
		return (bufsize);
	}
	char* bp = (char*)tmpbuf;
	for (int rem = offset + bufsize; rem > 0; ) {
		if ((cc = read(fd_, bp, rem)) <= 0) {
			perror("PlayRec read");
			delete[] tmpbuf;
			return (bufsize);
		}
		bp += cc;
		rem -= cc;
	}
	memcpy((char*)y, (char*)&tmpbuf[offset], bufsize);
	delete[] tmpbuf;
	return (bufsize);
}

void Audio::RMute()
{
	rmute_ |= 1;
}

void Audio::RUnmute()
{
	rmute_ &=~ 1;
}

void Audio::SetRGain(int)
{
}

void Audio::SetPGain(int)
{
}

#if defined(__osf__) || defined(sun) || defined(ultrix) || defined(sgi)
extern "C" {
int flock(int, int);
}
#endif
#if defined(hpux) || defined(__svr4__) || defined(sco) || defined(_AIX)
#include <fcntl.h>

#define LOCK_SH   1    /* shared lock */
#define LOCK_EX   2    /* exclusive lock */
#define LOCK_NB   4    /* don't block when locking */
#define LOCK_UN   8    /* unlock */

int flock(int fd, int op) {
	struct flock f;
	f.l_whence = 0;
	f.l_start = 0;
	f.l_len = 0;
	if (op == LOCK_UN)
		f.l_type = F_UNLCK;
	else
		f.l_type = F_WRLCK;
	return (fcntl(fd, F_SETLK, &f));
}
#endif

/* FIXME should make a NOLOCKING define that configure sets */
#ifdef WIN32
void Audio::openlock()	{ printf("Audio:openlock\n"); }
void Audio::unlock()	{ printf("Audio:unlock\n"); }
int Audio::lock()	{ printf("Audio:lock\n"); return (0); }
#else
void Audio::openlock()
{
	char *wrk = new char[sizeof("/tmp/.vat_audio_lock.") + 32];
	sprintf(wrk, "/tmp/.vat_audio_lock.%d", (int)getuid());
	/* open (or create) the lock file */
	lock_fd_ = open(wrk, O_RDWR|O_CREAT, 0777);
	if (lock_fd_ < 0) {
		perror(wrk);
		exit(2);
	}
	delete wrk;
}

void Audio::unlock()
{
	if (::flock(lock_fd_, LOCK_UN))
		perror("vat: sock_audio unlock");
}

int Audio::lock()
{
	return (::flock(lock_fd_, (LOCK_EX|LOCK_NB)));
}
#endif

int Audio::SetAudioDevice(int dev)
{
  device_ = dev;

  return(1);
}

/*
 * <otcl> Class Audio
 * Audio is the
 * base class for objects that represent audio codecs.
 * An audio object is both a source and a sink of data and
 * rather than spliced onto other objects in a pipeline,
 * it is instanced inside of and manipulated principally by
 * the AudioController object.
 */
int Audio::command(int argc, const char*const* argv)
{
	Tcl& tcl = Tcl::instance();
	if (argc == 2) {
		/*
		 * <otcl> Audio public get_input_ports {}
		 * Return the list of available input ports.
		 * The list consists of a sequence of names,
		 * where the name is the nick name of the port
		 * (e.g., "mike").  A ports position in this
		 * list identifies its integer port number,
		 * which must be used in many of the method
		 * calls that select and/or manipulate the port.
		 */
		if (strcmp(argv[1], "get_input_ports") == 0) {
			tcl.result(input_names_);
			return (TCL_OK);
		}
		/*
		 * <otcl> Audio public get_output_ports {}
		 * Return the list of available output ports.
		 * The list consists of a sequence of names,
		 * where the name is the nick name of the port
		 * (e.g., "speaker").  A ports position in this
		 * list identifies its integer port number,
		 * which must be used in many of the method
		 * calls that select and/or manipulate the port.
		 */
		if (strcmp(argv[1], "get_output_ports") == 0) {
			tcl.result(output_names_);
			return (TCL_OK);
		}
		/*
		 * <otcl> Audio public obtain {}
		 * Attempt to obtain the audio device.  If successful,
		 * notify observers.
		 */
		if (strcmp(argv[1], "obtain") == 0) {
			if (haveaudio()) {
				tcl.result("calling obtain when audio already held");
				return (TCL_ERROR);
			}
			Obtain();
			return (TCL_OK);
		}
		/*
		 * <otcl> Audio public release {}
		 * Release the audio device and notify observers.
		 * This allows some other Audio object running
		 * in either the same or separate process,
		 * to obtain the underlying audio device
		 * (since many audio services are not shared).
		 */
		if (strcmp(argv[1], "release") == 0) {
			Release();
			return (TCL_OK);
		}
		/*
		 * <otcl> Audio public have {}
		 * Return 1 if the underlying audio device is currently open
		 * and ready, and 0 otherwise.
		 */
		if (strcmp(argv[1], "have") == 0) {
			tcl.result(haveaudio() ? "1" : "0");
			return (TCL_OK);
		/*
		 * <otcl> Audio public get_input_port
		 * Return the input port number of the currently
		 * selected port.  This number
		 * identifies the index of the port listed in the
		 * set of names returned by Audio::get_input_ports.
		 * </ul>
		 */
		}
		if (strcmp(argv[1], "get_input_port") == 0) {
			sprintf(tcl.result(), "%d", InputPort());
			return (TCL_OK);
		}
		/*
		 * <otcl> Audio public get_output_port
		 * Return the output port number of the currently
		 * selected port.  This number
		 * identifies the index of the port listed in the
		 * set of names returned by Audio::get_output_ports.
		 * </ul>
		 */
		if (strcmp(argv[1], "get_output_port") == 0) {
			sprintf(tcl.result(), "%d", OutputPort());
			return (TCL_OK);
		}
	} else if (argc == 3) {
		/*
		 * <otcl> Audio public set_speakerphone mode
		 * Sets the speakerphone attribute as indicated
		 * by <i>mode</i>, which can be one of:
		 * <ul>
		 * <li> fullduplex,
		 * <li> mikemutesnet, or
		 * <li> netmutesmike.
		 * </ul>
		 * FIXME: this should be an AudioController method
		 */
		if (strcmp(argv[1], "set_speakerphone") == 0) {
			if (strcasecmp(argv[2], "mikemutesnet") == 0)
				omode_ = mode_mikemutesnet;
			else if (strcasecmp(argv[2], "netmutesmike") == 0)
				omode_ = mode_netmutesmike;
			else
				omode_ = mode_none;

			return (TCL_OK);
		}

		/*
		 * <otcl> Audio public set_input_gain level
		 * Set the input gain for the currently enabled input
		 * port to <i>level</i>, where level is a linear gain
		 * factor from 0 to 255. FIXME should change this?
		 * If the input port is changed or the device is
		 * released and re-obtained, the gain must
		 * be reset from OTcl to maintain a consistent
		 * and reliable level.
		 * </ul>
		 */
		if (strcmp(argv[1], "set_input_gain") == 0) {
			SetRGain(atoi(argv[2]));
			return (TCL_OK);
		}
		/*
		 * <otcl> Audio public set_input_port portno
		 * Set the input port to <i>portno</i>, which
		 * identifies the index of the port listed in the
		 * set of names returned by Audio::get_input_ports.
		 * </ul>
		 */
		if (strcmp(argv[1], "set_input_port") == 0) {
			InputPort(atoi(argv[2]));
			return (TCL_OK);
		}
		/*
		 * <otcl> Audio public set_input_mute val
		 * Set the mute attribute of the current port to <i>val</i>.
		 * If non-zero, the mike is muted and no input samples
		 * are generated and passed on to the controller;
		 * otherwise, the mike is enabled and becomes "live".
		 * </ul>
		 */
		if (strcmp(argv[1], "set_input_mute") == 0) {
			/*FIXME*/
			if (atoi(argv[2]))
				RMute();
			else
				RUnmute();
			return (TCL_OK);
		}
		/*
		 * <otcl> Audio public set_ouptput_gain level
		 * Set the output gain for the currently enabled output
		 * port to <i>level</i>, where level is a linear gain
		 * factor from 0 to 255. FIXME should change this?
		 * If the output port is changed or the device is
		 * released and re-obtained, the gain must
		 * be reset from OTcl to maintain a consistent
		 * and reliable level.
		 * </ul>
		 */
		if (strcmp(argv[1], "set_output_gain") == 0) {
			SetPGain(atoi(argv[2]));
			return (TCL_OK);
		}
		/*
		 * <otcl> Audio public set_output_port portno
		 * Set the input port to <i>portno</i>, which
		 * identifies the index of the port listed in the
		 * set of names returned by Audio::get_output_ports.
		 * </ul>
		 */
		if (strcmp(argv[1], "set_output_port") == 0) {
			OutputPort(atoi(argv[2]));
			return (TCL_OK);
		}
		/*
		 * <otcl> Audio public set_output_mute val
		 * Set the mute attribute of the current port to <i>val</i>.
		 * If non-zero, the mike is muted and no output samples
		 * are generated and passed on to the controller;
		 * otherwise, the mike is enabled and becomes "live".
		 * </ul>
		 */
		if (strcmp(argv[1], "set_output_mute") == 0) {
			/*FIXME*/
			if (atoi(argv[2]))
				PMute();
			else
				PUnmute();
			return (TCL_OK);
		}

		/*
		 * Call this to set which audio device will be used by the
		 *    audio driver.  0 => /dev/audio0, /dev/mixer0, etc
		 */
		if(strcmp(argv[1], "set_device") == 0)
		{
		  SetAudioDevice(atoi(argv[2]));
		  return(TCL_OK);
		}
	}
	return (TclObject::command(argc, argv));
}
