/*
 * transcoder-pcm.cc --
 *
 *      PCM Transcoder
 *
 * Copyright (c) 1995-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef lint
static const char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/codec/audio/transcoder-pcm.cc,v 1.9 2002/02/03 03:11:42 lim Exp $ (UCB)";
#endif

#include "tclcl.h"
#include "transcoder-pcm.h"
#include "transmitter.h"

static class PCMTranscoderClass : public TclClass {
    public:
	PCMTranscoderClass() : TclClass("Transcoder/PCM") {}
	TclObject* create(int, const char*const*) {
		return (new PCMTranscoder);
	}
} pcm_transcoder_class;

void PCMTranscoder::recv_data(pktbuf *pb)
{
	rtphdr* rh = (rtphdr*)pb->dp;
	int cc = pb->len - sizeof(rtphdr);
	const u_char* bp = (const u_char*)(rh + 1);

	double now;
	if (!txonly_) {
		if (bps_ == 0) {
			pb->release();
			return;
		}
		now = gettimeofday();
	}

	if (fc_ <= now || txonly_) {
		/* If we have fallen behind (>200ms), re-sync. */
		if (now - fc_ > 200000.)
			fc_ = now;

		AudioFrame af(ntohl(rh->rh_ts), bp, cc);
		int nb = encoder_->nb();
		encoder_->recv(&af);
		obytes_ = encoder_->nb();
		nb = obytes_ - nb;
		double bits = 8 * nb;
		lastfc_ = fc_;
		fc_ += 1e6 * bits / bps_;
		ofrms_++;
	}
	pb->release();
}
