/*
 * mix.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * This routine mixes the DC & AC components of an 8x8 block of
 * pixels.  This routine is called for every block decoded so it
 * needs to be efficient.  It tries to do as many pixels in parallel
 * as will fit in a word.  The one complication is that it has to
 * deal with overflow (sum > 255) and underflow (sum < 0).  Underflow
 * & overflow are only possible if both terms have the same sign and
 * are indicated by the result having a different sign than the terms.
 * Note that underflow is more worrisome than overflow since it results
 * in bright white dots in a black field.
 * The DC term and sum are biased by 128 so a negative number has the
 * 2^7 bit = 0.  The AC term is not biased so a negative number has
 * the 2^7 bit = 1.  So underflow is indicated by (DC & AC & sum) != 0;
 */
#define JPEG_MIX_LOGIC \
	sum = dc + ac; \
	uflo = (dc ^ ac) & (dc ^ sum) & omask; \
	if (uflo) { \
		if ((ac = uflo & dc) != 0) { \
			/* integer overflows */ \
			ac |= ac >> 1; \
			ac |= ac >> 2; \
			ac |= ac >> 4; \
			sum |= ac; \
		} \
		if ((uflo &=~ ac) != 0) { \
			/* integer underflow(s) */ \
			uflo |= uflo >> 1; \
			uflo |= uflo >> 2; \
			uflo |= uflo >> 4; \
			sum &= ~uflo; \
		} \
	}

#ifdef INT_64
#define JPEG_MIX8(bp, out) \
	ac = *(INT_64*)(bp); \
	JPEG_MIX_LOGIC \
	*(INT_64*)(out) = sum; \
	(bp) += 8; \
	(out) += stride;
#else
#define JPEG_MIX4(bp, out) \
	ac = *(u_word*)(bp); \
	JPEG_MIX_LOGIC \
	*(u_word*)(out) = sum;

#define JPEG_MIX8(bp, out) \
	JPEG_MIX4(bp, out) \
	JPEG_MIX4(bp + 4, out + 4) \
	bp += 8; \
	out += stride;
#endif


void JpegDecoder::mix(u_int idc, const u_char* bp, u_char* out, int stride) const
{
	register int t;

	idc = UCLIMIT(idc) & 0xff;
	idc |= idc << 8;
	idc |= idc << 16;
#ifdef INT_64
	INT_64 dc = idc, ac, sum;
	dc |= dc << 32;
	INT_64 uflo, omask = 0x8080808080808080;
#else
	u_word dc = idc, ac, sum;
	u_word uflo, omask = 0x80808080;
#endif

	JPEG_MIX8(bp, out)
	JPEG_MIX8(bp, out)
	JPEG_MIX8(bp, out)
	JPEG_MIX8(bp, out)
	JPEG_MIX8(bp, out)
	JPEG_MIX8(bp, out)
	JPEG_MIX8(bp, out)
	JPEG_MIX8(bp, out)
}

