/*
 * wjfif.c --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <fcntl.h>

#ifdef notdef
#include "JVplayfile.h"
#endif
#include "jfif.h"

/* This factor relates the jvideo quantization factor to the one */
/* used for the jfif file. 100 seems about right                 */
#define QUANTIZE_FACTOR 100

/* These defines are values we use by convention */
/* Components */
#define IdY  1
#define IdCb 2
#define IdCr 3
/* Table frequency bits */
#define tabDC 0
#define tabAC 1
/* Table colour types */
#define tabLUM 0
#define tabCRM 1

#define emitByte(ci, b) ((*((ci)->emit_byte))((ci->userInfo), (b)))

void wrbyte(wfd, b)
     int wfd;
     int b;
{
  char c = b;
  write(wfd, &c, 1);
}

void emit_marker (cInfo *cinfo, JPEG_MARKER mark)
/* Emit a marker code */
{
  emitByte(cinfo, 0xFF);
  emitByte(cinfo, mark);
}

void emit_2bytes (cInfo *cinfo, int value)
/* Emit a 2-byte integer; these are always MSB first in JPEG files */
{
  emitByte(cinfo, (value >> 8) & 0xFF);
  emitByte(cinfo, value & 0xFF);
}

/* Output the huffman tables - using baseline DCT, so restrict to 8 bits */

void emit_dqts(cinfo, qFactor)
     cInfo *cinfo;
     int   qFactor;
{
  int i;
  int nomsg = 1;

  emit_marker(cinfo, M_DQT);
  emit_2bytes(cinfo, DCTSIZE2 + 1 + 2);           /* Size of table   */
  emitByte(cinfo, tabLUM);                       /* luminance table */
  for(i = 0; i < DCTSIZE2; i++)
  {
    int val = (std_luminance_quant_tbl[i] * qFactor)/QUANTIZE_FACTOR;
    if (val < 2) val = 2;
    if (val > 255)
    {
      if (nomsg)
      {
	fprintf(stderr, "JFIF generation: qFactor %d\n", qFactor);
	fprintf(stderr,
		"Luminance quantisation values > 8-bit truncated to 255\n");
	nomsg = 0;
      }
      val = 255;
    }
    emitByte(cinfo, val);
  }

  emit_marker(cinfo, M_DQT);
  emit_2bytes(cinfo, DCTSIZE2 + 1 + 2);           /* Size of table */
  emitByte(cinfo, tabCRM);                       /* chrominance   */
  for(i = 0; i < DCTSIZE2; i++)
  {
    int val = (std_chrominance_quant_tbl[i] * qFactor)/QUANTIZE_FACTOR;
    if (val < 2) val = 2;
    if (val > 255)
    {
      if (nomsg)
      {
	fprintf(stderr, "JFIF generation: qFactor %d\n", qFactor);
	fprintf(stderr,
		"Chrominance uantisation values > 8-bit truncated to 255\n");
	nomsg = 0;
      }
      val = 255;
    }
    emitByte(cinfo, val);
  }
}

/* Output a single Huffman table */
void emit_dht (cinfo, index, bits, vals)
     cInfo *cinfo;
     int   index;
     unsigned char *bits;
     unsigned char *vals;
{
  int length, i;

  emit_marker(cinfo, M_DHT);

  /* Count the number of values by adding the numbers with each bit code */
  length = 0;
  for (i = 1; i <= 16; i++)
    length += bits[i];

  emit_2bytes(cinfo, length + 2 + 1 + 16);  /* Length */
  emitByte(cinfo, index);                  /* Id code for table */

  for (i = 1; i <= 16; i++)
    emitByte(cinfo, bits[i]);              /* The bit division */
  for (i = 0; i < length; i++)              /* the actual values */
    emitByte(cinfo, vals[i]);
}

/* Output all the Huffman tables */
/* The index has bit 4 == 1 for an AC table and == 0 for DC */
/* Index low 4 bits have id, we use 0 for Y and 1 for the colours */
void emit_dhts(cinfo)
     cInfo *cinfo;
{
  emit_dht(cinfo, (tabDC<<4) | tabLUM, dc_luminance_bits, dc_luminance_val);
  emit_dht(cinfo, (tabAC<<4) | tabLUM, ac_luminance_bits, ac_luminance_val);
  emit_dht(cinfo, (tabDC<<4) | tabCRM, dc_chrominance_bits,dc_chrominance_val);
  emit_dht(cinfo, (tabAC<<4) | tabCRM, ac_chrominance_bits,ac_chrominance_val);
}

/* Output a frame marker and details */
void emit_sof (cInfo *cinfo, JPEG_MARKER code)
{
  int i;

  emit_marker(cinfo, code);
  emit_2bytes(cinfo, 3 * cinfo->num_components + 2 + 5 + 1); /* length */

  if (cinfo->image_height > 65535L || cinfo->image_width > 65535L)
  {
    printf("Maximum image dimension for JFIF is 65535 pixels");
    exit(1);
  }

  emitByte(cinfo, cinfo->data_precision);
  emit_2bytes(cinfo, (int) cinfo->image_height);
  emit_2bytes(cinfo, (int) cinfo->image_width);
  emitByte(cinfo, cinfo->num_components);

  for (i = 0; i < cinfo->num_components; i++) {
    emitByte(cinfo, cinfo->comp_info[i].component_id);
    emitByte(cinfo, (cinfo->comp_info[i].h_samp_factor << 4)
		     + cinfo->comp_info[i].v_samp_factor);
    emitByte(cinfo, cinfo->comp_info[i].quant_tbl_no);
  }
}

/* Output a scan header - we do one jvideo compress buffer as a scan */
void emit_sos(cinfo, length)
     cInfo *cinfo;
     int length;
{
  int i;
  static int compId[] =  {IdY,    IdCb,   IdCr};
  static int compTbl[] = {tabLUM, tabCRM, tabCRM};
  emit_marker(cinfo, M_SOS);

  emit_2bytes(cinfo, 2 * (sizeof(compId)/sizeof(int)) + 2 + 1 + 3);/* length */
  emitByte(cinfo, (sizeof(compId)/sizeof(int))); /* numb components */
  for (i = 0; i < (sizeof(compId)/sizeof(int)); i++) {
    int tbl = compTbl[i];
    emitByte(cinfo, compId[i]);
    emitByte(cinfo, (tbl<< 4) /* DC bit */
		     + tbl);   /* AC bit */
  }
  emitByte(cinfo, 0);		/* Spectral selection start = 0 for seq DCT */
  emitByte(cinfo, DCTSIZE2-1);	/* Spectral selection end  = 63 for seq DCT */
  emitByte(cinfo, 0);		/* Successive approximation = 0 for seq DCT */
}

void emit_jfif_app0(cinfo)
     cInfo *cinfo;
{
  emit_marker(cinfo, M_APP0);
  emit_2bytes(cinfo, 16); /* length */
  emitByte(cinfo, 'J');
  emitByte(cinfo, 'F');
  emitByte(cinfo, 'I');
  emitByte(cinfo, 'F');
  emitByte(cinfo, 0);
  emit_2bytes(cinfo, 0x0101); /* version 1.01 */
  emitByte(cinfo, 0); /* next 2 -> pixel aspect ratio */
  emit_2bytes(cinfo, 1);
  if (cinfo->image_width > 500)
    emit_2bytes(cinfo, 2);
  else
    emit_2bytes(cinfo, 1);
  emitByte(cinfo, 0); /* No 'Thumbnail' */
  emitByte(cinfo, 0);
}

void dumpJfifFrame(wfd, compBuf, length, width, height, qFactor, jfifApp)
     int wfd;
     char *compBuf;
     int width, height, qFactor, jfifApp;
{
  int i;

  cInfo ccc;
  cInfo *cinfo = &ccc;

  cinfo->wfd = wfd;
  cinfo->userInfo = (void *) wfd;
  cinfo->image_width = width;
  cinfo->image_height = height;
  cinfo->data_precision = 8;
  cinfo->num_components = 3; /* Y Cb Cr */
  cinfo->comp_info[0].component_id = IdY;
  cinfo->comp_info[0].h_samp_factor = 2;
  cinfo->comp_info[0].v_samp_factor = 1;
  cinfo->comp_info[0].quant_tbl_no = tabLUM; /* (luminence table) */
  cinfo->comp_info[1].component_id = IdCb;
  cinfo->comp_info[1].h_samp_factor = 1;
  cinfo->comp_info[1].v_samp_factor = 1;
  cinfo->comp_info[1].quant_tbl_no = tabCRM;
  cinfo->comp_info[2].component_id = IdCr;
  cinfo->comp_info[2].h_samp_factor = 1;
  cinfo->comp_info[2].v_samp_factor = 1;
  cinfo->comp_info[2].quant_tbl_no = tabCRM;
  cinfo->emit_byte = wrbyte;
  emit_marker(cinfo, M_SOI);
  if (jfifApp) emit_jfif_app0(cinfo);
  emit_dqts(cinfo, qFactor);
  emit_sof(cinfo, M_SOF0); /* SOF0 is baseline (8bit) DCT */
  emit_dhts(cinfo);
  emit_sos(cinfo, length);

/* Remove the trailing zeros inserted by the DMA process */
#ifdef notdef
  while(compBuf[length] == 0) length--;
  length++;
#endif
  write(cinfo->wfd, compBuf, length);
  emit_marker(cinfo, M_EOI);
}

void genJfif(compBuf, length, width, height, qFactor, wrByte, wrBlock, info)
     char *compBuf;
     int  length, width, height, qFactor;
     void (*wrByte)();
     void (*wrBlock)();
     void *info;
{
  int i;

  cInfo ccc;
  cInfo *cinfo = &ccc;

  cinfo->image_width = width;
  cinfo->image_height = height;
  cinfo->data_precision = 8;
  cinfo->num_components = 3; /* Y Cb Cr */
  cinfo->comp_info[0].component_id = IdY;
  cinfo->comp_info[0].h_samp_factor = 2;
  cinfo->comp_info[0].v_samp_factor = 1;
  cinfo->comp_info[0].quant_tbl_no = tabLUM; /* (luminence table) */
  cinfo->comp_info[1].component_id = IdCb;
  cinfo->comp_info[1].h_samp_factor = 1;
  cinfo->comp_info[1].v_samp_factor = 1;
  cinfo->comp_info[1].quant_tbl_no = tabCRM;
  cinfo->comp_info[2].component_id = IdCr;
  cinfo->comp_info[2].h_samp_factor = 1;
  cinfo->comp_info[2].v_samp_factor = 1;
  cinfo->comp_info[2].quant_tbl_no = tabCRM;
  cinfo->emit_byte = wrByte;
  cinfo->userInfo = info;

  emit_marker(cinfo, M_SOI);
  emit_jfif_app0(cinfo);
  emit_dqts(cinfo, qFactor);
  emit_sof(cinfo, M_SOF0); /* SOF0 is baseline (8bit) DCT */
  emit_dhts(cinfo);
  emit_sos(cinfo, length);

/* Remove the trailing zeros inserted by the DMA process */
  while(compBuf[length] == 0) length--;
  length++;
  (*wrBlock)(cinfo->wfd, compBuf, length);
  emit_marker(cinfo, M_EOI);
}

