/*
 * console.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MASH_CONSOLE_H
#define MASH_CONSOLE_H

#include "rc/console-rc.h"
#include <stdio.h>


class MashConsole {
public:
	MashConsole(int initialBufferSize=8000);
	~MashConsole();
	void Init(HINSTANCE hInstance);
	void Create(int x=CW_USEDEFAULT,
		    int y=CW_USEDEFAULT,
		    int width=CW_USEDEFAULT, int height=CW_USEDEFAULT);
	void Destroy();
	void Show(BOOL showFlag);
	void DoModal();
	void SetTitle(const char *title) {
		if (Exists()) SetWindowText(toplevel_, title);
	}

	BOOL Toggle();
	BOOL IsVisible() { return IsWindowVisible(toplevel_); }
	BOOL Exists() { return (toplevel_!=NULL && IsWindow(toplevel_)); }
	BOOL SetBufferSize(int size);

private:
	void Output(const char *buffer, int size);
	void CreateSpace(int need);
	void CopyTo(char *newBuffer, int &size);

	BOOL CreateOutputPipe(int &outputReadHandle);
	void CloseOutputPipe();
	static void ThreadMain(void *args);

	void BuildWindow(HWND toplevel);
	static BOOL CALLBACK AboutDialogProc(HWND hdlg, UINT msg,
					     WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK MainWindowProc_Static(HWND hwnd, UINT msg,
						      WPARAM wParam,
						      LPARAM lParam);
	LRESULT MainWindowProc(HWND hwnd, UINT msg,
			       WPARAM wParam, LPARAM lParam);

	HINSTANCE hInstance_;
	HWND toplevel_, statusBar_, edit_, hide_;

	char *buffer_;
	int len_, maxLen_;


	class SavedFileHandle {
	public:
		SavedFileHandle() : osf_handle_(INVALID_HANDLE_VALUE) { }
		~SavedFileHandle() { }

		BOOL Set(DWORD nStdHandle, int newHandle, FILE *file);
		void Restore(DWORD nStdHandle, FILE *file);

	private:
		HANDLE osf_handle_;
		FILE file_;
	};

	SavedFileHandle savedStdOut_, savedStdErr_;

	friend class OTclMashConsole;
};


#endif /* #if MASH_CONSOLE_H */
