/*
 * mbv2-canv.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *  @(#) $Header: /usr/mash/src/repository/mash/mash-1/mbv2/mbv2-canv.h,v 1.8 2002/02/03 03:17:08 lim Exp $
 */

#ifndef MASH_MBV2_CANV_H
#define MASH_MBV2_CANV_H

#include "mbv2.h"
#include "transform.h"

class MBv2Item;


class MBv2Canvas : public TclObject {
public:
	virtual MBv2CanvId create_item(MBv2Item *item, Bool isLocal)=0;
	virtual Bool delete_item(MBv2CanvId canvId)=0;
	virtual Bool move_item(MBv2CanvId canvId, int dx, int dy)=0;
	virtual Bool raise_after(MBv2CanvId canvId, MBv2CanvId targetId)=0;

	// get_text: min_len refers to the minimum size that the bufffer
	// containing the string returned ought to be. extra is some extra
	// padding that is added to minlen. So the actual buffer that is
	// returned is the greater of (minlen+extra+1) and (actual-len+extra+1)
	// (the +1 is for the trailing \0)
	virtual char *get_text(MBv2CanvId canvId, int minlen=0, int extra=0)=0;
	virtual Bool set_text(MBv2CanvId canvId, const char *text)=0;
};


class MBv2TkCanvas : public MBv2Canvas {
public:
	MBv2TkCanvas() : path_(NULL) { }
	virtual ~MBv2TkCanvas() { if (path_) delete [] path_; }
	virtual int init(int argc, const char * const *argv) {
		const char *path;
		BEGIN_PARSE_ARGS(argc, argv);
		ARG(path);
		END_PARSE_ARGS;
		path_ = new char [strlen(path)+1];
		strcpy(path_, path);
		return TCL_OK;
	}
	int get_scale(int argc, const char * const *argv);
	int rescale  (int argc, const char * const *argv);
	int rescale_to_fit(int argc, const char * const *argv);
	int scale_image   (int argc, const char * const *argv);

	virtual MBv2CanvId create_item(MBv2Item *item, Bool isLocal);
	virtual Bool delete_item(MBv2CanvId canvId);
	virtual Bool move_item(MBv2CanvId canvId, int dx, int dy);
	virtual Bool raise_after(MBv2CanvId canvId, MBv2CanvId targetId);
	// get_text: min_len refers to the minimum size that the bufffer
	// containing the string returned ought to be. extra is some extra
	// padding that is added to minlen. So the actual buffer that is
	// returned is the greater of (minlen+extra+1) and (actual-len+extra+1)
	// (the +1 is for the trailing \0)
	virtual char *get_text(MBv2CanvId canvId, int minlen=0, int extra=0);
	virtual Bool set_text(MBv2CanvId canvId, const char *text);

	inline void imap(double &x, double &y) { matrix_.imap(x, y); }

	static const char *item_name(MBv2ItemType type) {
		if (type > MBv2NoItem && type < MBv2InvalidItem) {
			return itemType2CanvItemType_[type];
		} else return NULL;
	}
	static MBv2ItemType item_type(const char *name) {
		for (int i=MBv2NoItem+1; i < MBv2InvalidItem; i++) {
			if (strcmp(name, itemType2CanvItemType_[i])==0)
				return (MBv2ItemType) i;
		}
		return MBv2InvalidItem;
	}
private:
	const char *interpret_font(const char *font);

	Transform matrix_;
	char *path_;
	static char *itemType2CanvItemType_[];
};


#endif /* #ifdef MASH_MBV2_CANV_H */
