/*
 * cpuinfo.h --
 *
 *      Provides information about the processor
 *
 * Copyright (c) 2001 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *  $Header: /usr/mash/src/repository/mash/mash-1/misc/cpuinfo.h,v 1.1 2001/09/11 05:39:42 delco Exp $
 */

#ifndef CPUINFO_H
#define CPUINFO_H
#include"tclcl.h"

#if defined(WIN32) || defined(__i386__)
#define X86_ASSEMBLER
#endif

// #define TEST_MAIN // test in main()
// #define TEST_EXECUTE // test while in mash

#define OLD_ASM // define if an old assembler is being used

#define FLAG_I086 1
#define FLAG_I286 2
#define FLAG_I386 3
#define FLAG_I486 4
#define FLAG_I586 5
#define FLAG_I686 6
#define FLAG_FAMILY_MASK 7
#define FLAG_INTEL 8
#define FLAG_MMX 16
#define FLAG_SIMD 32
#define FLAG_SIMD_OS 64

class CpuInfo : public TclObject {
public:
    CpuInfo();
    static unsigned int get(); // returns flags
    virtual int command(int argc, const char*const* argv);
private:
    static bool configured;
    static unsigned int flags;
};

class CpuInfoClass : public TclClass {
public:
  CpuInfoClass() : TclClass("CpuInfo") {}
  TclObject* create(int, const char*const*) { return new CpuInfo; }
};

bool supportsMMX(); // returns true if MMX supported, false otherwise
bool supportsSIMD(); // returns true if SIMD can be used (hardware&OS), false otherwise

#endif
