/*
 * jpegwc-tclapi.c --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <tcl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/param.h>

#include "jpegwc.h"
#include "jpeglib.h"

#define JPEGWC2TCL(p) Tcl_CreateObjCommand(interp, #p, p ## _proc, NULL, NULL)

static int
usage(Tcl_Interp *interp, const char *msg)
{
	Tcl_ResetResult(interp);
	Tcl_AppendResult(interp, "invalid number of arguments: ", msg, NULL);
	return TCL_ERROR;
}

static void*
extract_ptr(Tcl_Interp *interp, Tcl_Obj *obj)
{
	int p;
	if (Tcl_GetIntFromObj(interp, obj, &p)!=TCL_OK) return NULL;
	else return (void*)p;
}

static int
jpeg_tran_progressive_proc(ClientData clientData, Tcl_Interp *interp,
			   int objc, Tcl_Obj *CONST objv[])
{
	char *fnsrc, *fndst;
	int len = 0;
	int result = 0;

	if (objc != 3)
		return usage(interp, "jpeg_tran_progressive fsrc fdst");

	fnsrc = Tcl_GetStringFromObj(objv[1], &len);
	fndst = Tcl_GetStringFromObj(objv[2], &len);

	if (fnsrc == NULL || fndst == NULL)
		return TCL_ERROR;

	result = jpeg_tran_progressive(fnsrc, fndst);
	Tcl_SetObjResult(interp, Tcl_NewIntObj(result));
	return TCL_OK;
}

static int
jpeg_reduce_progressive_proc(ClientData clientData, Tcl_Interp *interp,
			     int objc, Tcl_Obj *CONST objv[])
{
	char *fnsrc, *fndst;
	int level;
	int len = 0;
	int result = 0;

	if (objc != 4)
		return usage(interp, "jpeg_reduce_progressive fsrc fdst level");

	fnsrc = Tcl_GetStringFromObj(objv[1], &len);
	fndst = Tcl_GetStringFromObj(objv[2], &len);
	if (fnsrc == NULL || fndst == NULL)
		return TCL_ERROR;

	if (Tcl_GetIntFromObj(interp, objv[3], (int *)&level) != TCL_OK)
		return TCL_ERROR;

	result = jpeg_reduce_progressive(fnsrc, fndst, level);
	Tcl_SetObjResult(interp, Tcl_NewIntObj(result));
	return TCL_OK;
}

static int
jpeg_getrange_progressive_proc(ClientData clientData, Tcl_Interp *interp,
			       int objc, Tcl_Obj *CONST objv[])
{
	char *fnsrc, *fnblks;
	int start_level, end_level;
	int len = 0;
	int result = 0;

	if (objc != 5)
		return usage(interp, "jpeg_getrange_progressive fsrc fblks start_level end_level");

	fnsrc = Tcl_GetStringFromObj(objv[1], &len);
	fnblks = Tcl_GetStringFromObj(objv[2], &len);
	if (fnsrc == NULL || fnblks == NULL)
		return TCL_ERROR;

	if (Tcl_GetIntFromObj(interp, objv[3], (int *)&start_level) != TCL_OK)
		return TCL_ERROR;
	if (Tcl_GetIntFromObj(interp, objv[4], (int *)&end_level) != TCL_OK)
		return TCL_ERROR;

	result = jpeg_getrange_progressive(fnsrc, fnblks, start_level, end_level);
	Tcl_SetObjResult(interp, Tcl_NewIntObj(result));
	return TCL_OK;
}

static int
jpeg_enhance_progressive_proc(ClientData clientData, Tcl_Interp *interp,
			      int objc, Tcl_Obj *CONST objv[])
{
	char *fnsrc, *fndst, *fnblks;
	int num_level;
	int len = 0;
	int result = 0;

	if (objc != 5)
		return usage(interp, "jpeg_enhance_progressive fsrc fdst fblks num_level");

	fnsrc = Tcl_GetStringFromObj(objv[1], &len);
	fndst = Tcl_GetStringFromObj(objv[2], &len);
	fnblks = Tcl_GetStringFromObj(objv[3], &len);
	if (fnsrc == NULL || fndst == NULL || fnblks == NULL)
		return TCL_ERROR;

	if (Tcl_GetIntFromObj(interp, objv[4], (int *)&num_level) != TCL_OK)
		return TCL_ERROR;

	result = jpeg_enhance_progressive(fnsrc, fndst, fnblks, num_level);
	Tcl_SetObjResult(interp, Tcl_NewIntObj(result));
	return TCL_OK;
}

static int
jpeg_is_progressive_proc(ClientData clientData, Tcl_Interp *interp,
			 int objc, Tcl_Obj *CONST objv[])
{
	FILE *f;
	char *fn;
	int len = 0;
	int result = 0;

	if (objc != 2)
		return usage(interp, "jpeg_is_progressive f");

	fn = Tcl_GetStringFromObj(objv[1], &len);
	if (f == NULL)
		return TCL_ERROR;

	f = fopen(fn, "rb");
	result = jpeg_is_progressive(f);
	fclose(f);
	Tcl_SetObjResult(interp, Tcl_NewIntObj(result));
	return TCL_OK;
}

/*
static int
jpeg_is_progressive_proc(ClientData clientData, Tcl_Interp *interp,
			 int objc, Tcl_Obj *CONST objv[])
{
	FILE *f;
	int len = 0;
	int result = 0;

	if (objc != 2)
		return usage(interp, "jpeg_is_progressive f");

	f = (FILE *)extract_ptr(interp, objv[1]);
	if (f == NULL)
		return TCL_ERROR;

	result = jpeg_is_progressive(f);
	Tcl_SetObjResult(interp, Tcl_NewIntObj(result));
	return TCL_OK;
}
*/

int
JPEGWC_Init(Tcl_Interp *interp)
{
	JPEGWC2TCL(jpeg_tran_progressive);
	JPEGWC2TCL(jpeg_reduce_progressive);
	JPEGWC2TCL(jpeg_getrange_progressive);
	JPEGWC2TCL(jpeg_enhance_progressive);
	JPEGWC2TCL(jpeg_is_progressive);
	return TCL_OK;
}
