/*
 * ps-gs.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1992-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef lint
static char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/ps/ps-gs.cc,v 1.7 2002/02/03 04:14:18 lim Exp $";
#endif

#ifdef __osf__
#define _OSF_SOURCE
#define _BSD
#endif

#include <osfcn.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <X11/Xatom.h>

#ifndef GS_EXEC
#define GS_EXEC "gs"
#endif

static GPSinterp* active_interp;

static SIGRET
sigpipe_handler(...)
{
	if (active_interp) {
		active_interp->interp_done(0);
	}
#if !defined(IRIX5)&&!defined(ultrix)&&!defined(__bsdi__)&&!defined(__osf__)&&!defined(__hpux__)&&!defined(AIX)&&!defined(linux)
	return (0);
#endif
}

static const char wbpssave[] = "\
/_$wb$showpage /showpage load def /showpage{stop}bind def\n\
";

extern const char*  wbpssrvrloop;

#include "ps.h"
#include "proc.h"

class PSstream;
class DrawOpPSComp;
class View;
class Raster;

class GPSinterp : public PSinterp {
    public:
	GPSinterp();
	~GPSinterp();
	int command(int argc, const char*const* argv);

	virtual int send(DrawOpPSComp*, View*, PSstream*);
	virtual int busy();
	virtual void interp_page(Window msgwin);
	virtual void interp_done(Window msgwin);
    private:
	void kill();
	void done();
	void setup_property();

	TkWidget* window_;
	Tcl_Channel channel_;

	Window pixmapID();/*FIXME*/
	Window windowID_;
	Window mwin_;
};

static Class GSinterpClass : public TclClass {
	H261PixelEncoderClass() : TclClass("PSInterp/GS") {}
	TclObject* create(int argc, const char*const* argv) {
		return (new GPSinterp);
	}
} gsinterp_class;

GPSinterp::GPSinterp() :
	window_(0),
	windowID_(0),
	mwin_(0),
	scale_(1.),
{
#ifdef notdef
	Display* display = Session::instance()->default_display();
	XDisplay* xd = display->rep()->display_;
	proc_.setenv("DISPLAY", DisplayString(xd));
#endif
	char t[512];
	sprintf(t, wbpssrvrloop, tmpfile_);
	execlen_ = strlen(t);
	execstr_ = strdup(t);
}

GPSinterp::~GPSinterp()
{
#ifdef notdef
	kill();
#endif
}

int GPSinterp::command(int argc, const char*const* argv)
{
	if (argc == 2) {
#ifdef notyet
		if (strcmp(argv[1], "next-page") == 0) {
			window_->interp_nextpage(mwin_);
			return (TCL_OK);
		}
#endif
	} else if (argc == 3) {
		if (strcmp(argv[1], "render-file") == 0) {
			renderFile(argv[2]);
			return (TCL_OK);
		}
		if (strcmp(argv[1], "bind-window") == 0) {
			win_ = (TkWidget*)TclObject::lookup(argv[2]);
			return (TCL_OK);
		}
	}
	return (PSinterp::command(argc, argv));
}

int GPSinterp::busy()
{
/*FIXME*/
#ifdef notdef
	if (strm_) {
		if (view_->scale() == scale_ &&
		    view_->orientation() == orient_)
			return (1);
		/*
		 * gs may be wedged  - we're going to kill it anyway
		 * since window has changed geometry so kill it now.
		 */
		interp_done(mwin_);
	}
#endif
	return (0);
}

#ifdef notdef
int GPSinterp::send(DrawOpPSComp* o, View* v, PSstream* s)
{
	/*
	 * dump the postscript page to a tmpfile FIXME
	 */
	int cc;
	const char* bp;
	lseek(tmpfd_, 0, SEEK_SET);
	for (int len = 0; (cc = strm_->read(bp)) > 0; len += cc) {
		write(tmpfd_, (char*)bp, cc);
		strm_->advance(cc);
	}
	ftruncate(tmpfd_, len);

	if (proc_.writefd() <= 0) {
		view_ = v;
		orient_ = view_->orientation();
		scale_ = view_->scale();
		window_ = view_->win();
		raster_ = new Raster(display->to_pixels(view_->page_width()),
				     display->to_pixels(view_->page_height()));
		Resource::ref(raster_);

		windowID_ = window_->Window::rep()->xwindow_;
		/*
		 * Here's where we hook into the kludge invented by
		 * Tim Theise to pass an X window to ghostscript.
		 * We bind the window ID to the environment
		 * variable GHOSTVIEW.	We then pass a bunch of
		 * information to ghostscript via the "GHOSTVIEW"
		 * property on the window indicated here.  One of
		 * these attributes is the Drawable, in our case a
		 * pixmap ID.  This is handled in setup_property().
		 */
		char buf[32];
		sprintf(buf, "%lu %lu", windowID_, pixmapID());
		proc_.setenv("GHOSTVIEW", buf);
		setup_property();
		/*
		 * Arrange for special ghostscript ClientMessage events
		 * to be dispatched to us.
		 */
		window_->bind_interp(this, pixmapID());
		XDisplay* xd = window_->display()->rep()->display_;
		XFlush(xd);

		/*FIXME*/
		active_interp = this;
		(void)signal(SIGPIPE, sigpipe_handler);
		(void)signal(SIGCHLD, sigpipe_handler);

		char* argv[] = {
			GS_EXEC, "-dQUIET", "-dNOPAUSE", "-dSAFER",
			"-dNOPLATFONTS", "-", 0 };
		proc_.fork(GS_EXEC, 2, &argv[0]);
		proc__.nonblock(proc_.writefd());
		write(proc_.writefd(), wbpssave, sizeof(wbpssave)-1);
	} else {
		window_->interp_nextpage(mwin_);
	}
	/* tell gs to look at page */
	write(proc_.writefd(), execstr_, execlen_);
	return (0);
}
#endif

int GPSinterp::renderFile(const char* file)
{
	if (proc_.writefd() <= 0) {
		view_ = v;
		orient_ = view_->orientation();
		scale_ = view_->scale();
		window_ = view_->win();
		raster_ = new Raster(display->to_pixels(view_->page_width()),
				     display->to_pixels(view_->page_height()));
		Resource::ref(raster_);

		windowID_ = window_->Window::rep()->xwindow_;
		/*
		 * Here's where we hook into the kludge invented by
		 * Tim Theise to pass an X window to ghostscript.
		 * We bind the window ID to the environment
		 * variable GHOSTVIEW.	We then pass a bunch of
		 * information to ghostscript via the "GHOSTVIEW"
		 * property on the window indicated here.  One of
		 * these attributes is the Drawable, in our case a
		 * pixmap ID.  This is handled in setup_property().
		 */
		char buf[32];
		sprintf(buf, "%lu %lu", windowID_, pixmapID());
		proc_.setenv("GHOSTVIEW", buf);
		setup_property();
		/*
		 * Arrange for special ghostscript ClientMessage events
		 * to be dispatched to us.
		 */
		window_->bind_interp(this, pixmapID());
		XDisplay* xd = window_->display()->rep()->display_;
		XFlush(xd);

		/*FIXME*/
		active_interp = this;
		(void)signal(SIGPIPE, sigpipe_handler);
		(void)signal(SIGCHLD, sigpipe_handler);

		char* argv[] = {
			GS_EXEC, "-dQUIET", "-dNOPAUSE", "-dSAFER",
			"-dNOPLATFONTS", "-", 0 };
		proc_.fork(GS_EXEC, 2, &argv[0]);
		proc__.nonblock(proc_.writefd());
		write(proc_.writefd(), wbpssave, sizeof(wbpssave)-1);
	} else {
		window_->interp_nextpage(mwin_);
	}

	char wrk[512];
	sprintf(wrk, wbpssrvrloop, psFile);

	/* tell gs to look at page */
	(void)Tcl_Write(channel_, wrk, strlen(wrk));
	(void)Tcl_Flush(channel_);

	return (0);
}

void GPSinterp::kill()
{
	active_interp = 0;
	if (raster_) {
		Resource::unref(raster_);
		raster_ = 0;
	}
	if (window_) {
		window_->unbind_interp(this);
		window_ = 0;
	}
	if (proc_.writefd() >= 0) {
		close(proc_.writefd());
		proc_.kill();
	}
}

void GPSinterp::done()
{
	delete strm_;
	strm_ = 0;
}

void GPSinterp::setup_property()
{
	Display* display = Session::instance()->default_display();

	/* FIXME not quite right */
	/* Both Interviews & Ghostview use the name 'dpi' for a
	 * screen scaling number that has nothing whatsoever to
	 * do with 'dots per inch'.  This caused no end of confusion
	 * when trying to set up the scaling for ghostscript.  Gs
	 * wants to know the screen pixels per point ratio so it
	 * takes the dpi number we pass & divides by 72.  IV also
	 * works in points so the 'dpi' number gs needs is just
	 * how just to to_pixel xform of 72 (points).
	 */
	double dpi = double(display->to_pixels(72000.)) * scale_ / 1000.;

	/* FIXME compiler bug workaround (problem passing float) ... */
	char buf[1024];
	char* cp = buf;
	/*
	 * <BackingStoreFlag, Orientation, llx, lly, urx, ury>
	 * The bounding box coordinates are Postscript style (i.e.,
	 * in points, not pixels).
	 */
	Coord w, h;
	if (orient_) {
		w =  raster_->height();
		h =  raster_->width();
	} else {
		w =  raster_->width();
		h =  raster_->height();
	}
	sprintf(cp, "0 %d 0 0 %u %u", orient_, int(w / scale_ + .5),
		int(h / scale_ + 5.));
	cp += strlen(cp); *cp++ = ' ';
	sprintf(cp, "%lg %lg", dpi, dpi);
	cp += strlen(cp); *cp++ = ' ';
	/*
	 * <LeftMargin, BottomMargin, RightMargin, TopMargin, Width, Height>
	 * The margins are in points.  The width & height are in pixels.
	 */
	sprintf(cp, "0 0 0 0 %lu %lu", raster_->pwidth(), raster_->pheight());

	XDisplay* xd = display->rep()->display_;
	Atom atom = XInternAtom(xd, "GHOSTVIEW", False);
	XChangeProperty(xd, windowID_, atom, XA_STRING, 8, PropModeReplace,
			(u_char *)buf, strlen(buf));
}

XWindow GPSinterp::pixmapID()
{
	return (raster_->rep()->pixmap_);
}

int GPSinterp::output(int)
{
	return (-1);
}

int GPSinterp::input(int)
{
	//printf("GPSinterp::input!\n");
	return (-1);
}

int GPSinterp::error(int)
{
	printf("GPSinterp::error!\n");
	return (-1);
}

void GPSinterp::interp_done(Window mwin)
{
	if (strm_) {
		printf("wb: gs interpreter aborted.\n");
		interp_page(mwin);
	}
	kill();
}

void GPSinterp::interp_page(Window mwin)
{
	mwin_ = mwin;
	if (raster_) {
		Raster* r = new Raster(*raster_);
		op_->done(r, page_, view_, orient_, scale_);
	}
	done();
}
