/*
 * otcl-quantify.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1999-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "tclcl.h"
#include "quantify.h"

class QuantCntrl : public TclObject {
public:
  QuantCntrl() : TclObject() {};

  int command (int argc, const char*const*argv);
};

static QuantCntrl quant_cntrl;

int QuantCntrl::command (int argc, const char*const*argv) {
  Tcl&tcl = Tcl::instance();

  if (argc == 2) {
    if (strcmp(argv[1], "is_running") == 0) {
      if (quantify_is_running()) {
	tcl.result("1");
      } else {
	tcl.result("0");
      }
      return (TCL_OK);
    }
    if (strcmp(argv[1], "start_recording") == 0) {
      quantify_start_recording_data();
      return (TCL_OK);
    }
    if (strcmp(argv[1], "stop_recording") == 0) {
      quantify_stop_recording_data();
      return (TCL_OK);
    }
    if (strcmp(argv[1], "is_recording") == 0) {
      if (quantify_is_recording_data()) {
	tcl.result("1");
      } else {
	tcl.result("0");
      }
      return (TCL_OK);
    }
    if (strcmp(argv[1], "start_recording_system") == 0) {
      quantify_start_recording_system_calls();
      return (TCL_OK);
    }
    if (strcmp(argv[1], "stop_recording_system") == 0) {
      quantify_stop_recording_system_calls();
      return (TCL_OK);
    }
    if (strcmp(argv[1], "is_recording_system") == 0) {
      if (quantify_is_recording_system_calls()) {
	tcl.result("1");
      } else {
	tcl.result("0");
      }
      return (TCL_OK);
    }
    if (strcmp(argv[1], "save") == 0) {
      quantify_save_data();
      return (TCL_OK);
    }
    if (strcmp(argv[1], "clear") == 0) {
      quantify_clear_data();
      return (TCL_OK);
    }

  }
  if (argc == 3) {
    if (strcmp(argv[1], "save") == 0) {
      quantify_save_data_to_file(argv[2]);
      return (TCL_OK);
    }
    if (strcmp(argv[1], "annotate") == 0) {
      quantify_add_annotation(argv[2]);
      return (TCL_OK);
    }
  }
  return TclObject::command(argc, argv);
}

/*
 * OTcl class binding to get name of well known
 * quantify control object
 */

static class QuantifyCntrlClass : public TclClass {
public:
  QuantifyCntrlClass() : TclClass("QuantifyControl") {}
  TclObject *create(int argc, const char*const* argv) {
    return ((TclObject *) (&quant_cntrl));
  }
} quant_cntrl_class_;

