/*
 * transmitter-rtp.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef lint
static const char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/rtp/transmitter-rtp.cc,v 1.13 2002/02/03 04:15:47 lim Exp $";
#endif

#include "config.h"
#include "transmitter-rtp.h"
#include "rtp.h"
#include "source.h"
#include "ntp-time.h"
#include "pktbuf.h"

RTP_Transmitter::RTP_Transmitter() : sm_(0)
{
}

void RTP_Transmitter::update_stats(pktbuf* pb)
{
	int layer = pb->layer;
	if (layer >= loop_layer_)
		/*FIXME*/
		return;

	Transmitter::update_stats(pb);
	rtphdr* rh = (rtphdr*) pb->dp;
	int flags = ntohs(rh->rh_flags);
	if (flags & RTP_M)
		++nf_;
}

/*FIXME move this into RTP_Session? */
// That's done (check RTP_Session::recv() at mash/rtp/session-rtp.cc).
//	Anyway, this code is still called by the inner decoder loop
void RTP_Transmitter::loopback(pktbuf* pb)
{
	int layer = pb->layer;
	if (layer >= loop_layer_) {
		/*FIXME*/
		pb->release();
		return;
	}

	rtphdr* rh = (rtphdr*)pb->dp;
	int cc = pb->len;
	Source* s = sm_->localsrc();
	timeval now = unixtime();
	Source::Layer& sl = s->layer(pb->layer);
	sl.lts_data(now);
	s->action();
	sl.sts_data(rh->rh_ts);
	sl.np(1);
	sl.nb(cc);
	sl.cs((u_int16_t)ntohs(rh->rh_seqno), s);

	int flags = ntohs(rh->rh_flags);
	if (flags & RTP_M) {
		sl.nf(1);
	}
	int fmt = flags & 0x7f;
	/*
	 * Handle initialization of loopback decoder
	 * and changes in the stream.
	 */
	PacketModule* h = s->handler();
	if (h == 0)
		h = s->activate(fmt);
	else if (s->format() != fmt)
		h = s->change_format(fmt);

	if (s->mute() || !loopback_) {
		pb->release();
		return;
	}

	h->recv(pb);
}
