/*
 * pktbuf-srmv2.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/srmv2/pktbuf-srmv2.h,v 1.5 2002/02/03 04:17:12 lim Exp $
 */

#ifndef pktbuf_srmv2_h
#define pktbuf_srmv2_h

#include "pktbuf.h"
#include "srmv2.h"
#include "source-srmv2.h"
#include "all-types.h"
class SRMv2_Source;

class SRMv2_BufferPool : public BufferPool {

public:
	SRMv2_BufferPool() { }
	pktbuf* alloc(unsigned char type = 0);
	int command(int, const char *const *);

	void build_cmnhdr(pktbuf *pb, u_int8_t pt);
	void build_conhdr(pktbuf *pb, int *srcid, u_int32_t cid);
	void build_aduhdr(pktbuf *pb, u_int8_t atype, u_int16_t alen,
			  u_int32_t seqno, ntp64 timestamp, u_int8_t frag);
	void build_fraghdr(pktbuf *pb, u_int8_t frag, u_int32_t offset);
	void build_rreqhdr(pktbuf *pb, unsigned int ss, unsigned int es,
			   unsigned int sbytes, unsigned int ebytes);
	void build_label(pktbuf *pb, char *label);
	void build_srchdr(pktbuf *pb, int *srcid);
	void build_announcehdr(pktbuf *pb, srmv2_announcehdr *salist, int count);

	inline int  ip_mtu() { return (NET_MTU - SRMv2HDR_SIZE); }

protected:
	SRMv2_Source *source_;
};

#endif
