/*
 * supp-srmv2.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef srmv2_supp_h
#define srmv2_supp_h

#ifndef Bool
#define Bool int
#endif
#include "session-srmv2.h"
#define SRMv2_CANCEL 0
#define SRMv2_BACKOFF 1

class SRMv2_Edge {
public:
	unsigned int adu;
	unsigned int byte;
	SRMv2_Edge() : adu(0), byte(0) {}
	SRMv2_Edge(unsigned int a, unsigned int b) : adu(a), byte(b) {}
	SRMv2_Edge(SRMv2_Edge& e) {
		adu = e.adu;
		byte = e.byte;
	}
	void set_edge(unsigned int a, unsigned int b) {
		adu = a;
		byte = b;
	}
	void advance(Bool eoa) {
		if (!eoa) {
			byte ++;
		} else {
			adu ++;
			byte = 0;
		}
	}
	inline Bool operator==(const SRMv2_Edge e) {
		return (e.adu == adu && e.byte == byte);
	}
	inline Bool operator<=(const SRMv2_Edge e) {
		return ((adu < e.adu) || (adu == e.adu && byte <= e.byte));
	}
	Bool operator<(const SRMv2_Edge e) {
		return ((adu < e.adu) || (adu == e.adu && byte < e.byte));
	}
};

class SRMv2_Range : public Timer {
public:
	SRMv2_Range(unsigned int cid, SRMv2_Edge& l, SRMv2_Edge& r) :
		left(l), right(r), next(0), cid_(cid), backoff_level_(0) {}
	SRMv2_Range(SRMv2_Range& r) :
		left(r.left), right(r.right), next(0), cid_(r.cid_) {}
	SRMv2_Range(unsigned int cid, unsigned int a1, unsigned int b1,
		    unsigned int a2, unsigned int b2) {
		cid_ = cid;
		left.set_edge(a1, b1);
		right.set_edge(a2, b2);
	}
	~SRMv2_Range() {
		cancel();
	}
	inline Bool valid() {
		return (left < right);
	}
	inline Bool empty() {
		return (left == right);
	}
	void sched_timeout(double ms, SRMv2_Session *session, SRMv2_Source *src) {
		period_ = ms;
		if (session)
			session_ = session;
		source_ = src;
		msched((int) period_);
	}
	void backoff() {
		cancel();
		if (backoff_level_ < 10)
			backoff_level_ ++;
		period_ = session_->backoff(source_, backoff_level_);
//		printf("B %d %d.%d %d.%d level %d backoff %f\n",
//		       cid_, left.adu, left.byte, right.adu, right.byte, backoff_level_, period_);
		msched((int) period_);
	}
	SRMv2_Edge left, right;
	SRMv2_Range *next;
	unsigned int cid_;
	double period_; /* in ms */
	unsigned int backoff_level_;
	SRMv2_Source* source_;
	SRMv2_Session* session_;
	unsigned int type_;

protected:
	void timeout() {
		session_->send_rreq(source_, left.adu, left.byte, right.adu,
				    right.byte, cid_);
		backoff();
	}
};

class SRMv2_SuppQueue {
public:
	SRMv2_SuppQueue() : list_(0) {}
	void do_delete(SRMv2_Range *prev);
	void insert_range(SRMv2_Range *range, SRMv2_Range *pos);
	void insert_range(SRMv2_Range *range);
	void append_copy(SRMv2_Range *range, SRMv2_Range *head);
	void append_range(SRMv2_Range *range, SRMv2_Range *head);
	void append_range(SRMv2_Range *range);
	void process_intersection(SRMv2_Range *r, Bool flag);
	void display();
	void process(SRMv2_Range *prev, Bool flag);
	void backoff(unsigned int cid, SRMv2_Edge left, SRMv2_Edge right) {
		SRMv2_Range r(cid, left, right);
		process_intersection(&r, SRMv2_BACKOFF);
	}
	void cancel(unsigned int cid, SRMv2_Edge& left, SRMv2_Edge& right) {
		SRMv2_Range r(cid, left, right);
		process_intersection(&r, SRMv2_CANCEL);
	}
protected:
	SRMv2_Range *list_;
};
#endif

