# servent.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1996-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


import Trace
#Trace on ; Trace add Servent

#
# maintains data about a service (or servent in mash platform lingo)
# that can be spawned
#
Class Servent

# initialize the Servent based on the contents of `line', where
# line is formatted as:<p>
#
# {announcement to describe srv} {srv_script_URL} {exec_cmd} {args}
#
#<p> only the first two lists are required. Anything with valid
# mash-object=foo or WPI=bar entries in the announcement can be
# allocated/ used by the UC client application)
#
Servent public init {line} {
    Trc $class "--> ${class}::$proc $line \[llen=[llength $line]\]"
    $self instvar pid_ rv_msg_ scripturl_ execcmd_ args_ \
	    scriptfile_ uniqid_ exectime_

    set pid_ -666
    set execcmd_ "smash"
    set args_ ""
    set scriptfile_ ""
    set uniqid_ "[random]@[pid]@[localaddr]"
    if {[llength $line] < 2} {
	puts "Bad [$self info class]::init arg: `$line'"
	return
    }
    set rv_msg_ [lindex $line 0]
    set scripturl_ [lindex $line 1]
    if {[llength $line] > 2} {set execcmd_ [lindex $line 2]}
    if {[llength $line] > 3} {set args_ [lindex $line 3]}
}

#
Servent public pid {} {
    Trc $class "--> ${class}::$proc"
    $self instvar pid_
    return $pid_
}

#
Servent public set_pid {i} {
    Trc $class "--> ${class}::$proc"
    $self instvar pid_
    set pid_ $i
}

#
Servent public rv_msg {} {
    Trc $class "--> ${class}::$proc"
    $self instvar rv_msg_
    Trc $class "`$rv_msg_'"
    return $rv_msg_
}

#
Servent public execargs {} {
    Trc $class "--> ${class}::$proc"
    $self instvar args_
    return $args_
}

#
Servent public url {} {
    Trc $class "--> ${class}::$proc"
    $self instvar scripturl_
    return $scripturl_
}

#
Servent public scriptfile {} {
    Trc $class "--> ${class}::$proc"
    $self instvar scriptfile_
    return $scriptfile_
}

#
Servent public set_scriptfile {n} {
    Trc $class "--> ${class}::$proc"
    $self instvar scriptfile_
    set scriptfile_ $n
}

#
Servent public uniqid {} {
    Trc $class "--> ${class}::$proc"
    $self instvar uniqid_
    return $uniqid_
}

#
Servent public exectime {} {
    Trc $class "--> ${class}::$proc"
    $self instvar exectime_
    return $exectime_
}

#
Servent public set_exectime {n} {
    Trc $class "--> ${class}::$proc"
    $self instvar exectime_
    set exectime_ $n
}

#
Servent public execcmd {} {
    Trc $class "--> ${class}::$proc"
    $self instvar execcmd_
    return $execcmd_
}

