# app-mbv2.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/mbv2/app-mbv2.tcl,v 1.12 2002/02/03 04:21:59 lim Exp $


import RTPApplication MTrace MBv2UI MBv2Session mashutils

Class MBv2App -superclass RTPApplication


#
# Initialize the global variables we need
# Creates a frame using the provided <i>path</i> and
# packs the mediaboard into it.
#
MBv2App public init { path argv } {
	$self instvar mbui_
        $self next mb

	set o [$self options]
	$self init_args $o
        $self init_resources $o
	$o load_preferences "mb"
	set argv [$o parse_args $argv]
	if { [llength $argv] == 0 && [$self get_option mbSessionSpec]=={} } {
		set argv 224.2.55.77/8000
	}

	if { [llength $argv] > 0 } {
		$self add_option mbSessionSpec [lindex $argv 0]
		if { [llength $argv] > 1 } {
			set extra [lindex $argv 1]
			$self fatal "extra arguments (starting with $extra)"
		}
	}

        MTrace init {trcMB}
	#{trcMB trcVerbose}
	catch {srm_trace_flags 0}

	# check if we have the rtpName and rtpEmail definitions
	$self check_rtp_sdes

        $self init_ui $path

	set title "mbv2: [$self get_option conferenceName] ([$self get_option \
			mbSessionSpec])"
	wm title [winfo toplevel $path] $title
	$self init_srm_session [$self get_option mbSessionSpec]
}


#
MBv2App instproc init_args {o} {
        # temporary parameter for debugging
	$o register_option -u mbv2CnamePrefix
	$o register_option -cnameprefix mbv2CnamePrefix
	$o register_option -myname rtpName

	# session address
	$o register_option -sa mbSessionSpec
	$o register_option -C conferenceName
	$o register_option -K sessionKey

	$o register_boolean_option -recvonly mbRecvOnly
	$o register_option -geometry geometry
}


#
# These can be overridden.
#
MBv2App instproc init_resources {o} {
        option add *Radiobutton.relief flat startupFile
}


MBv2App public init_ui { path } {
	$self instvar ui_
	set ui_ [new MBv2UI $path]
	pack $path -fill both -expand 1 -side bottom

	# create the menu bar
	$ui_ create_menu $path
}


MBv2App public init_srm_session { spec } {
	$self instvar session_
	set session_ [new MBv2Session $spec [$self get_option mbv2CnamePrefix]]
	$self instvar ui_
	$ui_ session $session_

	set cname [$self get_option cname]
	if { $cname == "" } {
		set cname [$self get_option mbv2CnamePrefix]
		if { $cname == "" } { set cname [user_heuristic] }
		set cname ${cname}@[localaddr]
	}
	$session_ app_info [$session_ sender] [$self get_option rtpName] $cname
	return
}
