# distrib_rec_agent.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1999-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/pathfinder/distrib_rec_agent.tcl,v 1.4 2002/02/03 04:22:06 lim Exp $


import Rec_Agent ArchiveSystem/Record/Monitored Observer AnnounceListenManager/AS/Client/Aries

Class Rec_Agent/Distrib -superclass {Rec_Agent Observer}

# start a local recorder and requested distrib recorders
Rec_Agent/Distrib private start_recording { program } {

	mtrace trcNet "-> Starting recorder"
	$self instvar archive_ archive_array_ start_status_array_ \
			module_array_ schedule_array_ active_platforms_

	set key [get_key $program]

	# Use a timestamp for the module name and add the module to the
	# module_array_.
	set module [string trim [clock clicks] -]
	set module_array_($key) $module

	# Use the ArchiveSystem/Record class for recording and write
	# the SDP Program information to the catalog file.
	set archive_sys [new ArchiveSystem/Record/Monitored]
	$archive_sys attach_observer $self
	$archive_sys open $archive_ $module
	$archive_sys write_announcement $program

	# Write relevant recording information to the catalog file
	set current [$self readable_time [clock seconds]]
	set info "record_start=$current"
	$archive_sys write_info $info

	# Request a notification if the recording quality falls below
	# a threshold.
	set drop_rate 5 ; # Threshold is a 5% drop rate
	$archive_sys set_thresh $drop_rate

	# Begin recording and add the archive_sys object to the
	# archive_array_ so that the recording can later be stopped.
	$archive_sys record_program $program $module
	set archive_array_($key,local) $archive_sys

	# start requested distributed recorders
	if [info exists active_platforms_($key)] {
		foreach p $active_platforms_($key) {

			$self add_recorder $program $p

		}
	}

	# Update the start-status array.
	set start_status_array_($key) "Recording"

	# Update the schedule array by deleting the entry for this
	# program, if the entry exists.
	# ???
	set exists [array names schedule_array_ $key]
	if { $exists != "" } {
		# ???
	}
}



#
Rec_Agent/Distrib public return_distrib_status { key } {
	$self instvar active_platforms_ archive_array_

	set status {}
	if [info exists active_platforms_($key)] {
		foreach p $active_platforms_($key) {
			lappend status $archive_array_($key,$p)
		}
	}
	return $status

}

# Called by ArchiveSystem to report an error rate above the threshold
# set by monitor_quality
Rec_Agent/Distrib public low_quality {program loc} {


	if {[$self get_option allow_distrib] == "yes" } {
		# Need to check that loc is valid
		$self add_recorder $program $loc
	}
}

# Called by ArchiveSystem to report an error rate below the threshold
# set by monitor_quality
Rec_Agent/Distrib public higher_quality {program loc} {

	$self instvar active_platforms_ archive_array_

	if {[$self get_option allow_distrib] == "yes" } {
		set key [get_key $program]
		if [info exists archive_array_($key,$loc)] {
			delete $archive_array_($key,$loc)
			unset archive_array_($key,$loc)
		}
		# remove loc from active_platforms list
		set index [lsearch -exact $active_platforms_($key) $loc]
		if {$index != -1} {
			set active_platforms_($key) [lreplace $active_platforms_($key) $index $index]
		}
		if {[llength $active_platforms_($key)] == 0} {
			unset active_platforms_($key)
		}
	}

}


# Add a distributed recorder
Rec_Agent/Distrib private add_recorder {program platform} {
	$self instvar archive_ archive_array_ start_status_array_ \
			schedule_array_ active_platforms_

	set key [get_key $program]
	if {[info exists archive_array_($key,$platform)]} {
		return

	} else {
		mtrace trcNet "-> Starting another recorder"

		lappend active_platforms_($key) $platform
		set start_status $start_status_array_($key)
		if [string match *Recording* $start_status] {
			set archive_agent [new AnnounceListenManager/AS/Client/Aries $platform 20000 "urn:aries" [[$program base] obj2str]]
			$archive_agent start
			set archive_array_($key,$platform) $archive_agent
		}
		#after 1000 "$self begin_collection $key $platform"

	}
}



#
# The stop_recording method stops the recording of the specified
# Program. If the recording has not yet begun, the scheduled recording
# is cancelled.
#
Rec_Agent/Distrib public stop_recording { program } {
	$self instvar active_platforms_ archive_array_

	$self next $program

	# Stop the distrib recordings by deleting the archive_sys object.

	set key [get_key $program]
	if [info exists active_platforms_($key)] {
		foreach p $active_platforms_($key) {
			delete $archive_array_($key,$p)
			unset archive_array_($key,$p)
		}
		unset active_platforms_($key)
	}
}
