# ui-recorder.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1996-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


import ImageTextButton Dialog Observer ScrolledWindow/Expand DropDown ScrolledListbox DirectoryBox VcrIcons

WidgetClass RecorderUI/Input -superclass Dialog -default {
	{ .title "Recorder" }
	{ .address.width 15 }
	{ .listbox.scrollbar both }
	{ .listbox.selectMode multiple }
	{ .listbox.bbox.width 225 }
	{ .listbox.bbox.height 150 }
	{ .listbox*Label.borderWidth 1 }
	{ .listbox.bbox.highlightThickness 1 }
	{ .listbox.Scrollbar.borderWidth 1 }
	{ .listbox.Scrollbar.highlightThickness 1 }
	{ .listbox.Scrollbar.width 10 }
	{ .listbox.borderWidth 1 }
	{ .listbox.relief sunken }

	{ *Menubutton.borderWidth 1 }
	{ *Menubutton.highlightThickness 1 }
	{ *Entry.borderWidth 1 }
	{ *Entry.highlightThickness 1 }
	{ .protocol.button.anchor w }
	{ .media.borderWidth 1 }
	{ .media.relief raised }
	{ .media.highlightThickness 1 }
	{ .media.entry.borderWidth 0 }
	{ .media.entry.highlightThickness 0 }
	{ .media.entry.relief flat }
	{ .media.button.borderWidth 0 }
	{ .media.button.highlightThickness 0 }

	{ *ImageTextButton.borderWidth 1 }
	{ *ImageTextButton.highlightThickness 1 }
	{ *ImageTextButton.orient horizontal }
	{ *font WidgetDefault }
	{ *LabeledWidget.label.font WidgetDefault(-boldfont) }
	{ *dirbox.entry_label.font WidgetDefault(-boldfont) }
}

#	{ *Entry.background White }
#	{ *listbox*window.background White }
#	{ *listbox*bbox.background White }
#	{ *listbox*Label.normalBackground White }
#	{ *dirbox*window.background White }
#	{ *dirbox*bbox.background White }
#	{ *dirbox*HierarchicalListboxItem.normalBackground White }


RecorderUI/Input instproc destroy { } {
	$self instvar filedlg_
	if [info exists filedlg_] {
		destroy $filedlg_
	}
	$self tkvar media_
	catch {trace vdelete media_ w "$self media_changed_"}
	$self next
}


RecorderUI/Input instproc build_widget { path } {
	$self instvar protocols_

	# instantiate the protocols_ array
	set protocols_(mediaboard) SRM
	set protocols_(video)      RTP
	set protocols_(audio)      RTP

	#create the enclosing frames
	frame $path.f1
	frame $path.f2

	# create the session name box
	entry $path.session -textvariable [$self tkvarname session_id_]
	LabeledWidget $path.session_label -label "Session ID:" -underline 0 \
			-orient horizontal -widget $path.session

	# create the catalog file box
	entry $path.catalog -textvariable [$self tkvarname catalog_filename_]
	LabeledWidget $path.catalog_label -label "Catalog file:" -underline 0 \
			-orient horizontal -widget $path.catalog
	ImageTextButton $path.catalog_browse -image Icons(browse) -text \
			"Browse" -underline 0 -command "$self browse_catalog_"

	# create a separator
	frame $path.sep1 -bd 1 -relief groove -height 2

	# create the media selection widget
	DropDown $path.protocol -variable [$self tkvarname protocol_]
	$path.protocol insert end RTP SRM
	LabeledWidget $path.protocol_label -label Protocol: -underline 0 \
			-orient horizontal -widget $path.protocol

	# create the media selection widget
	DropDown/Text $path.media -variable [$self tkvarname media_]
	eval [list $path.media] insert end [lsort [array names protocols_]]
	LabeledWidget $path.media_label -label Media: -underline 3 \
			-orient horizontal -widget $path.media

	# create the address entry box
	entry $path.address -textvariable [$self tkvarname addr_]
	LabeledWidget $path.address_label -label Address: -underline 4 \
			-orient horizontal -widget $path.address

	# create the listbox
	ScrolledListbox $path.listbox -browsecmd "$self browse_listbox; \
			$self ignore_args"

	# create the directory entry box
	DirectoryBox $path.dirbox
	$path.dirbox subwidget entry_label configure -text "Save in:" \
			-underline 2

	# create the various buttons
	frame $path.buttons
	ImageTextButton $path.add -image Icons(plus) -text Add -underline 0 \
			-command "$self add"
	ImageTextButton $path.delete -image Icons(trashcan) -text Delete \
			-underline 0 -state disabled -command "$self delete"
	ImageTextButton $path.record -image VcrIcons(record) -text Record \
			-underline 0 -state disabled \
			-command "$self config -result record"
	ImageTextButton $path.cancel -image Icons(cross) -text Cancel \
			-command "$self cancel"

	# pack all the widgets in
	pack $path.cancel $path.record $path.delete $path.add -side right \
			-padx 3 -fill x -in $path.buttons

	pack $path.dirbox -fill both -expand 1 -side top -in $path.f1
	pack $path.buttons -fill x -side bottom -pady 3 -in $path.f1 -anchor e

	pack $path.session_label  -fill x -side top -in $path.f2
	pack $path.catalog_label  -fill x -side top -in $path.f2
	pack $path.catalog_browse -anchor e -side top -in $path.f2
	pack $path.sep1           -fill x -side top -in $path.f2 -pady 2
	pack $path.protocol_label -fill x -side top -in $path.f2
	pack $path.media_label    -fill x -side top -in $path.f2
	pack $path.address_label  -fill x -side top -in $path.f2
	pack $path.listbox -fill both -expand 1 -side top -in $path.f2

	pack $path.f2 $path.f1 -side left -fill both -expand 1 -padx 5 -pady 5

	# set up a trace on the media_ variable, so we can modify the protocol
	# whenever the media changes

	$self tkvar addr_ session_id_ media_ catalog_filename_
	trace variable media_ w "$self media_changed_"

	set addr_ "224.2.55.66/8001"

	# use the current date/time as the default session-id
	set session_id_ [clock format [clock seconds] -format "%m%d%H%M"]
	set catalog_filename_ "cat.ctg"
	set media_ "mediaboard"

	# set up all key bindings
	bind $path <Key-Escape> "$self subwidget cancel invoke_with_ui"
	$self bindkey_ a "if \{\[$path.add cget -state\]!={disabled}\} \{ \
			focus $path.add; $path.add invoke_with_ui \}"
	$self bindkey_ d "if \{\[$path.delete cget -state\]!={disabled}\} \{ \
			focus $path.delete; $path.delete invoke_with_ui \}"
	$self bindkey_ r "if \{\[$path.record cget -state\]!={disabled}\} \{ \
			focus $path.record; $path.record invoke_with_ui \}"
	$self bindkey_ b "if \{\[$path.catalog_browse cget -state\]!=\
			{disabled}\} \{ focus $path.catalog_browse; \
			$path.catalog_browse invoke_with_ui \}"
	$self bindkey_ s "focus $path.session"
	$self bindkey_ h "focus $path.catalog"
	$self bindkey_ p "focus [$path.protocol subwidget button]"
	$self bindkey_ i "focus [$path.media subwidget entry]"
	$self bindkey_ e "focus $path.address"
	$self bindkey_ v "focus [$self subwidget dirbox subwidget entry]"
}


RecorderUI/Input instproc bindkey_ { key script } {
	set path [$self info path]
	bind $path <Alt-[string tolower $key]> $script
	bind $path <Alt-[string toupper $key]> $script
}



RecorderUI/Input instproc add { } {
	$self tkvar protocol_ media_ addr_
	set addr_ [string trim $addr_]
	if { $addr_!={} } {
		if { ![catch {$self subwidget listbox insert end \
				"-id $protocol_+$media_+$addr_ \
				$protocol_: $media_ ($addr_)"}] } {
			$self subwidget record configure -state normal
		}
	}
}


RecorderUI/Input instproc delete { } {
	set listbox [$self subwidget listbox]
	foreach id [$listbox selection get] {
		$listbox delete -id $id
	}

	$self subwidget delete configure -state disabled
	if { [$listbox info numelems] <= 0 } {
		$self subwidget record configure -state disabled
	}
}


RecorderUI/Input instproc browse_listbox { } {
	if { [llength [$self subwidget listbox selection get]]==0 } {
		$self subwidget delete configure -state disabled
	} else {
		$self subwidget delete configure -state normal
	}
}


RecorderUI/Input instproc browse_catalog_ { } {
	$self instvar filedlg_
	if { ![info exists filedlg_] } {
		$self tkvar catalog_filename_
		set path [$self info path]
		set filedlg_ [FileDialog [winfo toplevel $path].filedlg \
				-type save -title "Catalog file name" \
				-transient $path]
		$filedlg_ subwidget filebox configure \
				-filename [file tail $catalog_filename_] \
				-filetypes "{ {Session catalog files} {.ctg} }\
				{ {All files} {*} }"
	}

	$filedlg_ subwidget filebox configure -directory \
			[$self subwidget dirbox cget -directory]
	set filename [$filedlg_ invoke]
	if { $filename!="" } {
		$self tkvar catalog_filename_
		set catalog_filename_ $filename
	}
}


RecorderUI/Input instproc add_direct { protocol media addr } {
	$self tkvar media_ addr_
	set media_ $media
	set addr_ $addr
	set protocol_ $protocol
	$self add
}


RecorderUI/Input instproc set_session_id { session_id } {
	$self tkvar session_id_
	set session_id_ $session_id
}


RecorderUI/Input instproc set_catalog_filename { filename } {
	$self tkvar catalog_filename_
	set catalog_filename_ $filename
}


RecorderUI/Input instproc set_directory { directory } {
	$self subwidget dirbox configure -directory $directory
}


RecorderUI/Input instproc get_session_id { } {
	$self tkvar session_id_
	return $session_id_
}


RecorderUI/Input instproc get_catalog_filename { } {
	$self tkvar catalog_filename_
	if { $catalog_filename_=="" } {
		return ""
	} else {
		return [file join [$self get_directory] $catalog_filename_]
	}
}


RecorderUI/Input instproc get_directory { } {
	return [$self subwidget dirbox cget -directory]
}


RecorderUI/Input instproc media_changed_ { args } {
	$self tkvar media_ protocol_
	$self instvar protocols_
	set media [string tolower $media_]
	if { [info exists protocols_($media)] } {
		set protocol_ $protocols_($media)
	}
}



WidgetClass RecorderUI/Stream -superclass Observer -configspec {
	{ -minimized minimized Minimized 0 config_minimized }
	{ -name name Name {unknown} config_option }
	{ -filename filename Filename {unknown} config_option }
	{ -bytes bytes Bytes {0} config_option }
} -default {
	{ .borderWidth 1 }
	{ .relief groove }
	{ *Button.padY 0 }
	{ *Button.borderWidth 0 }
	{ *Button.highlightThickness 1 }
	{ *Button.activeBackground WidgetDefault(-background) }
	{ *Label.padY 0 }
	{ *Label.borderWidth 0 }
	{ *font WidgetDefault }
	{ *LabeledWidget.label.font WidgetDefault(-boldfont) }
	{ .name.font WidgetDefault(-boldfont) }
}


RecorderUI/Stream instproc destroy { } {
	$self instvar after_id_
	if [info exists after_id_] {
		after cancel $after_id_
		unset after_id_
	}
	$self next
}


RecorderUI/Stream instproc build_widget { path } {
	frame $path.f1
	frame $path.f2

	button $path.minimize -command "\
			if \{ \[$self cget -minimized\] \} \{ \
			$self configure -minimized 0 \} else \{ \
			$self configure -minimized 1 \}"
	label $path.name -anchor w
	pack $path.minimize -side left -fill y -in $path.f1
	pack $path.name -side left -fill both -expand 1 -in $path.f1

	label $path.filename -anchor w
	LabeledWidget $path.filename_label -label "Filename:" \
			-widget $path.filename
	label $path.bytes -anchor w
	LabeledWidget $path.bytes_label -label "Bytes received:" \
			-widget $path.bytes
	pack $path.filename_label -side top -fill x -in $path.f2 -padx 20
	pack $path.bytes_label -side top -fill x -in $path.f2 -padx 20

	pack $path.f1 -fill x
	pack $path.f2 -fill x -expand 1
}


RecorderUI/Stream instproc disable { } {
	set fg [WidgetClass widget_default -disabledforeground]
	$self subwidget name configure -fg $fg
	$self subwidget filename configure -fg $fg
	$self subwidget bytes configure -fg $fg
	$self subwidget filename_label subwidget label configure -fg $fg
	$self subwidget bytes_label subwidget label configure -fg $fg

	$self instvar stream_
	if { [info exists stream_] } {
		delete $stream_
		unset stream_
	}
}


RecorderUI/Stream instproc config_minimized { option args } {
	set path [$self info path]
	if { [llength $args]==0 } {
		if { [lsearch [pack slaves $path] $path.f2] != -1 } {
			return 0
		} else {
			return 1
		}
	} else {
		set value [lindex $args 0]
		if { $value } {
			catch { pack forget $path.f2 }
			$path.minimize configure -image Icons(maximize)
		} else {
			if { [lsearch [pack slaves $path] $path.f2] == -1 } {
				pack $path.f2 -fill x -expand 1
			}
			$path.minimize configure -image Icons(minimize)
		}
	}
}


RecorderUI/Stream instproc config_option { option args } {
	set subwidget [string range $option 1 end]
	if { [llength $args]==0 } {
		return [$self subwidget $subwidget cget -text]
	} else {
		$self subwidget $subwidget configure -text [lindex $args 0]
	}
}


RecorderUI/Stream instproc attach_stream { stream } {
	$self set stream_ $stream
}


WidgetClass RecorderUI/Session -superclass { Observer ScrolledWindow/Expand }


RecorderUI/Session instproc build_widget { path } {
	$self next $path
	$self set count_ 0
}


RecorderUI/Session instproc disable { } {
	foreach widget [winfo children [$self subwidget window]] {
		$widget disable
	}

	#delete [$self set session_]
}


RecorderUI/Session instproc attach_session { session } {
	$self set session_ $session
}


WidgetClass RecorderUI/Status -superclass Dialog -default {
	{ .title "Recorder" }
	{ .modal 0 }
	{ *session_list.scrollbar both }
	{ *session_list.borderWidth 1  }
	{ *session_list.relief sunken  }
	{ *session_list*Label.borderWidth 1 }
	{ *session_list.bbox.highlightThickness 1 }
	{ *session_list.Scrollbar.borderWidth 1 }
	{ *session_list.Scrollbar.highlightThickness 1 }
	{ *session_list.Scrollbar.width 10 }
	{ *session_list.bbox.width 225 }

	{ *RecorderUI/Session.scrollbar both }
	{ *RecorderUI/Session.borderWidth 1  }
	{ *RecorderUI/Session.relief sunken  }
	{ *RecorderUI/Session.bbox.highlightThickness 1 }
	{ *RecorderUI/Session.Scrollbar.borderWidth 1 }
	{ *RecorderUI/Session.Scrollbar.highlightThickness 1 }
	{ *RecorderUI/Session.Scrollbar.width 10 }

	{ *Entry.borderWidth 1 }
	{ *Entry.width 5 }
	{ *ImageTextButton.borderWidth 1 }
	{ *ImageTextButton.highlightThickness 1 }
}




RecorderUI/Status instproc build_widget { path } {
	frame $path.f1
	frame $path.f2

	entry $path.session_id
	LabeledWidget $path.session_id_label -label "Session ID:" \
			-orient horizontal -widget $path.session_id

	entry $path.directory
	LabeledWidget $path.directory_label -label "Save in:" \
			-orient horizontal -widget $path.directory

	entry $path.catalog
	LabeledWidget $path.catalog_label -label "Catalog file:" \
			-orient horizontal -widget $path.catalog

	ScrolledListbox $path.session_list -browsecmd "$self browse"
	frame $path.session_ui
	frame $path.buttons

    # FIXME - this widget never gets enabled when recording starts - I don't
    #   think this even works if enabled
	ImageTextButton $path.stop -image VcrIcons(stop) \
			-text "Stop this session" -command "$self stop" \
			-state disabled
	ImageTextButton $path.exit -image Icons(cross) -text "Exit" \
			-command "$self stop_all"

	pack $path.exit $path.stop -fill x -anchor e -in $path.buttons \
			-side right

	pack $path.session_id_label -side top -fill x -in $path.f2
	pack $path.directory_label  -side top -fill x -in $path.f2
	pack $path.catalog_label    -side top -fill x -in $path.f2
	pack $path.session_list -fill both -expand 1 -side top -in $path.f2
	pack $path.f2 -fill both -side left -in $path.f1 -padx 5 -pady 5
	pack $path.session_ui -fill both -expand 1 -side right -in $path.f1 \
			-padx 5 -pady 5

	pack $path.buttons -side bottom -fill x -anchor e
	pack $path.f1 -side top -fill both -expand 1
	$self set count_ 0
}


RecorderUI/Status instproc add { session } {
	$self instvar count_ stop_status_
	set widget [RecorderUI/Session \
			[$self subwidget session_ui].session_$count_]
	incr count_
	set stop_status_($widget) 0
	set list [$self subwidget session_list]
	$list insert end "-id $widget $session"
	if { [llength [$list selection get]]==0 } {
		$list selection set -id $widget
		$self browse $widget
	}
	return $widget
}


RecorderUI/Status instproc stop { {widget {}} } {
	$self instvar stop_status_
	set list [$self subwidget session_list]
	if { $widget=={} } {
		set widget [$list selection get]
		if { $widget=={} } return
	}

	set list_widget [$list info widget -id $widget]
	$list_widget configure -normalforeground [WidgetClass \
			widget_default -disabledforeground]
	$list_widget configure -selectforeground [WidgetClass \
			widget_default -disabledforeground]
	$widget disable
	set stop_status_($widget) 1
	$self subwidget stop configure -state disabled
}


RecorderUI/Status instproc stop_all { } {
	foreach widget [$self subwidget session_list info all] {
		$self stop $widget
	}
	$self configure -result "exit"
}


RecorderUI/Status instproc browse { widget } {
	$self instvar stop_status_
	set list [$self subwidget session_list]
	if { [llength [$list selection get]]==0 } {
		$list selection set -id $widget
	}

	catch { pack forget [pack slaves [$self subwidget session_ui]] }
	pack $widget -fill both -expand 1

	if { $stop_status_($widget) } {
		$self subwidget stop configure -state disabled
	} else {
		#$self subwidget stop configure -state normal
	        # FIXME stop always core dumps, so temp disable it
	}
}






# observer methods!


RecorderUI/Session instproc new_stream { stream } {
	$self instvar streams_

	$self instvar count_
	set widget [RecorderUI/Stream [$self subwidget window].stream_$count_]
	incr count_
	pack $widget -side top -fill x -expand 1 -anchor w -padx 1 -pady 1

	set streams_($stream) $widget
	$stream attach_observer $widget
	$widget attach_stream $stream
}


RecorderUI/Session instproc stream_done { stream } {
	$self instvar streams_
	if [info exists streams_($stream)] {
		$streams_($stream) disable
		$stream_detach_observer $streams_($stream)
		unset streams_($stream)
	}
}


RecorderUI/Stream instproc name { name } {
	$self configure -name $name
}


RecorderUI/Stream instproc filename { filename } {
	$self configure -filename $filename
}


RecorderUI/Stream instproc bytes_rcvd { bytes } {
	$self instvar bytes_ after_id_
	set bytes_ $bytes
	if { ![info exists after_id_] } {
		set after_id_ [after 1000 $self bytes_rcvd_helper]
	}
}


RecorderUI/Stream instproc bytes_rcvd_helper { } {
	$self instvar bytes_ after_id_
	$self configure -bytes $bytes_
	unset after_id_
}

