# app-rover.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/rover/app-rover.tcl,v 1.13 2002/02/03 04:22:30 lim Exp $


import SSAC_Client MSP_Application


# This application is exactly the same as msp, but is for interfacing
# with the mars archive servent, run on AS1.  Instead of using RTSP to communicate with the server, as msp does, we use SSAC.

# Status: pre-alpha

Class MSP_Application/Rover -superclass MSP_Application



MSP_Application/Rover public init { w argv } {


	$self instvar ui_ net_ session_ delta_ history_
	$self tkvar   offset_

	set   net_ [new SSAC_Client]
	$net_ init_vars $self

	$self next $w $argv


}

# Catalog file passed from netscape is parsed here.
# For now, ignore bookmarks, add them in later
MSP_Application/Rover private parse_msp { msp } {
	set o [split $msp]

	set filename [lindex [split [lindex $o 1]] 1]
	#puts "Filename $filename"
	$self add_default defaultAddr $filename
	$self add_default defaultDesc $msp
	$self add_default autoStart "true"
}

# Catalog file which resides locally is parsed here
# For now, ignore bookmarks, add them in later
MSP_Application/Rover private parse_file { sFile } {
	#$self instvar name_ spurts_ acolor_ uname_ bookmarks_
	#$self instvar ui_

	if {$sFile == ""} {
		return 0
	}
	set fd [open $sFile "r"]
	if { $fd <  0 } {
		puts "$name_: error opening $sFile"
		exit 1
	}

	set inpd 0
	while { [gets $fd line] > 0 } {
		append pd "$line\n"
		#lappend pd $line
	}
	close $fd

	#set filename [lindex [split [lindex $pd 1]] 1]
	set filename [lindex $pd 2]
	$self add_default defaultAddr $filename
	$self add_default defaultDesc $pd
	$self add_default autoStart "true"
	#$self parse_pd $pd


	return 1
}


MSP_Application private read_bookmarks { } {
	$self instvar ui_ bookmarks_
	$self tkvar url_

	if [file exists ~/.msp/bookmarks.bm] {
		set fd [open ~/.msp/bookmarks.bm]
		while { [gets $fd line] > 0 } {
			set f [split $line "^"]

			set addr   [lindex $f 0]
			set offset [lindex $f 1]
			set name   [lindex $f 2]
			set color  [string trim [lindex $f 3]]
			if {$color == ""} {
				set color "black"
			}
			if {$url_ == $addr} {


				set b  [new Bookmark $name $addr $offset $color]
				set bookmarks_($addr:$offset) $b
				set idx "$addr:$offset"

				set ef [$self get_option entryFont]
				$ui_(main).menubar.bookmarks.list add command -font $ef \
						-label "$name ($addr:$offset)" \
						-command "[list $self jump-to $idx]"

			}
		}
		close $fd
	}
}


MSP_Application/Rover instproc build_menubar { path } {

	$self instvar net_ history_

	frame $path.menubar  -relief sunken
	pack $path.menubar -fill x

	menubutton      $path.menubar.file -text "File" -m $path.menubar.file.x -width 5
	pack            $path.menubar.file -side left
	menu            $path.menubar.file.x -tearoff no


	$path.menubar.file.x add command -label "Exit"        -command "$self exit"


	menubutton      $path.menubar.bookmarks -text "Bookmarks" -m $path.menubar.bookmarks.list -width 10
	pack            $path.menubar.bookmarks -side left



	menubutton      $path.menubar.help -text "Help" -m $path.menubar.help.help -width 5
	pack            $path.menubar.help -side left


	menu            $path.menubar.bookmarks.list -tearoff no
	$path.menubar.bookmarks.list add command -label "Add Bookmark" -command "$self edit_bookmark .bookmark"
	$path.menubar.bookmarks.list add separator
	menu            $path.menubar.help.help -tearoff no
	$path.menubar.help.help add command -label "Help"    -command " "
}

MSP_Application/Rover instproc init_resources o {

	$o add_default iconPrefix "MARS Rover "
	$self next $o
}

MSP_Application/Rover instproc init_UI { path } {

	$self instvar ui_ id_
	wm title . "MARS Rover"

	set id_ 0
	set ui_(main) $path
	frame $path  -relief sunken
	pack  $path -fill x

	$self build_menubar     $path
	$self build_ctrlpanel   $path
	$self build_slider      $path
	$self build_title       $path
}

#
MSP_Application/Rover instproc open { {off 0} } {
	$self instvar net_ history_ ui_
	$self tkvar url_
	$self instvar desc_
	$self clean-up
	# Update the history list
	set ef [$self get_option entryFont]
	set h $url_

	if {![info exists desc_]} {
		set desc_ ""
	}
	set err [$net_ open $url_ $desc_]
	if { $err != "" } {
		Dialog transient MessageBox -type ok -text $err \
			-image Icons(warning)
	}
	return
}

import MPlug/ScrolledUI

Class MSP_Application/Rover/MPlug -superclass MSP_Application/Rover

MSP_Application/Rover/MPlug public init { argv } {
	$self instvar mplug_

	$self start_mplug

	# Start up mui embedded in the browser.
	set root [$mplug_ root]
	$self next $root.[pid] $argv
}

#
# Starts MPlug using a scrollable window.
#
MSP_Application/Rover/MPlug public start_mplug {} {
	$self instvar mplug_

	if { ![info exists mplug_] } {
		set mplug_ [new MPlug/ScrolledUI]
	}
}


MSP_Application/MPlug private do_error { msg } {
	$self instvar mplug_
	label .label -text $msg -justify left -anchor w
	pack .label  -fill both -expand 1 -padx 10 -pady 10
	vwait forever
}


Class MSP_Application/Rover/MPlug/MSPMime \
		-superclass MSP_Application/Rover/MPlug

MSP_Application/Rover/MPlug/MSPMime public init {argv} {
	$self instvar mplug_
	$self start_mplug

	# on success, the following function returns NPRES_DONE which is
	# defined to 0 in a .h file
	# FIXME: how do I pull in constants defined in .h files into tcl?
	if { [$mplug_ wait_for_stream] } {
		puts stderr "Could not retrieve stream"
		exit
	}

	if { [$mplug_ get mimetype] != "x-mash/x-msp" } {
		$self do_error "msp cannot handle mimetype:\
			[$mplug_ get mimetype]"
	}

	lappend argv -msp [$mplug_ get stream]
	$self next $argv
	vwait forever
}

