# rtp-play-agent.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


import mashutils RTPAgent RTPApplication/Player AddressBlock NetworkManager

Module/RTPPlay instproc init {} {
	$self next
}


# This class is usec in playing RTP packets from the archive onto the
# network.  It inherits from RTPAgent so that we can leverage the RTP
# play capabilities as much as possible without any re-implementation.
# Status: Beta
# Author: Angela Schuett

Class RTPPlayAgent -superclass RTPAgent

RTPPlayAgent instproc init { session addr } {
	#FIXME
	$self set options_ [new Configuration]
	$self add_default defaultTTL 1

	set ab [new AddressBlock $addr]
	$self next $ab
	$self instvar archive_session_
	$self instvar bufferPool_

	set archive_session_ $session
	set media [$session media]
	set Media_ [string toupper [string index $media 0]][string range \
                        $media 1 end]
	#FIXME we create an Application object here !?!?
#	set app [new RTPApplication/Player $media]

	#FIXME ?
	set bufferPool_ [new BufferPool/RTP]
}

RTPPlayAgent instproc destroy {} {
	$self instvar bufferPool_
	delete $bufferPool_

	$self next
}

RTPPlayAgent instproc buffer_pool {} {
	$self instvar bufferPool_
	return $bufferPool_
}

RTPPlayAgent instproc get_session {} {
	$self instvar session_
	return $session_
}

# This code is taken mostly verbatim from RTPAgent, but with
# mk_local_source call removed, since we don't have the ssrc, cname, etc
# info here

RTPPlayAgent public reset ab {
	$self instvar network_ session_ sources_

	if [info exists network_] {
		delete $network_
	}
	set network_ [new NetworkManager $ab $session_ $self]
	#FIXME
	$self app_loopback 0

	$self net_loopback 1

	set key [$self get_option sessionKey]
	if { $key != "" } {
		$network_ install-key $key
	}
	# create the local rtp-source object
	#FIXME this is a hack
	#$self instvar local_
	#if ![info exists local_] {
	#	$self mk_local_source
	#}
	#FIXME currently session object understands only one bandwidth limit
	# FIXME get this into b/s eventually.
	$session_ max-bandwidth [expr [$ab set maxbw_(0)]/1000.]

	# FIXME Eventually use 'attach' mechanism.
	catch {[Application instance] reset $ab}
}

#
# Same as RTPAgent mk_local_source, but using recorded ssrc, cname, etc
# FIXME this method should share more code with RTPAgent
#
RTPPlayAgent instproc mk_local_source {ssrc ccname rtpName rtpEmail} {
	$self instvar network_ session_ local_

	set net [$network_ data-net 0]

	# choose the initial RTP srcid

	set srcid $ssrc

	# create the local source object
	set src [$self create-local $srcid [$net interface]]
	set local_ $src
	$self notify_observers register $local_

	set cname $ccname
	if { $cname == "" } {
		set interface [$net interface]
		if { $interface == "0.0.0.0" } {
			# this happens under solaris
			set interface [$session_ local-addr-heuristic]
		}
		set cname [user_heuristic]@$interface
	}
	$src sdes name $rtpName
	$src sdes email $rtpEmail
	$src sdes cname $cname

	set tool [$self get_option appname]\-[version]

	global tcl_platform
	if {[info exists tcl_platform(os)] && $tcl_platform(os) != "" && \
			$tcl_platform(os) != "unix"} {
		set p $tcl_platform(os)
		if {$tcl_platform(osVersion) != ""} {
			set p $p-$tcl_platform(osVersion)
		}
		if {$tcl_platform(machine) != ""} {
			set p $p-$tcl_platform(machine)
		}
		set tool "$tool/$p"
	}
	$src sdes tool $tool

	return $src
}

# create-session called from RTPAgent
RTPPlayAgent instproc create_session {} {
	$self instvar Media_
	$self instvar session_

	set session_ [new Session/RTP/Play]
	if { $session_ == "" } {
		$self fatal "creation of Session/RTP/Play failed!"
	}
	$self app_loopback 0

	$self set-bandwidth 1024
	return $session_
}


RTPPlayAgent instproc activate src {
	$self instvar decoders_
	set h [new Module/RTPPlay]
	lappend decoders_ $h
	$src data-handler $h
	$self next $src

}

RTPPlayAgent instproc deactivate src {
	$self instvar decoders_
	set d [$src handler]
	set k [lsearch -exact $decoders_ $d]
	set decoders_ [lreplace $decoders_ $k $k]
	$self next $src
	delete $d
}
