# anm-obj.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1993-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# $Header: /usr/mash/src/repository/mash/mash-1/tcl/atobj/anm-obj.tcl,v 1.6 2002/02/03 04:25:26 lim Exp $


Class AnmObj

AnmObj instproc init {eId {sT 0} {eT inf}} {
        $self instvar eId_ eT_ sT_
        set eId_ $eId
        set sT_ $sT
        set eT_ $eT
        if {$eT_ == "inf"} {
                $self set isStatic_ 1
        } else {
                $self set isStatic_ 0
        }
}

AnmObj instproc destroy {} { $self next }

AnmObj instproc isStatic {} {
        return [$self set isStatic_]
}

AnmObj instproc draw {t} {
}

AnmObj instproc update {time} {
        if [$self isStatic] return
        if { $time < [$self set sT_] || $time > [$self set eT_] } {
                $self remove
        }
}

AnmObj instproc inRange {t} {
        $self instvar sT_ eT_
        return [expr $t >= $sT_ && $t <= $eT_]
}

# bbox is in the form [left top right bottom]
AnmObj instproc set_bbox {bbox} { $self set bbox_ $bbox }

AnmObj instproc eId {} {
        return [$self set eId_]
}

# updates bboxVar of the caller to contain bboxVar and this AnmObj
AnmObj instproc merge {bboxVar} {
        $self instvar bbox_
        if ![info exists bbox_] return

        upvar $bboxVar newBBox
        foreach {bxmin bymin bxmax bymax} $bbox_ \
                        {xmin ymin xmax ymax} $newBBox {
                set newBBox [list \
                                [expr ($bxmin < $xmin) ? $bxmin : $xmin] \
                                [expr ($bymin < $ymin) ? $bymin : $ymin] \
                                [expr ($bxmax > $xmax) ? $bxmax : $xmax] \
                                [expr ($bymax > $ymax) ? $bymax : $ymax]]
        }
}

AnmObj instproc set_drawboard {drawboard wgt} {
        $self instvar drawboard_ parent_
        set drawboard_ $wgt
        set parent_ $drawboard
}

# NOTE: there should be no instvar declarations in this procedure,
#       as a bug in otcl/tcl causes duplicate free's
AnmObj instproc remove {} {
        # parent will delete this object after remove
        [$self set parent_] remove [$self set eId_]
}
