# session-dc.tcl --
#
#       Stuff for talking to the SDS using SRM.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import SRMv2_Session
import SRMv2_Source
import Timer/Periodic


#
# Code for CDcSession
#

Class CDcSession -superclass {SRMv2_Session Timer/Periodic}
#
# CDcSession constructor
#
# input: inetAddr - a string with the internet address
#        iSPort - sending port
#        iRPort - receiving port
#

CDcSession instproc init {inetAddr iSPort iRPort iTTL} {
    $self next $inetAddr $iSPort $iRPort $iTTL

    # initialize some member variables
    $self instvar m_cmdUpdate
    $self instvar m_data

    set m_cmdUpdate {}
    set m_data {}

    # create the one and only source object
    $self instvar m_DcSource
    $self instvar m_cidQuery

    set m_DcSource [new SRMv2_Source $self ]

    # set the source info
    $m_DcSource app_info { "DC Service Source" }

    # create some default containers
    set m_cidQuery [$m_DcSource calloc 0 "Query"]
}

#
# CDcSession instproc UpdateInfo { cmdUpdate }
# the command that should be evaluated when the session gets new information
# from the service discovery service.
#
# input: cmdUpdate - the command to perform
#
CDcSession instproc UpdateInfo { cmdUpdate } {
    $self instvar m_cmdUpdate

    set m_cmdUpdate $cmdUpdate
}

CDcSession instproc StartQuery {} {
    # Ok now let's set the timer to go off periodically
    # when the timer goes off it will call timeout
    $self start 500

    # I don't want to wait 1 sec so call to get it now
    $self instvar m_DcSource
    $self instvar m_cidQuery

    set data "QUERY_REQUEST:"
    $m_DcSource send $m_cidQuery $data
}

#
# CDcSession instproc srm_recv { src cid seqno data }
#
# Get all the information from the query and then stick
# it into a structure to be delivered to an ui which will
# represent it in some way
#
# input: same as the srm_rec of SRMv2_Session object
#
CDcSession instproc srm_recv { src cid seqno data } {
    if {[lindex $data 0] == "QUERY_RESPONSE:"} {
	$self instvar m_data

	# take out the QUERY_REPONSE: header
	set data [lrange $data 1 end]

	# update the data file and send an update if applicable
	if { $m_data != $data } {
	    $self instvar m_cmdUpdate

	    set m_data $data
	    eval "$m_cmdUpdate"
	}
    }
}

#
# CDcSession public srm_read_adu { src cid seqno } {
#
# don't repair any loses
#
# input: same as the srm_rec of SRMv2_Session object
#
CDcSession instproc srm_read_adu { src cid seqno } {
    # no recovery mechanism
}

#
# CDcSession public srm_should_recover { src cid sseq eseq } {
#
# don't repair any losses
#
# input: same as the srm_rec of SRMv2_Session object
#
CDcSession instproc srm_should_recover { src cid sseq eseq } {
    return 0
}

#
# CDcSession instproc timeout {} {
#
# time out periodically sends to the sds that it's alive and active
#
# input: same as the srm_rec of SRMv2_Session object
#
CDcSession instproc timeout {} {
    $self instvar m_DcSource
    $self instvar m_cidQuery

    set data "QUERY_REQUEST:"
    $m_DcSource send $m_cidQuery $data
}
