# client.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


import HandoffClientUI System Application AnnounceListenManager


Class HandoffClient -superclass Application

Class BeaconAgent -superclass AnnounceListenManager


BeaconAgent instproc init { } {
	$self next [$self get_option beaconaddr] [$self get_option mtusize]

	$self set host_name_ [localaddr]
	$self set announcer_ [new AnnounceListenManager \
			[$self get_option gatewayaddr] \
			[$self get_option mtusize]]
}


BeaconAgent instproc get_lastheard { addr } {
	$self instvar last_heard_
	if [info exists last_heard_($addr)] {
		return $last_heard_($addr)
	} else {
		# return a very large number
		return 10000
	}
}


BeaconAgent instproc recv_announcement { basestation args } {
	$self instvar last_heard_
	$self set last_heard_($basestation) [clock seconds]
}


BeaconAgent instproc send_announcement { eth_addr wl_addr } {
	$self instvar announcer_ host_name_ observer_

	set def_route [[System instance] get_default_route]

	if {$def_route == ""} {
		$observer_ log "No default route"
	} else {
		$observer_ log "Deleting default route"
		catch {[System instance] delete_default_route}
	}
	after 30
	$observer_ log "Adding new route for $eth_addr/$wl_addr"
	catch {[System instance] add_default_route $wl_addr}

	after 100
	$announcer_ announce "SetRoute $host_name_ $eth_addr"
}


BeaconAgent instproc attach { observer } {
	$self set observer_ $observer
}


HandoffClient instproc init { argv } {
	set name [string tolower [tk appname]]
	set cls "[string toupper [string index $name 0]][string \
			range $name 1 end]"
	$self next $name

	set o [$self options]
	$self init_args $o
	$self init_resources $o
	set argv [$o parse_args $argv]
	if { $argv != {} } {
		$self add_option basestations $argv
	}

	$self instvar beaconAgent_ observer_
	set beaconAgent_ [new BeaconAgent]
	set observer_ [$self create_observer]
	$beaconAgent_ attach $observer_
	$observer_ attach $beaconAgent_

	System create_instance $observer_
	$observer_ set_default [[System instance] get_default_route]
}


HandoffClient instproc create_observer { } {
	return [new HandoffClientUI .]
}


HandoffClient instproc init_args o {
	$o register_option -beaconaddr beaconaddr
	$o register_option -gatewayaddr  gatewayaddr
	$o register_option -basestations basestations
	$o register_option -add          morebs
}

HandoffClient instproc init_resources o {
	set basestations {
		{ brig {306 Soda} }
		{ ajanta {405 Soda} }
		{ giza {420A Soda} }
		{ yacht {443 Soda} }
		{ cruiser {443 Soda} }
		{ carthage {514 Soda} }
		{ dreadnaught {637 Soda} }
		{ ketch {698 Soda} }
	}

	$o add_default beaconaddr   255.255.255.255/1201
	$o add_default gatewayaddr  128.32.41.3/3443
	$o add_default basestations $basestations
	$o add_default morebs       {}

	$o add_default mtusize      4096
	$o add_default maxlogsize   100
}


#HandoffClient instproc add_option { resource value {level {}} } {
#	# FIXME: class_ is an instance variable of superclass Application
#	# I shouldn't be reading it directly here
#	$self instvar class_
#	if { $level=={} } {
#		option add $class_.$resource $value
#	} else {
#		option add $class_.$resource $value $level
#	}
#}
