# archive-mat.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import ArchiveSystem ArchiveSystem/Record ArchiveSystem/Play

Class Rec

Rec public init module {
	$self next
	$self set module_ $module
}

Rec instproc start {} {
	global aspec vspec
	$self instvar as_ module_
	set as_ [new ArchiveSystem/Record]
    	set archive [$self get_option archive]
	$as_ open $archive $module_
	set vspec [$self get_option videoSpec]
	set aspec [$self get_option audioSpec]
	set mbspec [$self get_option mbSpec]
	$as_ record_rtp_session $vspec video video
	$as_ record_rtp_session $aspec audio audio
	$as_ record_mb_session $mbspec mb
}

Rec instproc stop {} {
	$self instvar as_
	delete $as_
	unset as_
}

Rec instproc goto { t } {
	$self instvar as_
    	$as_ goto $t
}

set dir .
set audioOff 0
set videoOff 0
set mbOff 0
set namOff 0
set loopback 0

Class Playback

Playback public init module {
	$self next
    	$self set module_ $module
}

Playback public start { ui } {
    	$self instvar as_ module_ ui_
	set as_ [new ArchiveSystem/Play]
    	set archive [$self get_option archive]
	$as_ open $archive $module_
	set vspec [$self get_option videoSpec]
	set aspec [$self get_option audioSpec]
	set mbspec [$self get_option mbSpec]
    	$as_ play_session $vspec video
	$as_ play_session $aspec audio
	$as_ play_session $mbspec mediaboard
	$as_ start
    	set ui_ $ui
	$self instvar urls_
	set urls_ ""
    	set file $archive/$module_/[$self get_option slideOutputFile]
    	if [file isfile $file] {
		set fd [open $file r]
	    	if { $fd < 0 } {
		    return
		}
		while 1 {
			if [eof $fd] {
				break
			}
			gets $fd line
			if { [llength $line] > 0 } {
				lappend urls_ $line
			}
		}
		close $fd
	}
	$self set curl_ 0
	$self sched_next
}

Playback public stop {} {
    	$self instvar as_
    	delete $as_
    	unset as_
}


Playback instproc sched_next {} {
	$self instvar urls_ curl_
	if { $curl_ < [llength $urls_] } {
		set r [lindex $urls_ $curl_]
	    	$self instvar as_
		$as_ at [lindex $r 0] "$self dispatch [lindex $r 1]"
	}
}

Playback instproc dispatch url {
	$self instvar curl_ ui_
	$ui_ show $url
	incr curl_
	$self sched_next
}

Playback instproc goto { t } {
	$self instvar as_
    	$as_ goto $t
}

