# ui-mgamon.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/mgamon/ui-mgamon.tcl,v 1.37 2002/02/03 04:27:48 lim Exp $

import TopLevelWindow MeGa AnnounceListenManager/AS/MeGaMon mashutils

#
# The user interface for the "Media Gateway Architecture Monitor".
#
Class MGAMonUI -superclass TopLevelWindow

set uniqid 0

#
MGAMonUI instproc init { path } {
	$self next $path

	$self instvar agenttext_

	$self build $path

	set megaspec [$self get_option asCtrl]
	set bw [$self get_option asCtrlBW]
	$self instvar al_
	foreach m { audio video sdp mb hm mars} {
		set spec [MeGa ctrlchan $m $megaspec]
		set al_($m) [new AnnounceListenManager/AS/MeGaMon \
				$self $spec $bw]
	}
	set o [$self get_option doLog]
	if { $o != "" } {
		$self instvar log_
		foreach a [split $o :] {
			set log_($a) 1
		}
	}
}

#
MGAMonUI instproc build { w } {
	$self instvar agenttext_ frames_ agentlist_

	set f [$self get_option smallfont]
	set mf [$self get_option medfont]

	frame $w.top
	set rt $w.top.rt
	frame $rt -relief groove -borderwidth 1
	frame $rt.gw
	label $rt.gw.l -text "Gateways" -font $mf
	pack $rt.gw.l -side top -fill x
	frame $rt.gw.d

	frame $rt.clients
	label $rt.clients.l -text "Clients" -font $mf
	pack $rt.clients.l -side top -fill x
	frame $rt.clients.d

	foreach t { {srv video VGW} {srv audio AGW} {srv sdp SDGW} \
			{srv mb MBGW} {srv mars MARS}} {
	    	set atype [lindex $t 0]
    	    	set media [lindex $t 1]
    	    	set name [lindex $t 2]
		set w0 $rt.gw.d.f$name
		frame $w0 -relief groove -borderwidth 2
		set agentlist_($atype,$media) [new AgentList $w0 $name]
		pack $w0 -side left -expand 1 -fill both
		frame $w0.info
		button $w0.info.b -text "death" -font $f \
				-command "$self build_death $media"
		frame $w0.info.glue
		label $w0.info.l -text "0 agent(s)" -font $f
		$agentlist_($atype,$media) set numlabel_ $w0.info.l
		pack $w0.info.b -side left
		pack $w0.info.glue -side left -fill x -expand 1
		pack $w0.info.l -side left
		pack $w0.info -side top -ipady 0 -expand 1 -fill x
	}
	pack $rt.gw.d -side top -expand 1 -fill both
	foreach t { {client,video Video} {client,audio Audio} \
			{client,sdp SDP} {client,mb MB} {client,mars ROVER}} {
	    	set atype [lindex $t 0]
    	    	set name [lindex $t 1]
		set w0 $rt.clients.d.f$name
		frame $w0 -relief groove -borderwidth 2
		set agentlist_($atype) [new AgentList $w0 $name]
		pack $w0 -side left -expand 1 -fill both
		frame $w0.info
		frame $w0.info.glue
		label $w0.info.l -text "0 agent(s)" -font $f
		$agentlist_($atype) set numlabel_ $w0.info.l
		pack $w0.info.glue -side left -fill x -expand 1
		pack $w0.info.l -side left
		pack $w0.info -side top -ipady 0 -expand 1 -fill x
	}
	pack $rt.clients.d -side top -expand 1 -fill both
	pack $rt.gw $rt.clients -side top -expand 1 -fill both

	# Build hm window
	set left [frame $w.top.left -relief groove -borderwidth 1]
	frame $left.hm
	label $left.hm.l -text "Host Managers" -font $mf
	pack $left.hm.l -side top -fill x -anchor n
	set w0 $left.hm.d
	frame $w0 -relief groove -borderwidth 2
	set agentlist_(hm) [new AgentList $w0 HM]
	pack $w0 -side left -expand 1 -fill both
	frame $w0.info
	button $w0.info.b -text "death" -font $f \
			-command "$self build_death hm"
	frame $w0.info.glue
	label $w0.info.l -text "0 agent(s)" -font $f
	$agentlist_(hm) set numlabel_ $w0.info.l
	pack $w0.info.b -side left
	pack $w0.info.glue -side left -fill x -expand 1
	pack $w0.info.l -side left
	pack $w0.info -side top -ipady 0 -fill x
	pack $left.hm -side top -expand 1 -fill both
	pack $rt $left -side right -expand 1 -fill both

	set f [$self get_option smallfont]
	frame $w.bot -relief ridge -borderwidth 2
	label $w.bot.a -text "Control Address: [$self get_option asCtrl]" \
			-font $f
	label $w.bot.l -text "Media Gateway Architecture Monitor v[version] (ASCP v2.0)" \
			-font $f
	button $w.bot.quit -text "Quit" -command "exit 0" -font $f \
			-borderwidth 2

	pack $w.bot.a -side left
	pack $w.bot.l -side left -expand 1 -fill x
	pack $w.bot.quit -side right
	pack $w.top $w.bot -side top -fill both -expand 1
}

#
MGAMonUI instproc build_death { atype } {

	$self instvar al_
	set al $al_($atype)

	set o "ASCP v[AnnounceListenManager/AS version]"
	set n mgamon
	set o $o\n$n
	set n [$al agent_instance]
	set o $o\n$n
	set n "DEATH"
	set o $o\n$n
	set n $atype
	set o $o\n$n
	set n "-"
	set o $o\n$n
	set n "-"
	set o $o\n$n

	$al announce $o
}

#
MGAMonUI instproc register { atype aspec addr msg } {
	$self instvar agentlist_

	set logtype $atype
	if { $atype == "srv" || $atype == "client" } {
		if { $msg == "Mars"} {
			set media $msg
			if { $media == "" } {
				return
			}
			set mtype "mars"
			set atype $atype,$mtype
		} else {
			set media [lindex [$msg set allmedia_] 0]
			if { $media == "" } {
				return
			}
			set mtype [$media set mediatype_]
			set atype $atype,$mtype
		}
	} else {
		set mtype "-"
	}
	set l $agentlist_($atype)
	$l insert_item $atype $aspec $addr $msg
	update idletasks
	$self instvar log_
	if [info exists log_($logtype)] {
		puts "[gettimeofday] + $aspec $logtype $mtype $addr"
	}
}

#
MGAMonUI instproc unregister { atype aspec addr msg } {
	$self instvar agentlist_

	set logtype $atype
	if { $atype == "srv" || $atype == "client"} {
		if { $msg == "Mars"} {
			set media $msg
			if { $media == "" } {
				return
			}
			set mtype "mars"
			set atype $atype,$mtype
		} else {
			set media [lindex [$msg set allmedia_] 0]
			if { $media == "" } {
				return
			}
			set mtype [$media set mediatype_]
			set atype $atype,$mtype
		}
	} else {
		set mtype "-"
	}
	set l $agentlist_($atype)
	$l remove_item $aspec
	update idletasks
	$self instvar log_
	if [info exists log_($logtype)] {
		puts "[gettimeofday] - $aspec $logtype $mtype $addr"
	}
}

#
MGAMonUI instproc recv_msg { atype aspec addr msg delta } {
	$self instvar agentlist_

	if { $atype == "srv" || $atype == "client" } {
		if { $msg == "Mars"} {
			set media $msg
			if { $media == "" } {
				return
			}
			set mtype "mars"
			set atype $atype,$mtype
		} else {
			set media [lindex [$msg set allmedia_] 0]
			if { $media == "" } {
				return
			}
			set mtype [$media set mediatype_]
			set atype $atype,$mtype
		}
	}

	set l $agentlist_($atype)
	$l update_data $aspec $addr $msg $delta
	update idletasks
}

#
Class AgentList

#
AgentList instproc init { w agentname } {
	$self next
	$self instvar bottom_ list_ agentname_

	set agentname_ $agentname
	set bottom_ 2

	set f [$self get_option smallfont]

	$self instvar bottom_

	label $w.title -text "$agentname" -font $f
	frame $w.bot -relief sunken -borderwidth 1
	scrollbar $w.bot.scroll -relief groove -borderwidth 2 \
			-command "$w.bot.list yview" -width 10
	canvas $w.bot.list -relief groove -borderwidth 0 \
		-height 160 -width 160 -yscrollcommand "$w.bot.scroll set"
	pack $w.bot.scroll -side left -fill y
	pack $w.bot.list -side left -expand 1 -fill both

	pack $w.title -side top -fill x
	pack $w.bot -side top -fill both -expand 1

	set list_ $w.bot.list
}

#
AgentList instproc insert_item { atype aspec addr msg } {
	$self instvar bottom_ list_ items_ agentname_ entrywin_ numlabel_
	global uniqid
	incr uniqid
	set w .al$uniqid
	set entrywin_($aspec) \
		[new AgentEntryWindow/$agentname_ $w $atype $aspec]
	set f [$self get_option smallfont]

	set id [$list_ create text 5 $bottom_ -font $f -text \
			"$aspec" -anchor nw]
	set bottom_ [lindex [$list_ bbox $id] 3]
	$list_ bind $id <Enter> "$list_ itemconfigure $id -fill red"
	$list_ bind $id <Leave> "$list_ itemconfigure $id -fill black"
	$list_ bind $id <ButtonPress> "$entrywin_($aspec) toggle"
	$list_ bind $id <ButtonRelease-3> "$entrywin_($aspec) toggle"
	set items_($aspec) $id
	incr bottom_ 2
	$list_ config -scrollregion "0 0 2.5i $bottom_"
	$numlabel_ configure -text "[llength [array names items_]] agent(s)"
}

#
AgentList instproc update_data { aspec addr msg delta } {
	$self instvar entrywin_
	if [info exists entrywin_($aspec)] {
		$entrywin_($aspec) update_data $addr $msg $delta
	}
}

#
AgentList instproc remove_item { aspec } {
	$self instvar items_ list_ bottom_ entrywin_ numlabel_
	set id $items_($aspec)
	set thresh [lindex [$list_ coords $id] 1]
	set bb [$list_ bbox $id]
	set height [expr [lindex $bb 3] - [lindex $bb 1]]
	incr height 2
	$list_ delete $id

	$self adjust_entries $thresh $height

	delete $entrywin_($aspec)
	unset entrywin_($aspec)
	unset items_($aspec)
	$numlabel_ configure -text "[llength [array names items_]] agent(s)"
}

#
AgentList instproc adjust_entries { thresh h } {
	$self instvar items_ list_ bottom_
	foreach s [array names items_] {
		set y [lindex [$list_ coords $items_($s)] 1]
		if { $y > $thresh } {
			$list_ move $items_($s) 0 -$h
		}
	}
	incr bottom_ -$h
	$list_ config -scrollregion "0 0 2.5i $bottom_"
}

#
Class AgentEntryWindow -superclass TopLevelWindow

#
AgentEntryWindow instproc init { w atype aspec } {
	$self next $w

	set f [$self get_option smallfont]
	$self create-window $w "$atype $aspec"
	label $w.title -text "$atype $aspec" -font $f

	frame $w.data -relief sunken -borderwidth 1
	$self build_data $w.data

	button $w.dismiss -text Dismiss -command "$self toggle" -font $f
	pack $w.title -expand 1 -fill x -ipadx 4 -ipady 2 -side top
	pack $w.data -expand 1 -fill x -side top -ipady 2
	pack $w.dismiss -side top
}

# A Gateway window for the "Media Gateway Architecture Monitor" user interface.
Class AgentEntryWindow/GW -superclass AgentEntryWindow

# A Session Directory Gateway window for the "Media Gateway Architecture Monitor" user interface.
Class AgentEntryWindow/SDGW -superclass AgentEntryWindow/GW

# A MediaBoard Gateway window for the "Media Gateway Architecture Monitor" user interface.
Class AgentEntryWindow/MBGW -superclass AgentEntryWindow/GW

# A Video Gateway window for the "Media Gateway Architecture Monitor" user interface.
Class AgentEntryWindow/VGW -superclass AgentEntryWindow/GW

# An Audio Gateway window for the "Media Gateway Architecture Monitor" user interface.
Class AgentEntryWindow/AGW -superclass AgentEntryWindow/GW

# A Client window for the "Media Gateway Architecture Monitor" user interface.
Class AgentEntryWindow/Client -superclass AgentEntryWindow/GW

# A Video Client window for the "Media Gateway Architecture Monitor" user interface.
Class AgentEntryWindow/Video -superclass AgentEntryWindow/Client

# An Audio Client window for the "Media Gateway Architecture Monitor" user interface.
Class AgentEntryWindow/Audio -superclass AgentEntryWindow/Client

# A Session Directory Client window for the "Media Gateway Architecture Monitor" user interface.
Class AgentEntryWindow/SDP -superclass AgentEntryWindow/Client

# A Mediaboard Client window for the "Media Gateway Architecture Monitor" user interface.
Class AgentEntryWindow/MB -superclass AgentEntryWindow/Client

# A Host Manager Client window for the "Media Gateway Architecture Monitor" user interface.
Class AgentEntryWindow/HM -superclass AgentEntryWindow

Class AgentEntryWindow/ROVER -superclass AgentEntryWindow/Client
Class AgentEntryWindow/MARS -superclass AgentEntryWindow/GW



#foreach a { SDGW MBGW VGW AGW Client HM } {
#	AgentEntryWindow/$a instproc init { w atype aspec } "
#		\$self next \$w \$atype \$aspec
#	"
#}

#
AgentEntryWindow instproc mkfield { w text id } {
	set f [$self get_option smallfont]
	frame $w.$id
	label $w.$id.l -text "$text=" -font $f
	label $w.$id.v -text "" -font $f
	pack $w.$id.l $w.$id.v -side left -anchor w
	pack $w.$id -side top -anchor w

	return $w.$id.v
}

#
AgentEntryWindow/GW instproc build_data { w } {
	$self instvar fields_ awin_ tstime_ tsfrom_
	set f [$self get_option smallfont]

	frame $w.d
	set fields_(o) [$self mkfield $w.d "Agent ID" o]
	set fields_(s) [$self mkfield $w.d "Session ID" s]
	set fields_(toolname) [$self mkfield $w.d Tool toolname]

	set s [frame $w.sessions -relief ridge -borderwidth 1]
	label $s.top -text "Sessions"
	frame $s.bot -relief sunken -borderwidth 1
	pack $s.top $s.bot -side top
	$self set sesswin_ $s.bot

	frame $w.ts
	$self mkts $w.ts
	pack $w.d $w.sessions $w.ts -side top -fill x -side top
}

#
AgentEntryWindow instproc mkts { w } {
	$self instvar fields_
	set fields_(tstime) [$self mkfield $w "Last heard" tstime]
	set fields_(tsfrom) [$self mkfield $w "Heard from" tsfrom]
	set fields_(delta) [$self mkfield $w "Delta" delta]
}

#
AgentEntryWindow/GW instproc update_data { addr msg delta } {
	$self instvar fields_ sesswin_ sessions_
	set i 0
	$fields_(o) configure -text [join [$msg field_value o] :]
	$fields_(s) configure -text [join [$msg field_value s] :]
	$fields_(toolname) configure -text [$msg attr_value tool]
	$fields_(tstime) configure -text [gettimeofday ascii]
	$fields_(tsfrom) configure -text $addr
	$fields_(delta) configure -text $delta

	# Sessions
	set i 0
	foreach media [$msg set allmedia_] {
		if ![info exists sessions_($i)] {
			set w \
			   [frame $sesswin_.x$i -relief groove -borderwidth 1]
			set fields_($i,addr) [$self mkfield $w Addr x$i,addr]
			set sessions_($i) $w
			pack $w -side top -fill x -expand 1
		}
		set tmp [split [$media set caddr_] /]
		set caddr [lindex $tmp 0]/[$media set port_]/[lindex $tmp 1]
		$fields_($i,addr) configure -text $caddr
		incr i
	}
}

AgentEntryWindow/MARS instproc update_data { addr msg delta } {
    $self instvar fields_ sesswin_ sessions_
	set i 0
    $fields_(o) configure -text "0"
	$fields_(s) configure -text "0"
	$fields_(toolname) configure -text "0"
	$fields_(tstime) configure -text [gettimeofday ascii]
	$fields_(tsfrom) configure -text $addr
	$fields_(delta) configure -text $delta
	set i 0
	set media "Mars"
		if ![info exists sessions_($i)] {
			set w \
			   [frame $sesswin_.x$i -relief groove -borderwidth 1]
			set fields_($i,addr) [$self mkfield $w Addr x$i,addr]
			set sessions_($i) $w
			pack $w -side top -fill x -expand 1
		}
		#set tmp [split [$media set caddr_] /]
		#set caddr [lindex $tmp 0]/[$media set port_]/[lindex $tmp 1]
		$fields_($i,addr) configure -text "0"
		incr i

}


#
AgentEntryWindow/Client instproc build_data { w } {
	$self instvar fields_ awin_ tstime_ tsfrom_
	set f [$self get_option smallfont]

	frame $w.d
	set fields_(o) [$self mkfield $w.d "Agent ID" o]
	set fields_(s) [$self mkfield $w.d "Session ID" s]
	set fields_(global) [$self mkfield $w.d "Global Addr" c]
	set fields_(local) [$self mkfield $w.d "Local Addr" local]
	set fields_(toolname) [$self mkfield $w.d Tool toolname]
	set fields_(sessionbw) [$self mkfield $w.d Bandwidth sessionbw]
	$fields_(sessionbw) configure -text N/A

	frame $w.ts
	$self mkts $w.ts
	pack $w.d $w.ts -side top -fill x -side top
}

#
AgentEntryWindow/Client instproc update_data { addr msg delta } {
	$self instvar fields_ sesswin_ sessions_
	set i 0
	$fields_(o) configure -text [join [$msg field_value o] :]
	$fields_(s) configure -text [join [$msg field_value s] :]
	$fields_(global) configure -text [$msg set caddr_]
	$fields_(toolname) configure -text [$msg attr_value tool]
	$fields_(tstime) configure -text [gettimeofday ascii]
	$fields_(tsfrom) configure -text $addr
	$fields_(delta) configure -text $delta

	if [$msg have_field b] {
		set bwval [$msg set bwval_]
		set bwval [AgentEntryWindow format_bps $bwval]
		$fields_(sessionbw) configure -text $bwval
	}

	set media [$msg set allmedia_]
	$fields_(local) configure -text [$media set caddr_]
}

AgentEntryWindow/ROVER instproc update_data { addr msg delta } {
	$self instvar fields_ sesswin_ sessions_
	set i 0
	$fields_(o) configure -text "0"
	$fields_(s) configure -text "0"
	$fields_(global) configure -text "0"
	$fields_(toolname) configure -text "0"
	$fields_(tstime) configure -text [gettimeofday ascii]
	$fields_(tsfrom) configure -text $addr
	$fields_(delta) configure -text $delta
	set bwval 0
		set bwval [AgentEntryWindow format_bps $bwval]
		$fields_(sessionbw) configure -text $bwval

	$fields_(local) configure -text "0"
}

#
AgentEntryWindow proc format_bps b {
	set bps $b
	if { $bps < 1 } {
		set bps "0 bps"
	} elseif { $bps < 1000 } {
		set bps [format "%3.0f bps" $bps]
	} elseif { $bps < 1000000 } {
		set bps [format "%3.0f kb/s" [expr $bps / 1000.]]
	} else {
		set bps [format "%.1f Mb/s" [expr $bps / 1000000.]]
	}
	return $bps
}

#
AgentEntryWindow/HM instproc build_data { w } {
	$self instvar fields_ awin_ tstime_ tsfrom_
	set f [$self get_option smallfont]

	frame $w.d
#	set fields_(o) [$self mkfield $w.d "Agent ID" o]

	frame $w.ts
	$self mkts $w.ts
	pack $w.d $w.ts -side top -fill x -side top
}

#
AgentEntryWindow/HM instproc update_data { addr msg delta } {
	$self instvar fields_ sesswin_ sessions_
	set i 0
#	$fields_(o) configure -text $aspec_
	$fields_(tstime) configure -text [gettimeofday ascii]
	$fields_(tsfrom) configure -text $addr
	$fields_(delta) configure -text $delta
}

