# pip-subprogram.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import DaliSubprogram
import RealParameter

Class PiPSubprogram -superclass DaliSubprogram

PiPSubprogram instproc init {args} {
    eval $self next $args;

    # Set up inputs

    $self instvar input_id_list_;
    $self instvar input_info_;

    lappend input_id_list_ i1

    set input_info_(i1,spec) "";
    set input_info_(i1,trigger) 0;
    set input_info_(i1,buffertype) Uncompressed;
    set input_info_(i1,buffername) [new VidRep/Uncompressed];
    set input_info_(i1,decoder) "";

    lappend input_id_list_ i2

    set input_info_(i2,spec) "";
    set input_info_(i2,trigger) 0;
    set input_info_(i2,buffertype) Uncompressed;
    set input_info_(i2,buffername) [new VidRep/Uncompressed];
    set input_info_(i2,decoder) "";

    # Set up outputs

    $self instvar output_id_list_;
    $self instvar output_info_;

    lappend output_id_list_ o1;

    set output_info_(o1,spec) "";
    set output_info_(o1,buffertype) Uncompressed;
    set output_info_(o1,buffername) [new VidRep/Uncompressed];
    set output_info_(o1,encoder) "";
    set output_info_(o1,format) JPEG;
    set output_info_(o1,vagent) "";

    # Set up parameters

    $self instvar parameter_id_list_;
    $self instvar parameter_info_;

    lappend parameter_id_list_ size
    set pobj [new RealParameter];

    set parameter_info_(size,oname) $pobj;
    $pobj from 0.0
    $pobj to 1.0
    $pobj set 0.0

    lappend parameter_id_list_ xpos
    set pobj [new RealParameter];

    set parameter_info_(xpos,oname) $pobj;
    $pobj from 0.0
    $pobj to 1.0
    $pobj set 0.0

    lappend parameter_id_list_ ypos
    set pobj [new RealParameter];

    set parameter_info_(ypos,oname) $pobj;
    $pobj from 0.0
    $pobj to 1.0
    $pobj set 0.0
}

PiPSubprogram instproc trigger {} {
    $self instvar parameter_info_;
    $self instvar input_info_;
    $self instvar output_info_;
    $self instvar init_done_;
    $self instvar la lb lc ld le lf ca cb cc cd ce cf
    $self instvar old_xpos old_ypos old_size;


    set size [$parameter_info_(size,oname) get];
    set xpos [$parameter_info_(xpos,oname) get];
    set ypos [$parameter_info_(ypos,oname) get];

    set in_frame $input_info_(i1,buffername);
    set pip_frame $input_info_(i2,buffername);
    set out_frame $output_info_(o1,buffername);

    if {![info exists init_done_]} {
	if {[$in_frame set w_] == 0} {
	    $self send_debug_mesg "Init failure: in_frame w == 0";
	    return;
	}
	if {[$pip_frame set w_] == 0} {
	    $self send_debug_mesg "Init failure: pip_frame w == 0";
	    return;
	}

	$out_frame copy_geometry $in_frame;

	if {$output_info_(o1,format) == "JPEG"} {
	    $out_frame set h_subsample_ 2;
	    $out_frame set v_subsample_ 1;
	} else {
	    $out_frame set h_subsample_ 2;
	    $out_frame set v_subsample_ 2;
	}
	$out_frame allocate;

	set init_done_ 1;

	set old_xpos "";
	set old_ypos "";
	set old_size "";
    }

    if {$old_xpos != $xpos || $old_ypos != $ypos || $old_size != $size} {
	set wa [$in_frame set w_];
	set ha [$in_frame set h_];

	set wb [$pip_frame set w_];
	set hb [$pip_frame set h_];

	set la [expr ($size * $wa) / ($wb * 1.0)];
	set lb 0.0;
	set lc [expr $wa * $xpos];
	set ld 0.0;
	set le [expr ($size * $ha) / ($hb * 1.0)];
	set lf [expr $ha * $ypos];

	set ca [expr $la * [$pip_frame set h_subsample_] / [$out_frame set h_subsample_]];
	set cb $lb;
	set cc [expr $lc/([$out_frame set h_subsample_]*1.0)];
	set cd $ld;
	set ce [expr $le * [$pip_frame set v_subsample_] / [$out_frame set v_subsample_]];
	set cf [expr $lf/([$out_frame set v_subsample_]*1.0)];

	set old_xpos $xpos;
	set old_ypos $ypos;
	set old_size $size;
    }

    set in_l [$in_frame get_lum_name];
    set in_cr [$in_frame get_cr_name];
    set in_cb [$in_frame get_cb_name];

    set out_l [$out_frame get_lum_name];
    set out_cr [$out_frame get_cr_name];
    set out_cb [$out_frame get_cb_name];

    set pip_l [$pip_frame get_lum_name];
    set pip_cr [$pip_frame get_cr_name];
    set pip_cb [$pip_frame get_cb_name];

    byte_copy $in_l $out_l;
    if {[$out_frame set v_subsample_] == 2 && [$in_frame set v_subsample_] == 1} {
	byte_shrink_1x2 $in_cr $out_cr;
	byte_shrink_1x2 $in_cb $out_cb;
    } elseif {[$out_frame set v_subsample_] == 1 && [$in_frame set v_subsample_] == 2} {
	byte_expand_1x2 $in_cr $out_cr;
	byte_expand_1x2 $in_cb $out_cb;
    } else {
	byte_copy $in_cr $out_cr;
	byte_copy $in_cb $out_cb;
    }

    byte_affine $pip_l $out_l $la $lb $lc $ld $le $lf;
    byte_affine $pip_cr $out_cr $ca $cb $cc $cd $ce $cf;
    byte_affine $pip_cb $out_cb $ca $cb $cc $cd $ce $cf;

    $out_frame set ts_ [$in_frame set ts_];

    set encoder $output_info_(o1,encoder);

    if {$encoder != ""} {
	$encoder recv $out_frame;
    }
    $self send_completion_token
}
