# fx_client.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1999-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

proc fx_create {effect_type} {
    set cntrl_handle [new FX_Client $effect_type];
    return $cntrl_handle
}

proc fx_destroy ch {
    delete $ch;
}

proc fx_set_input_callback {ch cb} {
    $ch set_input_callback $cb;
}

proc fx_set_output_callback {ch cb} {
    $ch set_output_callback $cb;
}

proc fx_set_parameter_callback {ch cb} {
    $ch set_parameter_callback $cb;
}

proc fx_get_parameter_type {ch pname} {
    return [$ch get_parameter_type $pname];
}

proc fx_get_parameter_domain {ch pname} {
    return [$ch get_parameter_domain $pname];
}

proc fx_set_input_spec {ch iname spec} {
    $ch set_input_spec $iname $spec
}

proc fx_set_output_spec {ch oname spec} {
    $ch set_output_spec $oname $spec
}

proc fx_set_parameter_value {ch pname value} {
    $ch set_parameter_value $pname $value
}

proc fx_status {ch {action ""}} {
    if {$action == ""} {
	return [$ch get_status];
    } else {
	return [$ch set_status $action]
    }
}

################################################

Class FX_Client

FX_Client instproc init {effect_type {num_nodes 4} {cntrl_spec ""}} {
    $self instvar effect_type_ al_ num_nodes_ cntrl_spec_

    set effect_type_ $effect_type;
    set num_nodes_ $num_nodes;

    if {$cntrl_spec != ""} {
	set cntrl_spec_ $cntrl_spec;
    } else {
	set rnum_a [expr int(rand()*253)+1];
	set rnum_b [expr int(rand()*253)+1];
	set rnum_c [expr (int(rand()*5000)*2)+10000];

	set cntrl_spec_ "224.3.${rnum_a}.${rnum_b}/${rnum_c}/16"
    }

    set as_spec [$self get_option megactrl];
    if {$as_spec == ""} {
	set as_spec 224.4.5.24/50000/16
    }
    set as_bw [$self get_option megabw];
    if {$as_bw == ""} {
	set as_bw 20000
    }
    set fx_service_location [$self get_option fx_service_location]
    if {$fx_service_location == ""} {
	set fx_service_location "http://www.cs.berkeley.edu/~kpatel/front_end"
    }

    set al_ [new AnnounceListenManager/AS/Client/FXClient $self $as_spec $as_bw $fx_service_location];

    $al_ start

    $self instvar input_callback_ output_callback_ parameter_callback_
    set input_callback_ ""
    set output_callback_ ""
    set parameter_callback_ ""

    $self instvar comm_obj_

    set comm_obj_ [new GraphComm/FXClient $self [$al_ agent_instance] $cntrl_spec_]

    $self instvar status_

    set status_ "off"
}

FX_Client instproc set_primary_trigger {iname} {
    $self instvar primary_trigger_inputs_ status_

    set primary_trigger_inputs_ $iname;

    if {$status_ == "on"} {
	set auto_val 1;
    } elseif {$status_ == "off"} {
	set auto_val 0;
    }

    $self instvar comm_obj_

    if {[info exists primary_trigger_inputs_]} {
	$comm_obj_ create_input $primary_trigger_inputs_
	$comm_obj_ create_input_attr $primary_trigger_inputs_ trigger
	$comm_obj_ set_input_attr $primary_trigger_inputs_ trigger [list auto $auto_val]
    }
}

FX_Client instproc get_status {} {
    $self instvar status_

    return $status_
}

FX_Client instproc set_status {new_status} {
    $self instvar status_;

    if {$status_ == $new_status} {
	return;
    }

    set status_ $new_status

    if {$status_ == "on"} {
	set auto_val 1
    } else {
	set auto_val 0
    }

    $self instvar comm_obj_ primary_trigger_inputs_

    if {[info exists primary_trigger_inputs_]} {
	$comm_obj_ create_input $primary_trigger_inputs_
	$comm_obj_ create_input_attr $primary_trigger_inputs_ trigger
	$comm_obj_ set_input_attr $primary_trigger_inputs_ trigger [list auto $auto_val]
    }
}

FX_Client instproc destroy {args} {
    $self instvar al_;

    delete $al_;

    $self instvar comm_obj_;

    delete $comm_obj_;

    $self next;
}

FX_Client instproc set_input_callback {cb} {
    $self instvar input_callback_;

    set input_callback_ $cb;

    if {$input_callback_ != ""} {
	$self instvar comm_obj_;

	foreach in [$comm_obj_ set input_names_] {
	    eval $input_callback_ $in
	}
    }
}

FX_Client instproc set_output_callback {cb} {
    $self instvar output_callback_;

    set output_callback_ $cb;

    if {$output_callback_ != ""} {
	$self instvar comm_obj_;

	foreach out [$comm_obj_ set output_names_] {
	    eval $output_callback_ $out
	}
    }
}

FX_Client instproc set_parameter_callback {cb} {
    $self instvar parameter_callback_;

    set parameter_callback_ $cb;

    if {$parameter_callback_ != ""} {
	$self instvar comm_obj_;

	catch "$comm_obj_ unset param_callback_done_"

	foreach p [$comm_obj_ set parameter_names_] {
	    if {[$comm_obj_ parameter_attr_has_value $p "type"]} {
		if {[$comm_obj_ parameter_attr_has_value $p "domain"]} {
		    $comm_obj_ set param_callback_done_($p) 1
		    eval $parameter_callback_ $p
		}
	    }
	}
    }
}

FX_Client instproc get_parameter_type {pname} {
    $self instvar comm_obj_;

    return [$comm_obj_ get_parameter_attr_value $pname "type"]
}

FX_Client instproc get_parameter_domain {pname} {
    $self instvar comm_obj_;

    return [$comm_obj_ get_parameter_attr_value $pname "domain"]
}

FX_Client instproc set_input_spec {iname spec} {
    $self instvar comm_obj_;

    if {[lsearch [$comm_obj_ set input_names_] $iname] == -1} {
	error "Trying to set spec for non-existant input $iname"
    }

    $comm_obj_ create_input $iname
    $comm_obj_ create_input_attr $iname spec
    $comm_obj_ set_input_attr $iname spec $spec
}

FX_Client instproc set_output_spec {oname spec} {
    $self instvar comm_obj_;

    if {[lsearch [$comm_obj_ set output_names_] $oname] == -1} {
	error "Trying to set spec for non-existant output $oname"
    }

    $comm_obj_ create_output $oname
    $comm_obj_ create_output_attr $oname spec
    $comm_obj_ set_output_attr $oname spec $spec
}

FX_Client instproc set_parameter_value {pname value} {
    $self instvar comm_obj_

    if {[lsearch [$comm_obj_ set parameter_names_] $pname] == -1} {
	error "Trying to set value for non-existant parameter $pname"
    }

    $comm_obj_ create_parameter $pname
    $comm_obj_ create_parameter_attr $pname value
    $comm_obj_ set_parameter_attr $pname value $value
}



##################################################

import AnnounceListenManager/AS/Client

Class AnnounceListenManager/AS/Client/FXClient -superclass AnnounceListenManager/AS/Client

AnnounceListenManager/AS/Client/FXClient instproc init {agent args} {
    $self instvar serv_inst_ agent_;

    eval $self next $args

    set rnum [expr int(rand() * 10000)];

    set serv_inst_ "fx_$rnum";

    set agent_ $agent;
}

AnnounceListenManager/AS/Client/FXClient instproc destroy {} {
    $self announce_death

    $self next
}

AnnounceListenManager/AS/Client/FXClient instproc service_name {} {
    return FXForwardFrontEnd
}

AnnounceListenManager/AS/Client/FXClient instproc service_instance {} {
    $self instvar serv_inst_;

    return $serv_inst_;
}

AnnounceListenManager/AS/Client/FXClient instproc agent_instance {} {
    return "${self}[pid]@[lookup_host_name [localaddr]]"
}

AnnounceListenManager/AS/Client/FXClient instproc agent_data {} {
    $self instvar agent_

    return "-subprogram [$agent_ set effect_type_] -num_nodes [$agent_ set num_nodes_] -cntrl_spec [$agent_ set cntrl_spec_]";
}

AnnounceListenManager/AS/Client/FXClient instproc register {args} {
}

AnnounceListenManager/AS/Client/FXClient instproc unregister {args} {
}

##################################################

import GraphComm;

Class GraphComm/FXClient -superclass GraphComm

GraphComm/FXClient instproc init {agent src_id cntrl_spec} {
    $self instvar agent_

    set agent_ $agent;

    set cntrl_spec [split $cntrl_spec "/"]

    $self next $src_id [lindex $cntrl_spec 0] [lindex $cntrl_spec 1] [lindex $cntrl_spec 2];

}

GraphComm/FXClient instproc new_input {new_name} {
    $self next $new_name;

    $self instvar agent_;

    if {[$agent_ set input_callback_] != ""} {
	eval [$agent_ set input_callback_] $new_name
    }
}

GraphComm/FXClient instproc new_output {new_name} {
    $self next $new_name;

    $self instvar agent_;

    if {[$agent_ set output_callback_] != ""} {
	eval [$agent_ set output_callback_] $new_name
    }
}

GraphComm/FXClient instproc new_input_attribute {iname aname} {
    $self next $iname $aname

    if {$aname == "primary_trigger"} {
	$self instvar agent_;

	$agent_ set_primary_trigger $iname;
    }
}

GraphComm/FXClient instproc update_parameter_attr_value {pname aname val} {
    $self next $pname $aname $val;

    $self instvar param_callback_done_

    if {![info exists param_callback_done_($pname)]} {
	if {[$self parameter_attr_has_value $pname "type"]} {
	    if {[$self parameter_attr_has_value $pname "domain"]} {

		$self instvar agent_;


		if {[$agent_ set parameter_callback_] != ""} {
		    set param_callback_done_($pname) 1
		    eval [$agent_ set parameter_callback_] $pname
		}
	    }
	}
    }
}

