# fx_ui.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1999-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import RTPApplication
import GraphComm

Class FX_UI_App -superclass RTPApplication

FX_UI_App instproc init args {
    $self next fx_ui

    $self init_resources

    [$self options] register_option -cntrl_spec cntrl_spec
    [$self options] register_option -comm_id comm_id

    eval [$self options] parse_args $args;

    $self instvar cntrl_obj_;

    set ctrl_spec [split [$self get_option cntrl_spec] "/"];
    set ctrl_addr [lindex $ctrl_spec 0];
    set ctrl_port [lindex $ctrl_spec 1];
    set ctrl_ttl [lindex $ctrl_spec 2];

    set cntrl_obj_ [new GraphComm/FX_UI $self [$self get_option comm_id] $ctrl_addr $ctrl_port $ctrl_ttl];

    $self instvar in_list_ out_list_ param_list_;

    set in_list_ "";
    set out_list_ "";
    set param_list_ "";

    frame .in_frame;
    frame .out_frame;
    frame .param_frame;

    pack .in_frame -side top -fill both -expand 1
    pack .out_frame -side top  -fill both -expand 1
    pack .param_frame -side top  -fill both -expand 1

    label .in_frame.l -text "Inputs"
    label .out_frame.l -text "Outputs"
    label .param_frame.l -text "Parameters"

    pack .in_frame.l -side top -fill both -expand 1
    pack .out_frame.l -side top -fill both -expand 1
    pack .param_frame.l -side top -fill both -expand 1
}

FX_UI_App instproc init_resources {} {
    $self add_option network ip
    $self add_option mtu 1024
    $self add_option defaultTTL 32
    $self add_option sessionType rtpv2
    $self add_option maxVideoSessionBW 30000000
    $self add_option cntrl_spec 224.3.2.1/22334/16

    set hname [exec hostname];
    set hname [split $hname .];
    set hname [string trim [lindex $hname 0]];

    $self add_option comm_id $hname;
}

FX_UI_App instproc BuildInputFrame {id} {
    $self instvar in_list_ cntrl_obj_;

    if {[lsearch $in_list_ $id] == -1} {
	lappend in_list_ $id;

	set f [frame .in_frame.$id];
	label $f.l -text "$id";
	entry $f.e;
	$f.e insert 0 "224.2.3.4/22334/*"
	button $f.b -text "Set" -command "$cntrl_obj_ set_input_attr $id spec \[$f.e get\]";
	checkbutton $f.trig -text "AutoTrigger" -variable trig_array($f.trig) -command "$cntrl_obj_ set_input_attr $id trigger \[list auto \$trig_array($f.trig)\]"
	pack $f.l -side left;
	pack $f.e -side left -fill x -expand 1;
	pack $f.b -side left;
	pack $f.trig -side right;
	pack $f -side top -fill both -expand 1;
    }
}

FX_UI_App instproc BuildOutputFrame {id} {
    $self instvar out_list_ cntrl_obj_

    if {[lsearch $out_list_ $id] == -1} {
	lappend out_list_ $id;

	set f [frame .out_frame.$id];
	label $f.l -text "$id";
	entry $f.e;
	$f.e insert 0 "224.2.3.4/22334"
	button $f.b -text "Set" -command "$cntrl_obj_ set_output_attr $id spec \[$f.e get\]";
	pack $f.l -side left;
	pack $f.e -side left -fill x -expand 1;
	pack $f.b -side right;
	pack $f -side top -fill both -expand 1;
    }
}

FX_UI_App instproc BuildParamFrame {id} {
    $self instvar param_list_ cntrl_obj_;

    if {[lsearch $param_list_ $id] != -1} {
	# Already build ui for this parameter
	return;
    }

    if {![$cntrl_obj_ parameter_attr_has_value $id type]} {
	# Don't know type info yet
	return;
    }
    if {![$cntrl_obj_ parameter_attr_has_value $id domain]} {
	# Don't know domain info yet
	return;
    }

    lappend param_list_ $id;

    set ptype [$cntrl_obj_ get_parameter_attr_value $id type];
    set pdomain [$cntrl_obj_ get_parameter_attr_value $id domain];

    set f [frame .param_frame.$id];
    label $f.l -text "$id";
    pack $f.l -side left;

    if {$ptype == "real"} {
	# Handle real value parameters here.
	set pdomain [split $pdomain "(),"];
	set from [lindex $pdomain 1];
	set to [lindex $pdomain 2];

	scale $f.s -from $from -to $to -resolution [expr ($to - $from)/100.0] -orient h;
	pack $f.s -side right -fill x -expand 1;
	$f.s configure -command "$cntrl_obj_ set_parameter_attr $id value ";
    } elseif {$ptype == "int"} {
	# Handle int value parameter here.
	set pdomain [split $pdomain "(),"];
	set from [lindex $pdomain 1];
	set to [lindex $pdomain 2];

	scale $f.s -from $from -to $to -resolution 1 -orient h;
	pack $f.s -side right -fill x -expand 1;
	$f.s configure -command "$cntrl_obj_ set_parameter_attr $id value";
    } elseif {$ptype == "exclusive_choice"} {
	# Exclusive choice type.
	menubutton $f.mb
	menu $f.mb.m
	foreach e $pdomain {
	    $f.mb.m add radiobutton -label $e -command "$f.mb configure -text \"$e\"; $cntrl_obj_ set_parameter_attr $id value $e";
	}
	$f.mb configure -text "None chosen" -menu $f.mb.m;
	pack $f.mb;
    } elseif {$ptype == "rect_subregion"} {
	import RectSubregionUI

	frame $f.f
	set o [new RectSubregionUI $f.f];
	pack $f.f -side right

	$o set_command "$cntrl_obj_ set_parameter_attr $id value ";
    } else {
	# All other types
	entry $f.e;
	button $f.b -text "Set" -command "$cntrl_obj_ set_parameter_attr $id value \[$f.e get\]";
	pack $f.e -side left -fill x -expand 1;
	pack $f.b -side right;
    }
    pack $f -side top -fill both -expand 1;
}

Class GraphComm/FX_UI -superclass GraphComm;

GraphComm/FX_UI instproc init {ui_obj comm_id addr port ttl} {
    $self next $comm_id $addr $port $ttl;

    $self instvar ui_obj_;

    set ui_obj_ $ui_obj;
}

GraphComm/FX_UI instproc new_input {new_name} {
    $self next $new_name;

    # Need to create input container in our local space
    # since we'll be writing to attributes.

    $self create_input $new_name

    # Create attribute containers for attributes we
    # expect to write

    $self create_input_attr $new_name spec;
    $self create_input_attr $new_name trigger;

    $self instvar ui_obj_;
    $ui_obj_ BuildInputFrame $new_name;
}

GraphComm/FX_UI instproc new_output {new_name} {
    $self next $new_name;

    $self create_output $new_name;
    $self create_output_attr $new_name spec;

    $self instvar ui_obj_;
    $ui_obj_ BuildOutputFrame $new_name;
}

GraphComm/FX_UI instproc new_parameter {new_name} {
    $self next $new_name;

    $self create_parameter $new_name;
    $self create_parameter_attr $new_name value;
}

GraphComm/FX_UI instproc update_parameter_attr_value {parameter_name attr_name value} {
    $self next $parameter_name $attr_name $value;

    if {$attr_name == "type"} {
	$self instvar ui_obj_;
	$ui_obj_ BuildParamFrame $parameter_name;
    } elseif {$attr_name == "domain"} {
	$self instvar ui_obj_;
	$ui_obj_ BuildParamFrame $parameter_name;
    }
}

set app [new FX_UI_App $argv];
