# ui.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/setup/ui.tcl,v 1.16 2002/02/12 02:37:21 lim Exp $


import WidgetClass Dialog MessageBox ProgressBar ScrolledText Icons


image create photo SetupIcon -file lib/setup/setup.gif


WidgetClass SetupDialog -superclass Dialog -default {
	{ .transient . }
	{ *Label.font WidgetDefault }
	{ *Button.borderWidth 1 }
	{ *Button.highlightThickness 1 }
}


SetupDialog private build_skeleton { path button_list } {
	wm resizable $path 0 0

	frame $path.container
	label $path.logo -image SetupIcon
	frame $path.main

	pack $path.logo -padx 10 -pady 5 -side left -in $path.container
	pack $path.main -padx 10 -pady 5 -side left -fill both -expand 1 \
			-in $path.container

	frame $path.separator -height 2 -borderwidth 2 -relief groove
	frame $path.buttons
	foreach b $button_list {
		set b_name [string tolower $b]
		button $path.$b_name -text $b \
				-command "$self configure -result $b"
		pack $path.$b_name -side left -padx 3 -pady 0 -in $path.buttons
	}

	pack $path.buttons -anchor e -side bottom -pady 5
	pack $path.separator -padx 5 -pady 5 -fill x -side bottom
	pack $path.container -fill both -expand 1 -side top

	return $path.main
}


SetupDialog public verify { direction } {
	return 1
}


SetupDialog public interpret_result { result } {
	return $result
}


WidgetClass WelcomeDlg -superclass SetupDialog -default {
	{ .title "Welcome to Setup" }
}


WelcomeDlg private build_widget { path } {
	set setup [Setup instance]
	$setup instvar appname_

	set path [$self build_skeleton $path [list Next Cancel]]
	label $path.label -justify left -text \
			"Welcome to the $appname_ Setup program.\
			\n\nThis program will install $appname_ on \
			\nyour computer."

	pack $path.label -side top -padx 5 -pady 10
}


WidgetClass CopyrightDlg -superclass SetupDialog -default {
	{ .title "Copyright Message" }
	{ *Text*borderWidth 1 }
	{ *Scrollbar*borderWidth 1 }
	{ *Scrollbar*width 10 }
}


CopyrightDlg private build_widget { path } {
	set setup [Setup instance]
	$setup instvar copyright_

	if [catch {set file [open $copyright_ "r"]} ] {
		set msg "Could not open COPYRIGHT file: $copyright_"
	} else {
		set msg ""
		while { [gets $file line] >= 0 } {
			append msg "$line\n"
		}
		close $file
	}

	set path [$self build_skeleton $path [list Accept Cancel]]
	ScrolledText $path.copyright -scrollbar both -options \
			{ {text.width 50} {text.height 16} {text.wrap none} }
	$path.copyright subwidget text insert end $msg
	$path.copyright subwidget text configure -state disabled

        # For some unknown reason, Courier doesn't work with setup on Windows.
        # The ansifixed font, which is Courier, does work.  Go figure.

        global tcl_platform
        if {$tcl_platform(platform) == {windows}} {
            $path.copyright subwidget text configure -font {ansifixed}
        } else {
            $path.copyright subwidget text configure -font {Courier 10}
        }

	pack $path.copyright -fill both -expand 1
}


CopyrightDlg private interpret_result { result } {
	if { $result=="accept" } { return "next" } else { return $result }
}


WidgetClass ChooseDstDlg -superclass SetupDialog -default {
	{ .title "Choose Destination Location" }
	{ *Entry.borderWidth 1 }
}


ChooseDstDlg private build_widget { path } {
	set setup [Setup instance]
	$setup instvar appname_

	set path [$self build_skeleton $path [list Back Next Cancel]]
	label $path.label -justify left -text \
		"Setup will install $appname_ in the following directory.\
		\n\nTo install to this directory, click Next.\
		\n\nTo install to a different directory, click Browse\
		\nand select another directory.\
		\n\nYou can choose not to install $appname_, by\
		clicking\nCancel to exit Setup.\n"

	$self tkvar dest_
	set dest_ [$setup set destination_]
	frame $path.frame -borderwidth 2 -relief groove
	entry $path.dest -textvariable [$self tkvarname dest_]
	button $path.browse -text "Browse..." -command "$self browse"

	pack $path.label -side top -pady 5 -padx 5
	pack $path.dest -in $path.frame -side left -fill both -expand 1 \
			-padx 5 -pady 2
	pack $path.browse -in $path.frame -side right -fill y -padx 5 -pady 2
	pack $path.frame -side top -padx 5 -pady 10 -fill x
}


ChooseDstDlg private browse { } {
	set setup [Setup instance]
	set dirdlg [$setup get_dirdlg]

	$self tkvar dest_
	set dirname [$setup get_real_dir $dest_]
	$dirdlg configure -title "Choose Destination Location"
	$dirdlg subwidget dirbox configure -allownonexistent 1
	$dirdlg configure -options [list [list dirbox.directory $dirname]]

	set retval [$dirdlg invoke]
	if { $retval!={} } {
		$self tkvar dest_
		set dest_ $retval
	}
}

ChooseDstDlg private verify { direction } {
	if { $direction=="back" } { return 1 }

	set setup [Setup instance]
	$self tkvar dest_
	$setup instvar destination_

	if [file isdirectory $dest_] {
		set destination_ $dest_
		return 1
	} elseif [file exists $dest_] {
		Dialog transient MessageBox \
				-text "\n\"$dest_\" is not a directory. Please\
				select a different directory.\n\n" \
				-image Icons(warning) -type ok
		return 0
	} else {
		set retval [Dialog transient MessageBox \
				-text "\nDirectory \"$dest_\" does not exist.\
				\nWould you like to create it?\n\n" \
				-image Icons(warning) -type yesno]
		if { $retval=="yes" } {
			# try to create the directory
			set retval [$setup create_dir $dest_]
			if { $retval == {} } {
				set destination_ $dest_
				return 1
			} else {
				Dialog transient MessageBox -type ok -text \
						"\nError occurred while\
						creating \"$dest_\":\n$retval\n\
						\nPlease correct this problem\
						or select a different\
						directory\n\n" \
						-image Icons(warning) -type ok
				return 0
			}
		} else {
			return 0
		}
	}
}


WidgetClass InstallTypeDlg -superclass SetupDialog -default {
	{ .title "Select Installation Type" }
	{ *Radiobutton.borderWidth 1 }
}


InstallTypeDlg private build_widget { path } {
	set setup [Setup instance]
	$setup instvar install_types_

	set path [$self build_skeleton $path [list Back Next Cancel]]

	label $path.label -justify left -text \
			"Select the type of installation you would like\
			\nSetup to perform:"
	pack $path.label -side top -fill x -pady 5 -padx 5

	set cnt 0
	foreach type $install_types_ {
		set label [string toupper [string index $type 0]][string \
				tolower [string range $type 1 end]]
		set b [radiobutton $path.b$cnt -text $label -value $type \
				-anchor w \
				-variable [$self tkvarname installtype_]]
		pack $b -side top -anchor w -fill x -padx 15
		incr cnt
	}

	$self instvar help_
	set help_ [label $path.help -justify left -text {} -anchor sw]
	pack $path.help -side bottom -fill both -expand 1 -padx 5 \
			-pady 5

	$self tkvar installtype_
	trace variable installtype_ w "$self update_help; $self ignore_args"
	set installtype_ [lindex $install_types_ 0]
}


InstallTypeDlg private update_help { } {
	$self tkvar installtype_
	$self instvar help_
	set setup [Setup instance]
	$setup instvar install_types_ install_types_help_

	set idx [lsearch $install_types_ $installtype_]
	if { $idx >= 0 } {
		$help_ configure -text \
				[lindex $install_types_help_ $idx]
	} else {
		$help configure -text {}
	}
}


InstallTypeDlg private verify { direction } {
	if { $direction=="back" } { return 1 }
	$self tkvar installtype_

	set setup [Setup instance]

	if { [string tolower $installtype_]=="custom" } {
		$setup instvar dialogs_
		if {[lsearch -exact $dialogs_ InstallMPlugDlg] == -1} {
			lappend dialogs_ InstallMPlugDlg
		}

		# we must prompt for a custom installation

		while { 1 } {
			set retval [$setup do_dialog CustomDlg]
			if { $retval=={} } { set retval 1 }
			if { $retval!=0 } break
		}

		if { $retval==-1 } { return 0 }
		$setup set install_components_ \
			[.customdlg get_install_components]
	} else {
		$setup instvar dialogs_
		set mplugDlg [lsearch -exact $dialogs_ InstallMPlugDlg]
		if {$mplugDlg != -1} {
			set dialogs_ [lreplace $dialogs_ $mplugDlg $mplugDlg]
		}

		$setup set install_components_ \
			[$setup set components_($installtype_)]
	}

	return 1
}


WidgetClass CustomDlg -superclass SetupDialog -default {
	{ .title "Exit Setup" }
	{ *Checkbutton.borderWidth 1 }
}


CustomDlg private build_widget { path } {
	set setup [Setup instance]
	$setup instvar components_

	set path [$self build_skeleton $path "Back Next Cancel"]
	label $path.label -justify left -text \
			"Here is a list of components that Setup can install\
			\nto your system. You may customize your installation\
			\nby selecting or unselecting any of these components:"
	pack $path.label -side top -pady 5 -padx 5

	$self tkvar custom_
	set cnt 0
	foreach component $components_(custom) {
		# check if this component is in the typical list
		if { [lsearch $components_(typical) $component] != -1 } {
			set custom_($component) 1
		} else {
			set custom_($component) 0
		}

		checkbutton $path.chk$cnt -text $component -anchor w -variable\
				[$self tkvarname custom_($component)]
		bind $path.chk$cnt <Enter> "$self update_help \{$component\}"
		pack $path.chk$cnt -fill x -padx 15
		incr cnt
	}

	$self instvar help_
	set help_ [label $path.help -justify left -anchor sw -height 5]
	pack $path.help -side bottom -fill both -expand 1 -padx 5 \
			-pady 5
}


CustomDlg private update_help { component } {
	set setup [Setup instance]
	$setup instvar component_help_
	$self instvar help_

	if [info exists component_help_($component)] {
		$help_ configure -text $component_help_($component)
	} else {
		$help_ configure -text ""
	}
}


CustomDlg public get_install_components { } {
	set setup [Setup instance]
	$setup instvar components_
	$self tkvar custom_
	set list {}
	foreach component $components_(custom) {
		if { $custom_($component)==1 } { lappend list $component }
	}

	return $list
}


WidgetClass CancelDlg -superclass SetupDialog -default {
	{ .title "Exit Setup" }
}


CancelDlg private build_widget { path } {
	set setup [Setup instance]
	$setup instvar appname_

	set path [$self build_skeleton $path [list Resume Exit]]
	$self subwidget logo configure -image Icons(warning)

	label $path.label -justify left -text \
			"Setup is not complete. If you quit the Setup program\
			\nnow, $appname_ will not be installed.\
			\n\nYou may run the Setup program at a later time to\
			\ncomplete the installation.\
			\n\nTo continue installing the program, click Resume.\
			\nTo quit the Setup program, click Exit."

	pack $path.label -side top -pady 10
}



WidgetClass SetupProgress -superclass Dialog -default {
	{ .transient . }
	{ .title "Installation in progress" }
	{ *Label.font WidgetDefault }
}


SetupProgress private destroy { } {
	image delete image${self}_blank
}


SetupProgress private build_widget { path } {
	wm resizable $path 0 0

	set cnt 0

	set blank [image create photo image${self}_blank]
	$blank copy Icons(check)
	$blank blank

	frame $path.list
	foreach item [$self checklist] {
		frame $path.f$cnt
		label $path.check$cnt -image $blank
		label $path.label$cnt -justify left -text $item -anchor w

		pack $path.check$cnt -in $path.f$cnt -side left
		pack $path.label$cnt -in $path.f$cnt -side left -fill both \
				-expand 1 -anchor w
		pack $path.f$cnt -fill x -side top -padx 5 -in $path.list
		incr cnt
	}

	pack $path.list -padx 5 -pady 10 -fill x -side top
	frame $path.separator -height 2 -borderwidth 2 -relief groove
	pack $path.separator -padx 5 -pady 5 -fill x -side top

	label $path.info -justify left -anchor w
	pack $path.info -fill x -padx 10
	ProgressBar $path.bar
	pack $path.bar -fill x -padx 10 -pady 10
}


SetupProgress public check { index } {
	if [winfo exists [$self info path].check$index] {
		$self subwidget check$index configure -image Icons(check)
	}
}


SetupProgress public check_next { } {
	$self instvar check_cnt_
	if { ![info exists check_cnt_] } {
		set check_cnt_ 0
	}
	$self check $check_cnt_
	incr check_cnt_
}


SetupProgress private checklist { } {
	set setup [Setup instance]
	foreach component [$setup set install_components_] {
		lappend list "Copy $component"
	}
	return $list
}
