# application-tgmb.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/tgmb/application-tgmb.tcl,v 1.3 2002/02/03 04:30:13 lim Exp $


import Application RMXAgent

Class Application/RMX -superclass Application

Application/RMX public init argv {
	$self next rmx
	set o [$self options]
	$self init_args $o
	$self init_resources $o
	$o parse_args $argv
	$self init_local

	$self instvar agent_

	set servinst [$self get_option serviceInstance]
	set megactrl [$self get_option megaCtrl]
	set agent_ [new RMXAgent]
	$agent_ initialize $servinst $megactrl
}


Application/RMX public destroy {} {
	$self instvar agent_
	delete $agent_
	$self next
}


Application/RMX private init_args o {
	$o register_boolean_option -lb loadBalance
	$o register_boolean_option -fork doFork
	$o register_boolean_option -glunix glunix
	$o register_boolean_option -noload noLoad
	$o register_boolean_option -nolog noLog

	$o register_option -servinst serviceInstance
	$o register_option -megactrl megaCtrl
}


Application/RMX private init_resources o {
	$o add_default megaCtrl 224.4.5.24/50000/31
	$self add_default defaultTTL 31
}


Application/RMX private reset { ab } {
	[$self set agent_] reset $ab
}

