# logger.tcl --
#
#      Listens for all AMX events and outputs a record, including timestamps
#      and descriptions
#
# Copyright (c) 2001-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Import enable

import 405Client

# FIXME - this app should be renamed, there is a unix utility named logger!

# use the Tcl namespace facility to prevent conflicts
namespace eval Logger {
    variable self
    variable enabled
}

# FIXME - this only records info about AMX events.  It would be nice if
#   we could record the interaction b/w the VD and DC, know the start/end
#   times for the recorder, etc.
#
# There's currently no infrastructure to support this

Class Logger

Logger instproc init {base} {
    $self instvar 405_

    set 405_ [new 405Client]

    # so that the callback can refer to this object
    set Logger::self $self

    set callback "$self processAmxMsg"
    $405_ callback_register $callback

    $self initUI $base

    set sysTime [gettimeofday]
    set d [exec date]
    puts stdout "Logger started: $d : $sysTime"
}

Logger instproc initUI {base} {
    frame $base.controls -borderwidth 3
    pack $base.controls -side top -fill x

    checkbutton $base.controls.onOff -text "Enable Logging" -variable Logger::enabled -command "$self toggleOnOff"
    pack $base.controls.onOff -side left

    # if you want the default to be on, have to set Logger::enabled
    #   to 1 and call toggleOnOff manually
#    set Logger::enabled 0
    set Logger::enabled 1
    $self toggleOnOff
}

Logger public toggleOnOff {} {
    $self instvar 405_

    set callback "$self processAmxMsg"
    if {$Logger::enabled == 0} {
	$405_ callback_disable $callback
    } else {
	$405_ callback_enable $callback
    }
}

Logger public processAmxMsg { amxMsg } {
#    puts stdout "amxMsg is $amxMsg"

    if {[llength $amxMsg] == 0} {
	puts stderr "processAmxMsg: nothing received"
	return
    }

    set sysTime [gettimeofday]
    set eventInfo [lindex $amxMsg 0]
    set eventData [lindex $amxMsg 1]
    set type [lindex $eventInfo 0]

    puts stdout "$sysTime: $type"

    switch -exact -- $type {
	amxCommand {
	    set cmd [lindex $eventData 0]
	    set dev [lindex $eventData 1]
	    set chan_str [lindex $eventData 2]
	    puts stdout "\tcmd=$cmd, dev=$dev, chan_str=$chan_str"
	}
	amxResponse {
	    set cmd [lindex $eventData 0]
	    set dev [lindex $eventData 1]
	    set chan_str [lindex $eventData 2]
	    puts stdout "\tcmd=$cmd, dev=$dev, chan_str=$chan_str"
	}
	matrixSwitch {
	    set input [lindex $eventData 0]
	    set output [lindex $eventData 1]
	    puts stdout "\tinput=$input, output=$output"
	}
    }
    return ""
}

Logger public enable {} {
    set Logger::enabled 1
    $self toggleOnOff
}

Logger public disable {} {
    set Logger::enabled 0
    $self toggleOnOff
}
