#!/usr/sww/bin/perl

# compare.pl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

if(!defined($baseDir=$ARGV[0]))
{
    print("Usage: compare.pl <basedir> [<st> <lt> <ct> <rt> <histSize> <timeSlice>]\n");
    exit;
}
if(!defined($st=$ARGV[1]))
{
    $st = 30;
}
if(!defined($lt=$ARGV[2]))
{
    $lt = 30;
}
if(!defined($ct=$ARGV[3]))
{
    $ct = 30;
}
if(!defined($rt=$ARGV[4]))
{
    $rt = 30;
}
if(!defined($histSize=$ARGV[5]))
{
    $histSize = 30;
}
if(!defined($timeSlice=$ARGV[6]))
{
    $timeSlice = 250;
}
if(!defined($switchThreshold=$ARGV[7]))
{
    $switchThreshold = 10;
}


$INPUT_DIR = $baseDir;

$TMP_DIR = "./tmp";
$RECENT_DIR = "$TMP_DIR/recent";
$BIN_DIR = "../utils";
$RESULTS_DIR = "./results";
$SIM_DIR = "../sim";

$LOG_B2A = "$BIN_DIR/log_b2a";
$MARK2GRAPH = "$BIN_DIR/mark2graph";
$SIM2GRAPH = "$BIN_DIR/sim2graph";
$MARK2STATE = "$BIN_DIR/mark2state";
$SIM2STATE = "$BIN_DIR/sim2state";
$SIM = "$SIM_DIR/sim";
$ANALYZE = "$BIN_DIR/analyze";

$assembleGraph = "./assembleGraph.tcl";
$filter = "$BIN_DIR/filter.tcl";
$index2times = "$BIN_DIR/index2times";

$markFile = "$INPUT_DIR/log.spoofMark";
#$markFile = "$INPUT_DIR/log.mark";

print("\nUsing markFile = $markFile\n\n");

$numIndices = `$BIN_DIR/log_num $INPUT_DIR/log.speaker` - 1;

open(OUTFILE, ">$RESULTS_DIR/analyze.out");
print OUTFILE ("Input Dir: $INPUT_DIR\n");
print OUTFILE ("Thresholds:\n");
print OUTFILE ("\tspeaker: $st\n");
print OUTFILE ("\tleft: $lt\n");
print OUTFILE ("\tcenter: $ct\n");
print OUTFILE ("\tright: $rt\n");
print OUTFILE ("Num Indices: $numIndices\n");
print OUTFILE ("\n");
close OUTFILE;


# analysis
print("Generating analysis\n");
system "$LOG_B2A $INPUT_DIR/log.speaker > $TMP_DIR/speaker.dat";
system "$LOG_B2A $INPUT_DIR/log.audienceLeft > $TMP_DIR/audienceLeft.dat";
system "$LOG_B2A $INPUT_DIR/log.audienceCenter > $TMP_DIR/audienceCenter.dat";
system "$LOG_B2A $INPUT_DIR/log.audienceRight > $TMP_DIR/audienceRight.dat";
system "$SIM -lidir $TMP_DIR -st $st -lt $lt -ct $ct -rt $rt -h $histSize -slice $timeSlice -switchT $switchThreshold";
system "mv sim.out $TMP_DIR/sim.out";
system "mv sim.samples.speaker $TMP_DIR/.";
system "mv sim.samples.left $TMP_DIR/.";
system "mv sim.samples.center $TMP_DIR/.";
system "mv sim.samples.right $TMP_DIR/.";
system "$MARK2STATE $markFile $numIndices > $TMP_DIR/mark.state";
system "$SIM2STATE $TMP_DIR/sim.out $numIndices > $TMP_DIR/sim.state";
system "$ANALYZE $TMP_DIR/mark.state $TMP_DIR/sim.state $RESULTS_DIR/analyze.stats >> $RESULTS_DIR/analyze.out";

# vs file
$title = "vs";
print("Generating $title\n");
$sl = 5;
$ll = 25;
$cl = 50;
$rl = 75;
$generic = 100;
system "$MARK2GRAPH $markFile $sl $ll $cl $rl $generic > $TMP_DIR/mark.graph";
$sl = $sl + 3;
$ll = $ll + 3;
$cl = $cl + 3;
$rl = $rl + 3;
system "$SIM2GRAPH $TMP_DIR/sim.out $sl $ll $cl $rl > $TMP_DIR/sim.graph";
system "$assembleGraph -t \"Sim Vs. Mark\" -x \"index (60ms)\" -f $TMP_DIR/sim.graph -l \"Sim\" -f $TMP_DIR/mark.graph -l \"Mark\" > $RESULTS_DIR/graph.vs";

# raw inputs graph
$title = "raw";
print("Generating $title\n");
system "$assembleGraph -t \"Raw Mic Inputs\" -x \"index (60ms)\" -f $TMP_DIR/speaker.dat -l \"Speaker\" -f $TMP_DIR/audienceLeft.dat -l \"Left\" -f $TMP_DIR/audienceCenter.dat -l \"Center\" -f $TMP_DIR/audienceRight.dat -l \"Right\" > $RESULTS_DIR/graph.raw";

# filtered graph
$title = "filter";
print("Generating $title\n");
system "$filter -f $TMP_DIR/speaker.dat -t $st -s $histSize > $TMP_DIR/speaker.filter.dat";
system "$filter -f $TMP_DIR/audienceLeft.dat -t $lt -s $histSize > $TMP_DIR/audienceLeft.filter.dat";
system "$filter -f $TMP_DIR/audienceCenter.dat -t $ct -s $histSize > $TMP_DIR/audienceCenter.filter.dat";
system "$filter -f $TMP_DIR/audienceRight.dat -t $rt -s $histSize > $TMP_DIR/audienceRight.filter.dat";
system "$assembleGraph -t \"Filtered Mic Inputs\" -x \"index (60ms)\" -f $TMP_DIR/speaker.filter.dat -l \"Speaker\" -f $TMP_DIR/audienceLeft.filter.dat -l \"Left\" -f $TMP_DIR/audienceCenter.filter.dat -l \"Center\" -f $TMP_DIR/audienceRight.filter.dat -l \"Right\" > $RESULTS_DIR/graph.filter";

# all
$title = "all";
print("Generating $title\n");
system "$assembleGraph -t \"All\" -x \"index (60ms)\" -f $TMP_DIR/speaker.filter.dat -l \"Speaker (filtered)\" -f $TMP_DIR/audienceLeft.filter.dat -l \"Left (filtered)\" -f $TMP_DIR/audienceCenter.filter.dat -l \"Center (filtered)\" -f $TMP_DIR/audienceRight.filter.dat -l \"Right (filtered)\" -f $TMP_DIR/speaker.dat -l \"Speaker (Raw)\" -f $TMP_DIR/audienceLeft.dat -l \"Left (Raw)\" -f $TMP_DIR/audienceCenter.dat -l \"Center (Raw)\" -f $TMP_DIR/audienceRight.dat -l \"Right (Raw)\" -f $TMP_DIR/sim.graph -l \"Sim\" -f $TMP_DIR/mark.graph -l \"Mark\" > $RESULTS_DIR/graph.all";

# vs + left raw and filter
$title = "leftvs";
print("Generating $title\n");
system "echo \"0 $lt\" > $TMP_DIR/graph.threshold";
system "echo \"$numIndices $lt\" >> $TMP_DIR/graph.threshold";
system "$assembleGraph -t \"Vs. + Left\" -x \"index (60ms)\" -f $TMP_DIR/audienceLeft.filter.dat -l \"Left (filtered)\" -f $TMP_DIR/audienceLeft.dat -l \"Left (Raw)\" -f $TMP_DIR/sim.graph -l \"Sim\" -f $TMP_DIR/mark.graph -l \"Mark\" -f $TMP_DIR/graph.threshold -l \"threshold = $lt\" > $RESULTS_DIR/graph.leftvs";

# vs + center raw and filter
$title = "centervs";
print("Generating $title\n");
system "echo \"0 $ct\" > $TMP_DIR/graph.threshold";
system "echo \"$numIndices $ct\" >> $TMP_DIR/graph.threshold";
system "$assembleGraph -t \"Vs. + Center\" -x \"index (60ms)\" -f $TMP_DIR/audienceCenter.filter.dat -l \"Center (filtered)\" -f $TMP_DIR/audienceCenter.dat -l \"Center (Raw)\" -f $TMP_DIR/sim.graph -l \"Sim\" -f $TMP_DIR/mark.graph -l \"Mark\" -f $TMP_DIR/graph.threshold -l \"threshold = $ct\" > $RESULTS_DIR/graph.centervs";

# vs + right raw and filter
$title = "rightvs";
print("Generating $title\n");
system "echo \"0 $rt\" > $TMP_DIR/graph.threshold";
system "echo \"$numIndices $rt\" >> $TMP_DIR/graph.threshold";
system "$assembleGraph -t \"Vs. + Right\" -x \"index (60ms)\" -f $TMP_DIR/audienceRight.filter.dat -l \"Right (filtered)\" -f $TMP_DIR/audienceRight.dat -l \"Right (Raw)\" -f $TMP_DIR/sim.graph -l \"Sim\" -f $TMP_DIR/mark.graph -l \"Mark\" -f $TMP_DIR/graph.threshold -l \"threshold = $rt\" > $RESULTS_DIR/graph.rightvs";

# raw and filter
$title = "rawfilter";
print("Generating $title\n");
system "$assembleGraph -t \"Raw and Filter\" -x \"index (60ms)\" -f $TMP_DIR/speaker.filter.dat -l \"Speaker (filtered)\" -f $TMP_DIR/audienceLeft.filter.dat -l \"Left (filtered)\" -f $TMP_DIR/audienceCenter.filter.dat -l \"Center (filtered)\" -f $TMP_DIR/audienceRight.filter.dat -l \"Right (filtered)\" -f $TMP_DIR/speaker.dat -l \"Speaker (Raw)\" -f $TMP_DIR/audienceLeft.dat -l \"Left (Raw)\" -f $TMP_DIR/audienceCenter.dat -l \"Center (Raw)\" -f $TMP_DIR/audienceRight.dat -l \"Right (Raw)\" > $RESULTS_DIR/graph.rawfilter";

# left raw and speaker
$title = "left";
print("Generating $title\n");
system "echo \"0 $lt\" > $TMP_DIR/graph.threshold";
system "echo \"$numIndices $lt\" >> $TMP_DIR/graph.threshold";
system "$assembleGraph -t \"Left Raw and Filter\" -x \"index (60ms)\" -f $TMP_DIR/audienceLeft.filter.dat -l \"Left (filtered)\" -f $TMP_DIR/audienceLeft.dat -l \"Left (Raw)\" -f $TMP_DIR/graph.threshold -l \"threshold = $lt\" > $RESULTS_DIR/graph.left";

# center raw and speaker
$title = "center";
print("Generating $title\n");
system "echo \"0 $ct\" > $TMP_DIR/graph.threshold";
system "echo \"$numIndices $ct\" >> $TMP_DIR/graph.threshold";
system "$assembleGraph -t \"Center Raw and Filter\" -x \"index (60ms)\" -f $TMP_DIR/audienceCenter.filter.dat -l \"Center (filtered)\" -f $TMP_DIR/audienceCenter.dat -l \"Center (Raw)\" -f $TMP_DIR/graph.threshold -l \"threshold = $ct\" > $RESULTS_DIR/graph.center";

# right raw and speaker
$title = "right";
print("Generating $title\n");
system "echo \"0 $rt\" > $TMP_DIR/graph.threshold";
system "echo \"$numIndices $rt\" >> $TMP_DIR/graph.threshold";
system "$assembleGraph -t \"Right Raw and Filter\" -x \"index (60ms)\" -f $TMP_DIR/audienceRight.filter.dat -l \"Right (filtered)\" -f $TMP_DIR/audienceRight.dat -l \"Right (Raw)\" -f $TMP_DIR/graph.threshold -l \"threshold = $rt\" > $RESULTS_DIR/graph.right";

# filter and vs
$title = "filtervs";
print("Generating $title\n");
$sl = 5;
$ll = 20;
$cl = 22.5;
$rl = 25;
$generic = 30;
system "$MARK2GRAPH $markFile $sl $ll $cl $rl $generic > $TMP_DIR/mark.graph";
$sl = $sl + 0.5;
$ll = $ll + 0.5;
$cl = $cl + 0.5;
$rl = $rl + 0.5;
system "$SIM2GRAPH $TMP_DIR/sim.out $sl $ll $cl $rl > $TMP_DIR/sim.graph";
system "$assembleGraph -t \"Filter, Mark, and Sim\" -x \"index (60ms)\" -f $TMP_DIR/speaker.filter.dat -l \"Speaker (filtered)\" -f $TMP_DIR/audienceLeft.filter.dat -l \"Left (filtered)\" -f $TMP_DIR/audienceCenter.filter.dat -l \"Center (filtered)\" -f $TMP_DIR/audienceRight.filter.dat -l \"Right (filtered)\" -f $TMP_DIR/sim.graph -l \"Sim\" -f $TMP_DIR/mark.graph -l \"Mark\" > $RESULTS_DIR/graph.filtervs";

# samples and vs
$title = "samplesvs";
print("Generating $title\n");
system "$assembleGraph -t \"Samples, Mark, and Sim\" -x \"index (60ms)\" -f $TMP_DIR/sim.samples.speaker -l \"Speaker\" -f $TMP_DIR/sim.samples.left -l \"Left\" -f $TMP_DIR/sim.samples.center -l \"Center\" -f $TMP_DIR/sim.samples.right -l \"Right\" -f $TMP_DIR/sim.graph -l \"Sim\" -f $TMP_DIR/mark.graph -l \"Mark\" > $RESULTS_DIR/graph.samplesvs";

# samples and filters
$title = "samplesfilter";
print("Generating $title\n");
system "$assembleGraph -t \"Samples and Filter\" -x \"index (60ms)\" -f $TMP_DIR/speaker.filter.dat -l \"Speaker (filtered)\" -f $TMP_DIR/audienceLeft.filter.dat -l \"Left (filtered)\" -f $TMP_DIR/audienceCenter.filter.dat -l \"Center (filtered)\" -f $TMP_DIR/audienceRight.filter.dat -l \"Right (filtered)\" -f $TMP_DIR/sim.samples.speaker -l \"Speaker (samples)\" -f $TMP_DIR/sim.samples.left -l \"Left (samples)\" -f $TMP_DIR/sim.samples.center -l \"Center (samples)\" -f $TMP_DIR/sim.samples.right -l \"Right (samples)\" > $RESULTS_DIR/graph.samplesfilter";


# time files (x axis in sec)
$doTime = 1;
if($doTime)
{
    $title = "time files";
    print("Generating $title\n");
    $ext = vs;
    system "$index2times $RESULTS_DIR/graph.$ext > $RESULTS_DIR/graph.time.$ext";
    $ext = raw;
    system "$index2times $RESULTS_DIR/graph.$ext > $RESULTS_DIR/graph.time.$ext";
    $ext = filter;
    system "$index2times $RESULTS_DIR/graph.$ext > $RESULTS_DIR/graph.time.$ext";
    $ext = all;
    system "$index2times $RESULTS_DIR/graph.$ext > $RESULTS_DIR/graph.time.$ext";
    $ext = leftvs;
    system "$index2times $RESULTS_DIR/graph.$ext > $RESULTS_DIR/graph.time.$ext";
    $ext = centervs;
    system "$index2times $RESULTS_DIR/graph.$ext > $RESULTS_DIR/graph.time.$ext";
    $ext = rightvs;
    system "$index2times $RESULTS_DIR/graph.$ext > $RESULTS_DIR/graph.time.$ext";
    $ext = rawfilter;
    system "$index2times $RESULTS_DIR/graph.$ext > $RESULTS_DIR/graph.time.$ext";
    $ext = left;
    system "$index2times $RESULTS_DIR/graph.$ext > $RESULTS_DIR/graph.time.$ext";
    $ext = center;
    system "$index2times $RESULTS_DIR/graph.$ext > $RESULTS_DIR/graph.time.$ext";
    $ext = right;
    system "$index2times $RESULTS_DIR/graph.$ext > $RESULTS_DIR/graph.time.$ext";
    $ext = filtervs;
    system "$index2times $RESULTS_DIR/graph.$ext > $RESULTS_DIR/graph.time.$ext";
    $ext = samplesvs;
    system "$index2times $RESULTS_DIR/graph.$ext > $RESULTS_DIR/graph.time.$ext";
    $ext = samplesfilter;
    system "$index2times $RESULTS_DIR/graph.$ext > $RESULTS_DIR/graph.time.$ext";
}
