#!/usr/sww/bin/perl

# compareshort.pl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

if(!defined($baseDir=$ARGV[0]))
{
    print("Usage: compareshort.pl <basedir> [<st> <lt> <ct> <rt> <histSize> <timeSlice>]\n");
    exit;
}
if(!defined($st=$ARGV[1]))
{
    $st = 30;
}
if(!defined($lt=$ARGV[2]))
{
    $lt = 30;
}
if(!defined($ct=$ARGV[3]))
{
    $ct = 30;
}
if(!defined($rt=$ARGV[4]))
{
    $rt = 30;
}
if(!defined($histSize=$ARGV[5]))
{
    $histSize = 30;
}
if(!defined($timeSlice=$ARGV[6]))
{
    $timeSlice = 250;
}

# directories
$INPUT_DIR = "../tests/work/$baseDir";
$TMP_DIR = "./tmp";
$BIN_DIR = "../utils";
$RESULTS_DIR = "./work/$baseDir/results";
$SIM_DIR = "../sim";

# utilities
$LOG_B2A = "$BIN_DIR/log_b2a";
$MARK2GRAPH = "$BIN_DIR/mark2graph";
$SIM2GRAPH = "$BIN_DIR/sim2graph";
$MARK2STATE = "$BIN_DIR/mark2state";
$SIM2STATE = "$BIN_DIR/sim2state";
$SIM = "$SIM_DIR/sim";
$ANALYZE = "$BIN_DIR/analyze";
$assembleGraph = "./assembleGraph.tcl";
$filter = "$BIN_DIR/filter.tcl";

$numIndices = `$BIN_DIR/log_num $INPUT_DIR/log.speaker` - 1;

open(OUTFILE, ">$RESULTS_DIR/analyze.out");
print OUTFILE ("Input Dir: $INPUT_DIR\n");
print OUTFILE ("Thresholds:\n");
print OUTFILE ("\tspeaker: $st\n");
print OUTFILE ("\tleft: $lt\n");
print OUTFILE ("\tcenter: $ct\n");
print OUTFILE ("\tright: $rt\n");
print OUTFILE ("Num Indices: $numIndices\n");
print OUTFILE ("\n");
close OUTFILE;


# the next part is replaced by prepare.pl so you only need to do it once
#  system "$LOG_B2A $INPUT_DIR/log.speaker > $TMP_DIR/speaker.dat";
#  system "$LOG_B2A $INPUT_DIR/log.audienceLeft > $TMP_DIR/audienceLeft.dat";
#  system "$LOG_B2A $INPUT_DIR/log.audienceCenter > $TMP_DIR/audienceCenter.dat";
#  system "$LOG_B2A $INPUT_DIR/log.audienceRight > $TMP_DIR/audienceRight.dat";
#  system "$MARK2STATE $markFile $numIndices > $TMP_DIR/mark.state";

system "$SIM -lidir $TMP_DIR -st $st -lt $lt -ct $ct -rt $rt -h $histSize -slice $timeSlice";
system "mv sim.out $TMP_DIR/sim.out";
system "mv sim.samples.speaker $TMP_DIR/.";
system "mv sim.samples.left $TMP_DIR/.";
system "mv sim.samples.center $TMP_DIR/.";
system "mv sim.samples.right $TMP_DIR/.";
system "$SIM2STATE $TMP_DIR/sim.out $numIndices > $TMP_DIR/sim.state";

system "$ANALYZE $TMP_DIR/mark.state $TMP_DIR/sim.state $RESULTS_DIR/analyze.stats >> $RESULTS_DIR/analyze.out";

