# evalnonew.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2001-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

source tcl/vd/qm/utils/getkeys.tcl

proc showUsage {} {
    puts stdout "usage: evaluate <cmd> <filename>"
    puts stdout "  cmd:"
    puts stdout "\toverall \[<W1> <W2> <W3> <W4> <W5>\]"
    puts stdout "\t\tW1 = percentQuestionsCorrect weight"
    puts stdout "\t\tW2 = percentQuestionsMissed weight"
    puts stdout "\t\tW3 = percentQuestionsWrong weight"
    puts stdout "\t\tW4 = percentSpeakerCorrect weight"
    puts stdout "\t\tW5 = percentSpeakerFalsePositive weight"
    puts stdout "\tquestionsCorrect"
    puts stdout "\tquestionsMissed"
    puts stdout "\tquestionsWrong"
    puts stdout "\tspeakerCorrect"
    puts stdout "\tspeakerFalsePositives"
    exit
}

proc evaluate {w1 w2 w3 w4 w5} {
    global g_keys

    set pctQuestionsCorrect $g_keys(percentQuestionsCorrect)
    set pctQuestionsMissed $g_keys(percentQuestionsMissed)
    set pctQuestionsWrong $g_keys(percentQuestionsWrong)
    set pctSpeakerCorrect $g_keys(percentSpeakerCorrect)
    set pctFalsePositives $g_keys(percentSpeakerFalsePositives)

    set c1 [expr double($pctQuestionsCorrect) * double($w1)]
    set c2 [expr (1 - double($pctQuestionsMissed)) * double($w2)]
    set c3 [expr (1 - double($pctQuestionsWrong)) * double($w3)]
    set c4 [expr double($pctSpeakerCorrect) * double($w4)]
    set c5 [expr (1 - double($pctFalsePositives)) * double($w5)]
    set val [expr $c1 + $c2 + $c3 + $c4 + double($c5)]

    # we need to normalize it
    set max [expr double($w1) + $w2 + $w3 + $w4 + $w5]
    set val [expr double($val) / double($max)]

    puts -nonewline stdout "$val"
}

# main program

# defaults
set w1 200
set w2 150
set w3 150
set w4 50
set w5 450
if {[llength $argv] != 2 && [llength $argv] != 7} {
    showUsage
}
set cmd [lindex $argv 0]
if {[llength $argv] == 7} {
    set w1 [lindex $argv 1]
    set w2 [lindex $argv 2]
    set w3 [lindex $argv 3]
    set w4 [lindex $argv 4]
    set w5 [lindex $argv 5]
    set filename [lindex $argv 6]
} else {
    set filename [lindex $argv 1]
}

getkeys $filename

switch -exact -- $cmd {
    overall {
	evaluate $w1 $w2 $w3 $w4 $w5
    }
    questionsCorrect {
	puts -nonewline stdout "$g_keys(percentQuestionsCorrect)"
    }
    questionsMissed {
	puts -nonewline stdout "$g_keys(percentQuestionsMissed)"
    }
    questionsWrong {
	puts -nonewline stdout "$g_keys(percentQuestionsWrong)"
    }
    speakerCorrect {
	puts -nonewline stdout "$g_keys(percentSpeakerCorrect)"
    }
    speakerFalsePositives {
	puts -nonewline stdout "$g_keys(percentSpeakerFalsePositives)"
    }
    default {
	showUsage
    }
}

