# onair.tcl --
#
#       An app for turning on/off the "ON AIR" sign in 405.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Import enable

import 405Client

Class OnAirTestApp

OnAirTestApp instproc init {} {
    $self instvar 405_

    $self buildUI ""

    set 405_ [new 405Client]
}

OnAirTestApp instproc buildUI {base} {
    button $base.on -text "On" -command "$self turnOn"
    pack $base.on -side top

    button $base.off -text "Off" -command "$self turnOff"
    pack $base.off -side top

    button $base.exit -text "Exit" -command "exit"
    pack $base.exit -side bottom
}

OnAirTestApp instproc turnOn {} {
    $self instvar 405_

    $405_ onAir_turnOn
}

OnAirTestApp instproc turnOff {} {
    $self instvar 405_

    $405_ onAir_turnOff
}


#
# main func
#

set app [new OnAirTestApp]

vwait forever

# for testing cvs
