# ui-windows.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2001-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

######
#VEUserWindow
# A VEUserWindow is a large-sized window which displays a source of video.
#

Class VEUserWindow

VEUserWindow instproc init {srsm sras} {
    $self instvar srsm_ sras_
    set srsm_ $srsm
    set sras_ $sras
    $self create-window $sras
}

#
# Creates the toplevel window which includes a VideoWidget, some simple
# bindings and a dropdown menu.
#
VEUserWindow instproc create-window {sras} {
    $self instvar srsm_ vw_ sras_ path_

    set w .vw$sras
    toplevel $w
    frame $w.frame
    set sras_ $sras
    set path_ $w

    set userwin_size($sras) 320x240
    set d [split $userwin_size($sras) x]
    set vw_ [new VideoWidget $w.frame.video [lindex $d 0] [lindex $d 1] ]

    pack $w.frame.video -anchor c
    pack $w.frame -expand 1 -fill both

    bind $w <Enter> { focus %W }
    bind $w <q> "$self destroy"
    wm protocol $w WM_DELETE_WINDOW "$self destroy"

    bind $w <ButtonPress-3> "$self trigger_dropmenu"

    # Bind the source to the window.
    $sras attach_window $vw_
}

#
# Properly detaches everything before it destroys itself
#  Note: for some reason, it does not work when called within $self
#        but it works when called from another class.
#
VEUserWindow instproc destroy {} {
    $self instvar sras_ path_ vw_
    set w $path_.frame.video
    $sras_ detach_window $vw_
    $vw_ destroy
    set top [winfo toplevel $w]
    destroy $top
}

#
# When the user right clicks on a VEUserWindow, this method is called to
# create a dropdown menu.
#
VEUserWindow instproc trigger_dropmenu {} {
    global mutebutton
    $self instvar sras_
    global veuw_dropmenu$sras_
    if {[winfo exists .veuw_dropmenu$sras_]} {
	tk_popup [set veuw_dropmenu$sras_] \
		[winfo pointerx .veuw_dropmenu$sras_]\
		[winfo pointery .veuw_dropmenu$sras_]
    } else {
	set veuw_dropmenu$sras_ [menu .veuw_dropmenu$sras_ -tearoff 0]
	[set veuw_dropmenu$sras_] add command -label Dismiss \
		-command "$sras_ select_thumbnail"
	tk_popup [set veuw_dropmenu$sras_] \
		[winfo pointerx .veuw_dropmenu$sras_] \
		[winfo pointery .veuw_dropmenu$sras_]
    }
}
    



