# ui-videoboxmgr.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/vic/ui-videoboxmgr.tcl,v 1.6 2002/02/03 04:39:55 lim Exp $


import VideoBox Configuration

#
# A VideoBoxManager can be used to create a set of VideoBoxes and intelligently
# assign an ActiveSource to each.  A VideoBoxManager is not required in order to
# instantiate a VideoBox.
#
Class VideoBoxManager -superclass Observer -configuration {
	interestingCnames { }
	interestingNicknames { }
}


#-configuration {
#	interestingCnames { 128.32.130.23 128.32.130.24 128.32.130.25 128.32.130.26 128.32.130.27 }
#	interestingNicknames { Landay McCanne }
#}


#
# Create, but do not pack, <i>n</i> VideoBoxes within the provided <i>frame</i> with the provided list of <i>attributes</i>.
#
VideoBoxManager public init { ActiveSourceManager n frame vbAttributes } {
	$self instvar interestingCnames_ interestingNicknames_ videoBoxes_
	lappend interestingCnames_ [$self get_option interestingCnames]
	lappend interestingNicknames_ [$self get_option interestingNicknames]

	$self instvar asm_
	set asm_ $ActiveSourceManager

	set i 0
	while { $i < $n} {
		set vb "vb$i"
		#set vbox [VideoBox $frame.$vb -size medium -border false -nametag true -ui $self -updateSpeed normal]
		set vbox [eval VideoBox $frame.$vb -ui $self $vbAttributes]
#vbxmgr   prev line  (want this to be optional and not a list)     $vbAttributes]
		lappend videoBoxes_ $vbox
		$vbox set_manager_switched
		incr i
	}
}

#
# Return a list of the VideoBoxes managed by this VideoBoxManager.
#
VideoBoxManager public get_videoboxes {} {
	$self instvar videoBoxes_
	return $videoBoxes_
}

#
# Add the <i>cname</i> to the list of cnames the user would like to
# appear in a VideoBox managed by this VideoBoxManager.  The list is
# used to by the VideoBoxManager::is_interested_in method to determine whether
# or not the <i>src</i> it is provided is interesting to that VideoBox.
#
VideoBoxManager public declare_interest_cname { cname } {
	$self instvar interestingCnames_
	lappend interestingCnames_ $cname
}

#
VideoBoxManager public undeclare_interest_cname { cname } {
	$self instvar interestingCnames_
	set i [lsearch $interestingCnames_ $cname]
	set interestingCnames_ [lreplace $interestingCnames_ $i $i]
}

#
VideoBoxManager public undeclare_interest_all_cnames { } {
	$self instvar interestingCnames_
	set interestingCnames_ {}
}

#
VideoBoxManager public get_interesting_cnames { } {
	$self instvar interestingCnames_
	return $interestingCnames_
}

#
# Switches <i>src</i> into a VideoBox if it is interested in it.
#
VideoBoxManager public maybe_switch_in {src} {
	$self instvar asm_
	$asm_ instvar active_

	# make sure that the source is active before you consider or
	# try to switch to it
	if { [$asm_ get_activesource $src] != {} } {
		foreach vb [$self get_videoboxes] {
			if { [$vb is_manager_switched] && \
					[$self is_interested_in $vb $src] } {
				$vb switch $src
			}
		}
	}
}

#
# Return a list of Sources being displayed in VideoBoxes managed by this
# VideoBoxManager.
#
VideoBoxManager public srcs_visible {} {
	lappend srcList

	foreach vb [$self get_videoboxes] {
		lappend srcList [$vb get_src_displayed]
	}

	return $srcList
}


# should check with vbxmgr to make sure all vb's have something in them before switching a non-empty vb
# try VideoBoxManager public vacancies to return true if it cycles through all te vbs it maintains and any are $isEmpty_

#
# If the provided Source <i>src</i> is interesting to this VideoBoxManager,
# return 1.  Otherwise, return 0.
# <br>
# The provided <i>src</i> qualifies as interesting if it is not already
# being displayed in a VideoBox managed by this VideoBoxManager AND:
# <table>
#           <tr><td>   the provided VideoBox <i>vb</i> is currently empty
# </td></tr><tr><td>      OR
# </td></tr><tr><td>   the provided <i>src</i> has an interesting cname or nickname WHILE
# </td></tr><tr><td>   there is a Source being displayed in <i>vb</i> which does not
# </td></tr>
# </table>
#
VideoBoxManager private is_interested_in { vb src } {
	# is $src already in a video box?
	if {[lsearch [$self srcs_visible] $src] == -1} {
		# $src must not already be in a video box
		if [$vb is_empty] {
			# since this VideoBox is empty, yes it is interested in the $src regardless of what the $src is
#vbxmgr			puts stderr "vb ($vb) ---------------------------- INTERESTED in $src cuz empty"
			return 1
		} else {
			# prepare to check if provided Source has an interesting cname
			set interesting_cnames { 128.32.130.23 128.32.130.24 128.32.130.25 128.32.130.26 128.32.130.27 } ;# make sure set to {} if nothing
			set src_cname [$src sdes cname]
			set self_cname [[$vb get_src_displayed] sdes cname]
			# mutate cname list into a list of regular expressions
			foreach cname $interesting_cnames {
				# prepend @ and append $ to force an exact match
				set cname_expr @$cname$
				lappend cname_expr_list $cname_expr
			}

			# prepare to check if provided Source has an interesting nickname
			global src_nickname
			set interesting_nicknames { Landay McCanne } ;# make sure set to {} if nothing
			set src_nick_name $src_nickname($src)
			set self_nickname $src_nickname([$vb get_src_displayed])

			# check if provided Source has an interesting cname
			if {[llength $interesting_cnames] != 0} {
				set like_cname [ $self is_interested_in_thingy $src $cname_expr_list $src_cname $self_cname ]
			} else {
				set like_cname 0
			}

			# check if provided Source has an interesting nickname
			if {[llength $interesting_nicknames] != 0} {
				set like_nickname [ $self is_interested_in_thingy $src $interesting_nicknames $src_nick_name $self_nickname ]
			} else {
				set like_nickname 0
			}

			# return whether or not the provided Source has an interesting cname or nickname
			if { $like_cname || $like_nickname } {
				return 1
			} else {
				return 0
			}
		}
	} else {
		# $src must already be in a video box, so this video box is not interested in it
#vbxmgr		puts stderr "vb ($vb) ---------------------------- NOT interested in $src, cuz it's already in a VideoBox"
		return 0
	}
}

# ??? update w/ change nickname
# does cnames b4 nnames

#
# Return 1 if the given Source <i>src</i> has an interesting thingy.
# The thingy qualifies as interesting if the provided <i>src</i>
# case-insensitive matches a thingy in the provided list of regular
# expressions, <i>interestingRegexps</i>, while there is a Source being
# displayed in a certain VideoBox which does not.
# <br>
# Supply the thingy of the <i>src</i> as <i>srcThingy</i> and the thingy
# of the Source currently being displayed in this certain VideoBox as <i>selfThingy</i>.
#
VideoBoxManager private is_interested_in_thingy { src interestingRegexps srcThingy selfThingy } {
#vbx
	# the video box is non-empty
	foreach regular_expr $interestingRegexps {
		if {[regexp -nocase $regular_expr $selfThingy] == 1} {
			# this video box is already displaying an interesting source, so returning NO
#vbxmgr			puts stderr "vb  ---------------------------- NOT interested in $src \
#vbxmgr					cuz i'm displaying $selfThingy, which is interesting"
			return 0
		}
	}
	# this video box is displaying an uninteresting source
	foreach regular_expr $interestingRegexps {
		if {[regexp -nocase $regular_expr $srcThingy] == 1} {
			# the provided $src is interesting, so returning YES
#vbxmgr			puts stderr "vb  ---------------------------- INTERESTED in $src cuz \
#vbxmgr					$srcThingy is interesting and i'm displaying $selfThingy, which is uninteresting"
			return 1
		}
	}
	# the provided $src is uninteresting, so returning NO
#vbxmgr	puts stderr "vb ---------------------------- NOT interested in $src cuz i'm non-empty \
#vbxmgr			and $srcThingy is uninteresting"
	return 0
}

#
# Returns the VideoBox in the provided <i>vbList</i> that was least recently switched to.
# If the provided list is empty, "" is returned.
#
VideoBoxManager public least_recently_switched { vbList } {
	if { [llength $vbList] < 1 } {
		return ""
	}

	set stalest_stamp [[lindex $vbList 0] get_sequence_stamp]
	foreach vb $vbList {
		if { [$vb get_sequence_stamp] <= $stalest_stamp } {
			set stalest_stamp [$vb get_sequence_stamp]
			set stalest_box $vb
		}
	}
	return $stalest_box
}


VideoBoxManager public drop_thumbnail { src x y } {
	$self instvar videoBoxes_ asm_
	foreach vb $videoBoxes_ {

		set l [winfo rootx $vb]
		set t [winfo rooty $vb]
		set r [expr $l + [winfo width $vb ] - 1]
		set b [expr $t + [winfo height $vb] - 1]

		if { $x >= $l && $x <= $r && $y >= $t && $y <= $b } {
			$vb switch $src
			$vb set_label_textvariable ""
			# FIXME: the name method is defined only on
			# UISource/Video and not on ActiveSource
			$vb set_label_text [[$asm_ get_activesource $src] name]
			return 1
		}
	}

	return 0
}


VideoBoxManager public change_name { src name } {
	$self instvar videoBoxes_ asm_
	set as [$asm_ get_activesource $src]
	foreach vb $videoBoxes_ {
		if { $as == [$vb get_activesource] } {
			$vb set_label_text $name
		}
	}
}

