/*
 * tgmb-mgr.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MASH_TGMB_MGR_H
#define MASH_TGMB_MGR_H

#include "mb/mb-mgr.h"
#include "mb/mb-rcvr.h"


class TGMB_LocalRcvr;
class TCP_MediaPad;


class TGMB_Manager : public MBManager {
public:
	TGMB_Manager() : currFillSA_(NULL), currNextADU_(NULL) {
		this_ = this;
		Tcl_InitHashTable(&htTGMBRcvrs_, TCL_ONE_WORD_KEYS);
	}
	~TGMB_Manager() {
		if (this_==this) this_ = NULL;
		Tcl_DeleteHashTable(&htTGMBRcvrs_);
	}

	virtual Bool isVisible(const PageId &/*pgId*/) { return TRUE; }
	MBBaseRcvr *NewReceiver(const SrcId &srcId, Bool isLocal);
	MBPageObject *NewPageObject(const PageId &pageId, Bool newPage);


	int next_ADU(u_char *pb, int len, srm_src &id,int &pkt_type,int &next);
	int periodic_update(Byte *pb) ;

	int create_dummy_rcvr(int argc, const char * const *argv);

	inline void TGMB_AddReceiver(TGMB_LocalRcvr *pRcvr);
	inline void TGMB_RemoveReceiver(TGMB_LocalRcvr *pRcvr);

	inline Bool IsTGMBRcvr(MBReceiver *pRcvr) {
		return Bool(Tcl_FindHashEntry(&htTGMBRcvrs_,
					      (char*)pRcvr)!=NULL);
	}

	virtual void activity(MBPageObject* /*pPage*/,
			      MBCmd* /*pCmd*/) {}

	TGMB_LocalRcvr *Upgrade(MBReceiver *pRcvr);
	static TGMB_Manager *instance() { return this_; }

private:
	static TGMB_Manager *this_;

	TGMB_LocalRcvr *currFillSA_, *currNextADU_;
	Tcl_HashTable htTGMBRcvrs_;
};


class TGMB_LocalRcvr : public MBReceiver {
public:
	TGMB_LocalRcvr(TGMB_Manager *pMgr, const SrcId &srcId)
		: MBReceiver(pMgr, srcId), prev_(NULL), next_(NULL)
	{
		pMgr->TGMB_AddReceiver(this);
	}
	~TGMB_LocalRcvr() {
		((TGMB_Manager*)getMgr())->TGMB_RemoveReceiver(this);
	}
	Bool Dispatch(MBCmd* pCmd, Page* pPage);

	// virtual from MBReceiver
	MBPageObject *DefinePage(const PageId &pageId, Bool *newFlag=NULL) {
		return MBReceiver::DefinePage(pageId, newFlag);
	}

	void attach(TCP_MediaPad *conn) { conn_ = conn; }
	void HandleSA(Pkt_PgStatus* aPgStatus, int numPgs);

private:
	TCP_MediaPad *conn_;
	TGMB_LocalRcvr *prev_, *next_;

	friend class TGMB_Manager;
};


class
TGMB_DummyLocalRcvr : public MBLocalReceiver {
public:
	TGMB_DummyLocalRcvr(MBManager* pMgr, const SrcId &sid)
		: MBLocalReceiver(pMgr, sid) {}
	virtual ~TGMB_DummyLocalRcvr() {}

	virtual void ChangeStatus(const PageId& /*pgid*/, Bool /*isVisible*/) {
		assert(FALSE && "TGMB_DummyLocalRcvr::ChangeStatus invoked");
		abort();
	}

	// no need to record the operation in this case
	virtual Bool ExecuteInteractive(MBCmd* /*pCmd*/, Page* /*pPage*/) {
		assert(FALSE && "TGMB_DummyLocalRcvr::ExecuteInteractive "
		       "invoked");
		abort();
		return FALSE;
	}

	// excute the command, as a side effect,
	// multicast it
	virtual Bool Dispatch(MBCmd* /*pCmd*/, Page* /*pPage*/) {
		assert(FALSE && "TGMB_DummyLocalRcvr::Dispatch invoked");
		abort();
		return FALSE;
	}

	// virtual from MBReceiver
	virtual MBPageObject *DefinePage(const PageId &/*pageId*/,
				 Bool * /*newFlag*/=FALSE) {
		assert(FALSE && "TGMB_DummyLocalRcvr::DefinePage invoked");
		abort();
		return NULL;
	}

	virtual MBPageObject *NewPageObject() {
		assert(FALSE && "TGMB_DummyLocalRcvr::NewPageObject invoked");
		abort();
		return NULL;
	}

	// fills the next ADU into pktbuf
	virtual int NextADU(Byte * /*pb*/, u_int /*len*/, int& /*nextSize*/) {
		assert(FALSE && "TGMB_DummyLocalRcvr::NextADU invoked");
		abort();
		return 0;
	}

	// handles a session announce msg, from a remote receiver
	// This means that a remote receiver has detected that this local
	// receiver is outdated.
	virtual void HandleSA(Pkt_PgStatus* /*aStats*/, int /*numStats*/) {
		// ignore this function; old versions of mb send out
		// SAs for remote receivers even if they aren't required
		/*assert(FALSE && "TGMB_DummyLocalRcvr::HandleSA invoked");
		abort();*/
	}

	virtual Bool ExecuteCmd(MBCmd* /*pCmd*/, MBPageObject * /*pPage*/) {
		assert(FALSE && "TGMB_DummyLocalRcvr::ExecuteCmd invoked");
		abort();
		return FALSE;
	}

	virtual CanvItemId FindMostRecent(PageId /*pid*/,
					  n_long& /*mostRecent*/,
					  n_long /*timestamp*/) {
		return 0;
	}
};



inline void
TGMB_Manager::TGMB_AddReceiver(TGMB_LocalRcvr *pRcvr) {
	// put this receiver at the head of the fill-sa queue
	if (currFillSA_==NULL) {
		pRcvr->prev_ = pRcvr->next_ = pRcvr;
		currFillSA_  = currNextADU_ = pRcvr;
	} else {
		pRcvr->prev_ = currFillSA_->prev_;
		pRcvr->next_ = currFillSA_;
		pRcvr->prev_->next_ = pRcvr;
		currFillSA_->prev_  = pRcvr;
	}
	int isNew;
	Tcl_HashEntry *pEntry = Tcl_CreateHashEntry(&htTGMBRcvrs_,(char*)pRcvr,
						    &isNew);
	Tcl_SetHashValue(pEntry, 1);
}


inline void
TGMB_Manager::TGMB_RemoveReceiver(TGMB_LocalRcvr *pRcvr) {
	if (pRcvr->prev_ == pRcvr || pRcvr->next_ == pRcvr) {
		currFillSA_ = currNextADU_ = NULL;
	} else {
		pRcvr->prev_->next_ = pRcvr->next_;
		pRcvr->next_->prev_ = pRcvr->prev_;

		if (pRcvr==currFillSA_ ) currFillSA_ = pRcvr->next_;
		if (pRcvr==currNextADU_) currNextADU_= pRcvr->next_;
	}

	pRcvr->prev_ = pRcvr->next_ = NULL;

	Tcl_HashEntry *pEntry = Tcl_FindHashEntry(&htTGMBRcvrs_,(char*)pRcvr);
	if (pEntry) Tcl_DeleteHashEntry(pEntry);
}


#endif /* MASH_TGMB_MGR_H */
