/*
 * real_encoder.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 2001-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <unistd.h>
#include <sys/time.h>
#include "pipe_rend.h"
#include <sys/types.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <errno.h>

// for the RealSDK
#include "pntypes.h"
#include "pnresult.h"
//#include "setdllac.h"
//#include "rmaiids.h" 
// from realproducersdk/samples/live/guids.cpp
#include "pncom.h"
#include "rmaerror.h"
#include "pnwintyp.h"
#include "engtypes.h"
#include "engtargs.h"
#include "rmbldeng.h"
#include "rmaenum.h"
#include "rmmetain.h"
#include "progsink.h"
#include "rmamon.h"
#include "rmapckts.h"
#include "engstats.h"
#include "engcodec.h"

// this is for testing only, it is to buffer video frames before giving it to the real encoder, in the cast that they need to be buffered to stay on track with the audio.
/*struct frameBuffer {
  ULONG32 TimeStamp;
  u_int8_t* frame;
};*/

class RealWindow : public Renderer {
public:
  RealWindow(const char*,const char*,const char*,const char*,int,int,const char*,int,const char*,const char*,const char*,const char*,int,int,int);
  ~RealWindow();
  void setup_encoder();
  int command(int argc, const char*const* argv);
  void setcolor(int x) {};
  void recv(Buffer* b, int, int) {recv(b);};
  void recv(Buffer* b);
  void planar422toI420(char* dest, char* src);
  int SuggestAudioBufferSize() { return nSuggestedAudioBufferSize;};
  void encodeAudio(u_short* buf, int size, ULONG32 now);
private:
  PN_RESULT res;

  IRMABuildEngine *pBuildEngine;
  IRMAMediaSample *pSample;
  UINT32 cVideoFormat_Width;
  UINT32 cVideoFormat_Height;
  UINT32 cVideoFormat_FrameRate;
  UINT32 cAudioFormat_SampleRate;
  UINT32 cAudioFormat_NumChannels;
  UINT32 cAudioFormat_BitsPerSample;
  UINT32 nSuggestedAudioBufferSize;
  IRMAInputPin    *pAudioPin;
  IRMAInputPin    *pVideoPin;
  ULONG32 nAudioTimestamp;
  ULONG32 nSystemTimestamp;
  ULONG32 nAudioBufferDuration;
  INT32 nBufferSize;
  u_int8_t* translate_frame;
  int colorModel;
  //  frameBuffer* videoBuffer;
  int nextIn;
  int nextOut;
  
  // constructor information
  char server[512];
  char filename[512];
  char username[512];
  char password[512];
  int portNum;
  char data_rate[512];
  int save_file;
  char local_file_name[512];
  char title[512];
  char author[512];
  char copyright[512];
  int useAudio;
  int useVideo;
  int sureStream;
};

ULONG32 GetTime();
