/*
 * qm-files.h --
 *
 *      Header file containing the format of the binary mic log files and
 *      QM RTP timestamp file.
 *
 * Copyright (c) 2000-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MASH_QM_FILES_H
#define MASH_QM_FILES_H

#include "config.h"

#ifndef WIN32
#include <sys/time.h>
#else
#include <time.h>
#endif
#include <sys/types.h>

// this is the minimum step size for the audio timestamp; packet records
//   in processed timestamp files are separated by this amount
//
// a proper implementation would do a search through the timestamps file for
//   for the entry with a certain timestamp
//
// to make things easier, I don't do that, and I put in dummy packet records
//   in the timestamp file
#define TS_STEP 160

// I started keeping track of versions at 2
//
// version2:  added version to header
//            added ssrc field to PacketInfo
#define QM_TIMESTAMPS_FILE_VERSION 2


//
// QM RTP Packet File
//

// try to keep it always 400 bytes
struct QMHeader
{
  int numPackets;
  int postProcessed;
  int firstTs;
  int lastTs;
  unsigned int version;
  char reserved[380];
};

struct QMPacketInfo
{
  u_int16_t flags; // don't think I'll need this, but just in case, and
                   // keeps things word aligned
  u_int16_t seqno;
  u_int32_t ts;  // timestamp
  u_int32_t ssrc;  // synchronization source
  int index;
  struct timeval sysTime;
};




//
// QM Microphone Input File
//

// keep at 400 bytes for backward compatibility
struct MicInputHeader {
  int numSamples;
  char reserved[396];
};

struct MicInputInfo {
  int index;
  int val;
  struct timeval sysTime;
};







#endif /* MASH_QM_FILES_H */
