/*
 * timer.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1993-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/srmv2/iohandler/timer.cc,v 1.5 2002/02/03 03:03:57 lim Exp $
 */

extern "C" {
#include <sys/types.h>
#ifndef WIN32
#include <sys/time.h>
#endif        
}
#include "timer.h"

SRMv2_Timer::SRMv2_Timer() : token_(0)
{
}

SRMv2_Timer::~SRMv2_Timer()
{
	if (token_ != 0) 
		cancel();
}

void SRMv2_Timer::msched(int ms)
{
	if (token_) srm_delete_timer_handler(token_);
	token_ = srm_create_timer_handler(ms, dispatch, (void *)this);
}

void SRMv2_Timer::dispatch(void *cd)
{
	SRMv2_Timer* t = (SRMv2_Timer*)cd;
	t->token_ = 0;
	t->timeout();
}

void SRMv2_Timer::cancel()
{
	if (token_ != 0) {
		srm_delete_timer_handler(token_);
		token_ = 0;
	}
}

double SRMv2_Timer::gettimeofday() const
{
	timeval tv;
	::gettimeofday(&tv, 0);
	return (1e6 * double(tv.tv_sec) + double(tv.tv_usec));
}

