/*
 * pktbuf.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/srmv2/net/pktbuf.h,v 1.11 2002/02/03 03:03:19 lim Exp $ (LBL)
 */

#ifndef mash_pktbuf_h
#define mash_pktbuf_h

#ifdef WIN32
#include <winsock.h>
#else
#include <sys/param.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/uio.h>
#endif
#include "config.h"
#include "timer.h"
#include "inet.h"
#include "module.h"

class SRMv2_pktbuf;

/*
 * The base object for performing the outbound path of
 * the application level protocol.
 */
class SRMv2_BufferPool_ {
    public:
	SRMv2_BufferPool_();
	void release(SRMv2_pktbuf*);
	/*
	 * Buffer allocation hooks.
	 */
	virtual SRMv2_pktbuf* alloc(unsigned char type=0);
	SRMv2_pktbuf* freebufs() { return freebufs_;}
    private:
	SRMv2_pktbuf* freebufs_;
	int nbufs_;
};

/*FIXME*/
#define MAXHDR 128
#define PKTBUF_PAD 256
#define PKTBUF_SIZE (MAXHDR + 1024 + PKTBUF_PAD)

typedef double Time;

/* HFSC packet timing measurement info. */
struct PacketMeasure {
	Time pm_arrive;         /* Time it arrives at the queue */
	Time pm_delay;          /* end-to-end delay ?           */
};

class SRMv2_pktbuf : public SRMv2_Buffer {
public:
	SRMv2_pktbuf* next;
	int mode;    /* Packet to be transmitted via unicast/multicast. */
	u_int32_t addr; /* address, */
	u_int16_t port; /* port, and */
	u_int32_t ttl;  /* ttl of packet. */
	int offset;     /*
			 * Byte offset of first byte in fragment. Used during
			 * reassembly.
			 */
	int len;
	u_int8_t* dp;
	u_int8_t data[PKTBUF_SIZE];
	SRMv2_BufferPool_* manager;


	/* HFSC-related information. */
	unsigned char tcid;
	Time pkt_srcTimestamp;
	struct PacketMeasure pkt_measure;
	
	inline void release() {
		manager->release(this);
	}
	/* Copy a pktbuf, but prepend a fresh cmn_hdr. */
	SRMv2_pktbuf* copy(u_char type);
};
#endif
